/*
 * Decompiled with CFR 0.152.
 */
package org.danekja.java.misc.serializable;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import org.danekja.java.util.function.serializable.SerializableFunction;
import org.danekja.java.util.function.serializable.SerializableToDoubleFunction;
import org.danekja.java.util.function.serializable.SerializableToIntFunction;
import org.danekja.java.util.function.serializable.SerializableToLongFunction;

@FunctionalInterface
public interface SerializableComparator<T>
extends Comparator<T>,
Serializable {
    @Override
    default public SerializableComparator<T> reversed() {
        return Collections.reverseOrder(this)::compare;
    }

    @Override
    default public SerializableComparator<T> thenComparing(SerializableComparator<? super T> other) {
        Objects.requireNonNull(other);
        return (c1, c2) -> {
            int res = this.compare(c1, c2);
            return res != 0 ? res : other.compare(c1, c2);
        };
    }

    @Override
    default public <U> SerializableComparator<T> thenComparing(SerializableFunction<? super T, ? extends U> keyExtractor, SerializableComparator<? super U> keyComparator) {
        return this.thenComparing(SerializableComparator.comparing(keyExtractor, keyComparator));
    }

    @Override
    default public <U extends Comparable<? super U>> SerializableComparator<T> thenComparing(SerializableFunction<? super T, ? extends U> keyExtractor) {
        return this.thenComparing(SerializableComparator.comparing(keyExtractor));
    }

    @Override
    default public SerializableComparator<T> thenComparingInt(SerializableToIntFunction<? super T> keyExtractor) {
        return this.thenComparing(SerializableComparator.comparingInt(keyExtractor));
    }

    @Override
    default public SerializableComparator<T> thenComparingLong(SerializableToLongFunction<? super T> keyExtractor) {
        return this.thenComparing(SerializableComparator.comparingLong(keyExtractor));
    }

    @Override
    default public SerializableComparator<T> thenComparingDouble(SerializableToDoubleFunction<? super T> keyExtractor) {
        return this.thenComparing(SerializableComparator.comparingDouble(keyExtractor));
    }

    public static <T extends Comparable<? super T>> SerializableComparator<T> reverseOrder() {
        return Collections.reverseOrder()::compare;
    }

    public static <T extends Comparable<? super T>> SerializableComparator<T> naturalOrder() {
        return Comparator.naturalOrder()::compare;
    }

    public static <T> SerializableComparator<T> nullsFirst(SerializableComparator<? super T> comparator) {
        return Comparator.nullsFirst(comparator)::compare;
    }

    public static <T> SerializableComparator<T> nullsLast(SerializableComparator<? super T> comparator) {
        return Comparator.nullsLast(comparator)::compare;
    }

    public static <T, U> SerializableComparator<T> comparing(SerializableFunction<? super T, ? extends U> keyExtractor, SerializableComparator<? super U> keyComparator) {
        Objects.requireNonNull(keyExtractor);
        Objects.requireNonNull(keyComparator);
        return (c1, c2) -> keyComparator.compare((Object)keyExtractor.apply(c1), (Object)keyExtractor.apply(c2));
    }

    public static <T, U extends Comparable<? super U>> SerializableComparator<T> comparing(SerializableFunction<? super T, ? extends U> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return (c1, c2) -> ((Comparable)keyExtractor.apply(c1)).compareTo(keyExtractor.apply(c2));
    }

    public static <T> SerializableComparator<T> comparingInt(SerializableToIntFunction<? super T> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return (c1, c2) -> Integer.compare(keyExtractor.applyAsInt(c1), keyExtractor.applyAsInt(c2));
    }

    public static <T> SerializableComparator<T> comparingLong(SerializableToLongFunction<? super T> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return (c1, c2) -> Long.compare(keyExtractor.applyAsLong(c1), keyExtractor.applyAsLong(c2));
    }

    public static <T> SerializableComparator<T> comparingDouble(SerializableToDoubleFunction<? super T> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return (c1, c2) -> Double.compare(keyExtractor.applyAsDouble(c1), keyExtractor.applyAsDouble(c2));
    }
}

