/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.mapper;

import org.apache.wicket.request.Url;
import org.apache.wicket.request.mapper.info.PageComponentInfo;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class MapperUtils {
    private MapperUtils() {
    }

    public static PageComponentInfo parsePageComponentInfoParameter(Url.QueryParameter parameter) {
        Args.notNull(parameter, "parameter");
        if (!Strings.isEmpty(parameter.getName()) && Strings.isEmpty(parameter.getValue())) {
            return PageComponentInfo.parse(parameter.getName());
        }
        return null;
    }

    public static PageComponentInfo getPageComponentInfo(Url url) {
        Args.notNull(url, "url");
        for (Url.QueryParameter queryParameter : url.getQueryParameters()) {
            PageComponentInfo pageComponentInfo = MapperUtils.parsePageComponentInfoParameter(queryParameter);
            if (pageComponentInfo == null) continue;
            return pageComponentInfo;
        }
        return null;
    }
}

