/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.apache.sling.ide.eclipse.core.ConfigurationHelper;
import org.apache.sling.ide.eclipse.core.internal.ProjectHelper;
import org.apache.sling.ide.eclipse.ui.internal.Activator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ConvertToContentProjectHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            Object[] result;
            final IProject project = (IProject)((IStructuredSelection)selection).getFirstElement();
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getDisplay().getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
            dialog.setMessage("Select content sync root location (containing the jcr root)");
            dialog.setTitle("Content Sync Root");
            IContainer initialContainer = ProjectHelper.getInferredContentProjectContentRoot((IProject)project);
            if (initialContainer != null) {
                dialog.setInitialElementSelections(Arrays.asList(initialContainer));
            }
            dialog.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (element instanceof IProject) {
                        return ((IProject)element).equals((Object)project);
                    }
                    return element instanceof IContainer;
                }
            });
            dialog.setInput((Object)new IWorkbenchAdapter(){

                public Object getParent(Object o) {
                    return null;
                }

                public String getLabel(Object o) {
                    return null;
                }

                public ImageDescriptor getImageDescriptor(Object object) {
                    return null;
                }

                public Object[] getChildren(Object o) {
                    return new Object[]{project};
                }
            });
            dialog.setAllowMultiple(false);
            dialog.setValidator(new ISelectionStatusValidator(){

                public IStatus validate(Object[] selection) {
                    Object item;
                    if (selection.length > 0 && (item = selection[0]) instanceof IContainer) {
                        IContainer selectedContainer = (IContainer)item;
                        String errorMsg = ProjectHelper.validateContentPackageStructure((IContainer)selectedContainer);
                        if (errorMsg != null) {
                            return new Status(4, "org.apache.sling.ide.eclipse-core", errorMsg);
                        }
                        return new Status(0, "org.apache.sling.ide.eclipse-core", "");
                    }
                    return new Status(4, "org.apache.sling.ide.eclipse-core", "");
                }
            });
            if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length > 0) {
                final IContainer container = (IContainer)result[0];
                IRunnableWithProgress r = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            IResource jcrRoot = container.findMember("jcr_root");
                            if (jcrRoot == null || !(jcrRoot instanceof IFolder)) {
                                MessageDialog.openError((Shell)ConvertToContentProjectHandler.this.getDisplay().getActiveShell(), (String)"Could not convert project", (String)("jcr_root not found under " + String.valueOf(container) + " (or not a Folder)"));
                                return;
                            }
                            ConfigurationHelper.convertToContentPackageProject((IProject)project, (IProgressMonitor)monitor, (IPath)jcrRoot.getProjectRelativePath());
                        }
                        catch (CoreException e) {
                            Activator.getDefault().getPluginLogger().warn("Could not convert project", (Throwable)e);
                            MessageDialog.openError((Shell)ConvertToContentProjectHandler.this.getDisplay().getActiveShell(), (String)"Could not convert project", (String)e.getMessage());
                        }
                    }
                };
                try {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(r);
                }
                catch (Exception e) {
                    Activator.getDefault().getPluginLogger().warn("Could not convert project", (Throwable)e);
                    MessageDialog.openError((Shell)this.getDisplay().getActiveShell(), (String)"Could not convert project", (String)e.getMessage());
                }
            }
        }
        return null;
    }

    public Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

