/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.util;

import java.io.IOException;
import java.io.Writer;
import relocated_for_contentpackage.org.apache.jackrabbit.util.Text;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;

public class HtmlProgressListener
implements ProgressTrackerListener {
    private final Writer out;
    private boolean noScrollTo;
    private long scrollDelay = 1000L;
    private long lastScrolled = 0L;

    public HtmlProgressListener(Writer out) {
        this.out = out;
    }

    public boolean isNoScrollTo() {
        return this.noScrollTo;
    }

    public HtmlProgressListener setNoScrollTo(boolean noScrollTo) {
        this.noScrollTo = noScrollTo;
        return this;
    }

    public long getScrollDelay() {
        return this.scrollDelay;
    }

    public HtmlProgressListener setScrollDelay(long scrollDelay) {
        this.scrollDelay = scrollDelay;
        return this;
    }

    @Override
    public void onError(ProgressTrackerListener.Mode mode, String path, Exception e) {
        this.print(mode, "E", path, e.toString());
    }

    @Override
    public void onMessage(ProgressTrackerListener.Mode mode, String action, String path) {
        this.print(mode, action, path, null);
    }

    private void print(ProgressTrackerListener.Mode mode, String action, String path, String msg) {
        try {
            long now;
            action = Text.encodeIllegalXMLCharacters(action);
            path = Text.encodeIllegalXMLCharacters(path);
            msg = msg == null ? null : Text.encodeIllegalXMLCharacters(msg);
            this.out.write("<span class=\"");
            this.out.write(action);
            this.out.write("\">");
            this.out.write("<b>");
            this.out.write(action);
            this.out.write("</b>&nbsp;");
            this.out.write(path);
            if (msg != null) {
                this.out.write(" (");
                this.out.write(msg);
                this.out.write(")");
            }
            this.out.write("</span><br>\r\n");
            if (!this.noScrollTo && (now = System.currentTimeMillis()) > this.lastScrolled + this.scrollDelay) {
                this.lastScrolled = now;
                this.out.write("<script>\r\n");
                this.out.write("window.scrollTo(0, 1000000);\r\n");
                this.out.write("</script>\r\n");
            }
            this.out.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

