/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.repoinit.parser.operations;

import org.apache.sling.repoinit.parser.operations.OperationVisitor;
import org.apache.sling.repoinit.parser.operations.ServiceUserOperation;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class DisableServiceUser
extends ServiceUserOperation {
    private final String reason;
    private boolean isServiceUser;

    public DisableServiceUser(String username, String reason) {
        super(username, null);
        this.reason = DisableServiceUser.cleanupQuotedString(reason);
        if (this.reason == null || this.reason.length() == 0) {
            throw new IllegalArgumentException("A non-empty reason is required");
        }
    }

    public void setServiceUser(boolean b) {
        this.isServiceUser = b;
    }

    @Override
    public String getParametersDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getParametersDescription());
        if (this.isServiceUser) {
            sb.append(" (service user)");
        } else {
            sb.append(" (regular user)");
        }
        if (this.reason != null) {
            sb.append(" : ");
            sb.append(this.reason);
        }
        return sb.toString();
    }

    @Override
    @NotNull
    public String asRepoInitString() {
        String userType = this.isServiceUser ? "service " : "";
        return String.format("disable %suser %s : %s%n", userType, this.username, DisableServiceUser.escapeQuotes(this.reason));
    }

    @Override
    public void accept(OperationVisitor v) {
        v.visitDisableServiceUser(this);
    }

    public String getReason() {
        return this.reason;
    }

    public boolean isServiceUser() {
        return this.isServiceUser;
    }
}

