/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.spi;

import com.google.common.collect.ImmutableSet;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.sling.commons.caservice.ContextAwareService;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public abstract class MediaFormatProvider
implements ContextAwareService {
    private final Set<MediaFormat> mediaFormats;

    protected MediaFormatProvider(Set<MediaFormat> mediaFormats) {
        this.mediaFormats = mediaFormats;
    }

    protected MediaFormatProvider(Class<?> type) {
        this(MediaFormatProvider.getMediaFormatsFromPublicFields(type));
    }

    public Set<MediaFormat> getMediaFormats() {
        return this.mediaFormats;
    }

    private static Set<MediaFormat> getMediaFormatsFromPublicFields(Class<?> type) {
        HashSet<MediaFormat> params = new HashSet<MediaFormat>();
        try {
            Field[] fields;
            for (Field field : fields = type.getFields()) {
                if (!field.getType().isAssignableFrom(MediaFormat.class)) continue;
                params.add((MediaFormat)field.get(null));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new RuntimeException("Unable to access fields of " + type.getName(), ex);
        }
        return ImmutableSet.copyOf(params);
    }
}

