/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.serialization.impl.vlt;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.vault.fs.api.Filter;
import org.apache.jackrabbit.vault.fs.api.FilterSet;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.PathFilter;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.DefaultMetaInf;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.MetaInf;
import org.apache.jackrabbit.vault.fs.filter.DefaultPathFilter;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.packaging.ExportOptions;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.PackageManager;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.SimpleDistributionRequest;
import org.apache.sling.distribution.component.impl.SettingsUtils;
import org.apache.sling.distribution.serialization.ImportSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VltUtils {
    private static final Logger log = LoggerFactory.getLogger(VltUtils.class);
    private static final String PATH_MAPPING_PROPERTY = "Path-Mapping";
    private static final String MAPPING_SEPARATOR = "=";
    private static final String MAPPING_DELIMITER = ";";

    public static WorkspaceFilter createFilter(DistributionRequest distributionRequest, NavigableMap<String, List<String>> nodeFilters, NavigableMap<String, List<String>> propertyFilters) throws ConfigurationException {
        DefaultWorkspaceFilter filter = new DefaultWorkspaceFilter();
        for (String path : distributionRequest.getPaths()) {
            ArrayList<String> patterns = new ArrayList<String>(Arrays.asList(distributionRequest.getFilters(path)));
            boolean deep = distributionRequest.isDeep(path);
            PathFilterSet nodeFilterSet = new PathFilterSet(path);
            if (!deep) {
                nodeFilterSet.addInclude((Filter)new DefaultPathFilter(VltUtils.quote(path)));
            }
            VltUtils.initFilterSet(nodeFilterSet, nodeFilters, patterns);
            PathFilterSet propertyFilterSet = new PathFilterSet(path);
            VltUtils.initFilterSet(propertyFilterSet, propertyFilters, new ArrayList<String>());
            filter.add(nodeFilterSet, propertyFilterSet);
        }
        return filter;
    }

    public static String[] getPaths(MetaInf metaInf) {
        if (metaInf == null) {
            return null;
        }
        WorkspaceFilter filter = metaInf.getFilter();
        if (filter == null) {
            filter = new DefaultWorkspaceFilter();
        }
        List filterSets = filter.getFilterSets();
        String[] paths = new String[filterSets.size()];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = ((PathFilterSet)filterSets.get(i)).getRoot();
        }
        return paths;
    }

    private static void initFilterSet(PathFilterSet filterSet, NavigableMap<String, List<String>> globalFilters, List<String> patterns) throws ConfigurationException {
        String root = filterSet.getRoot();
        for (String key : globalFilters.descendingKeySet()) {
            if (!root.startsWith(key)) continue;
            patterns.addAll((Collection)globalFilters.get(key));
            break;
        }
        for (String pattern : patterns) {
            FilterSet.Entry<DefaultPathFilter> entry = VltUtils.extractPathPattern(pattern);
            if (entry.isInclude()) {
                filterSet.addInclude((Filter)((PathFilter)entry.getFilter()));
                continue;
            }
            filterSet.addExclude((Filter)((PathFilter)entry.getFilter()));
        }
    }

    public static ExportOptions getExportOptions(WorkspaceFilter filter, String[] packageRoots, String packageGroup, String packageName, String packageVersion, boolean useBinaryReferences, Map<String, String> exportPathMapping) {
        DefaultMetaInf inf = new DefaultMetaInf();
        ExportOptions opts = new ExportOptions();
        inf.setFilter(filter);
        Properties props = new Properties();
        props.setProperty("group", packageGroup);
        props.setProperty("name", packageName);
        props.setProperty("version", packageVersion);
        props.setProperty("useBinaryReferences", String.valueOf(useBinaryReferences));
        if (exportPathMapping != null && !exportPathMapping.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, String> entry : exportPathMapping.entrySet()) {
                if (builder.length() > 0) {
                    builder.append(MAPPING_DELIMITER);
                }
                builder.append(entry.getKey()).append(MAPPING_SEPARATOR).append(entry.getValue());
            }
            props.setProperty(PATH_MAPPING_PROPERTY, builder.toString());
        }
        inf.setProperties(props);
        opts.setMetaInf((MetaInf)inf);
        String root = VltUtils.getPackageRoot(filter.getFilterSets(), packageRoots);
        opts.setRootPath(root);
        opts.setMountPath(root);
        opts.setCompressionLevel(1);
        return opts;
    }

    private static String getPackageRoot(List<PathFilterSet> filterSets, String[] packageRoots) {
        String packageRoot = null;
        if (packageRoots != null && packageRoots.length > 0) {
            for (String currentRoot : packageRoots) {
                boolean filtersHaveCommonRoot = true;
                for (PathFilterSet filterSet : filterSets) {
                    String filterSetRoot = filterSet.getRoot();
                    if (filterSetRoot.startsWith(currentRoot)) continue;
                    filtersHaveCommonRoot = false;
                }
                if (!filtersHaveCommonRoot) continue;
                packageRoot = currentRoot;
                break;
            }
        }
        if (packageRoot == null || !packageRoot.startsWith("/")) {
            packageRoot = "/";
        }
        return packageRoot;
    }

    public static ImportOptions getImportOptions(ImportSettings importSettings) {
        ImportOptions opts = new ImportOptions();
        if (importSettings.getAclHandling() != null) {
            opts.setAccessControlHandling(importSettings.getAclHandling());
        } else {
            opts.setAccessControlHandling(AccessControlHandling.OVERWRITE);
        }
        if (importSettings.getCugHandling() != null) {
            opts.setCugHandling(importSettings.getCugHandling());
        } else {
            opts.setCugHandling(AccessControlHandling.OVERWRITE);
        }
        if (importSettings.getImportMode() != null) {
            opts.setImportMode(importSettings.getImportMode());
        } else {
            opts.setImportMode(ImportMode.UPDATE);
        }
        opts.setPatchKeepInRepo(false);
        if (importSettings.getAutosaveThreshold() >= 0) {
            opts.setAutoSaveThreshold(importSettings.getAutosaveThreshold());
        }
        opts.setStrict(importSettings.isStrict());
        opts.setIdConflictPolicy(importSettings.getIdConflictPolicy());
        opts.setOverwritePrimaryTypesOfFolders(importSettings.isOverwritePrimaryTypesOfFolders());
        return opts;
    }

    public static VaultPackage createPackage(PackageManager packageManager, Session session, ExportOptions options, File tempFolder) throws IOException, RepositoryException {
        File file = File.createTempFile("distr-vault-create-" + System.nanoTime(), ".zip", tempFolder);
        try {
            return packageManager.assemble(session, options, file);
        }
        catch (RepositoryException e) {
            FileUtils.deleteQuietly((File)file);
            throw e;
        }
    }

    public static VaultPackage readPackage(PackageManager packageManager, InputStream stream, File tempFolder) throws IOException {
        File file = File.createTempFile("distr-vault-read-" + System.nanoTime(), ".zip", tempFolder);
        FileOutputStream out = FileUtils.openOutputStream((File)file);
        try {
            IOUtils.copy((InputStream)stream, (OutputStream)out);
            VaultPackage vaultPackage = packageManager.open(file);
            return vaultPackage;
        }
        catch (IOException e) {
            FileUtils.deleteQuietly((File)file);
            throw e;
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public static void deletePackage(VaultPackage vaultPackage) {
        if (vaultPackage == null) {
            return;
        }
        File file = vaultPackage.getFile();
        vaultPackage.close();
        FileUtils.deleteQuietly((File)file);
    }

    public static void deletePackage(JcrPackage jcrPackage) {
        if (jcrPackage == null) {
            return;
        }
        Node node = jcrPackage.getNode();
        jcrPackage.close();
        try {
            if (node != null) {
                node.remove();
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public static File getTempFolder(String tempFolderPath) {
        File directory;
        try {
            directory = new File(tempFolderPath);
            if (!directory.exists() || !directory.isDirectory()) {
                directory = null;
            }
        }
        catch (Throwable e) {
            directory = null;
        }
        return directory;
    }

    public static String findParent(String path, String nodeName) {
        int idx = (path = path.endsWith("/") ? path : path + "/").indexOf(nodeName = "/" + nodeName + "/");
        if (idx < 0) {
            return null;
        }
        return path.substring(0, idx);
    }

    public static String appendMatchAll(String path) {
        path = path.endsWith("/") ? path : path + "/";
        path = path + ".*";
        return path;
    }

    public static TreeMap<String, List<String>> parseFilters(String[] filters) {
        TreeMap<String, List<String>> result = new TreeMap<String, List<String>>();
        if (filters == null || filters.length == 0) {
            return result;
        }
        for (String filter : filters) {
            String path;
            String[] filterParts = filter.split("\\|");
            if (filterParts.length <= 1 || (path = SettingsUtils.removeEmptyEntry(filterParts[0])) == null) continue;
            List<String> filterSet = result.get(path);
            if (filterSet == null) {
                filterSet = new ArrayList<String>();
            }
            for (int i = 1; i < filterParts.length; ++i) {
                String filterPart = SettingsUtils.removeEmptyEntry(filterParts[i]);
                if (filterPart == null) continue;
                filterSet.add(filterPart);
            }
            result.put(path, filterSet);
        }
        return result;
    }

    public static boolean isSupported(DistributionRequest request) {
        DistributionRequestType requestType = request.getRequestType();
        if (DistributionRequestType.DELETE.equals((Object)requestType)) {
            for (String path : request.getPaths()) {
                if (VltUtils.findParent(path, "rep:policy") == null) continue;
                return false;
            }
        }
        return true;
    }

    public static DistributionRequest sanitizeRequest(DistributionRequest request) {
        DistributionRequestType requestType = request.getRequestType();
        if (!DistributionRequestType.ADD.equals((Object)requestType) && !DistributionRequestType.DELETE.equals((Object)requestType)) {
            return request;
        }
        HashSet<String> deepPaths = new HashSet<String>();
        ArrayList<String> paths = new ArrayList<String>();
        HashMap<String, String[]> filters = new HashMap<String, String[]>();
        for (String path : request.getPaths()) {
            if (VltUtils.findParent(path, "rep:policy") != null) {
                if (DistributionRequestType.DELETE.equals((Object)requestType)) {
                    throw new IllegalArgumentException("cannot distribute DELETE node " + path);
                }
                if (DistributionRequestType.ADD.equals((Object)requestType)) {
                    String newPath = VltUtils.findParent(path, "rep:policy") + "/rep:policy";
                    paths.add(newPath);
                    deepPaths.add(newPath);
                    log.debug("changed distribution path {} to deep path {}", (Object)path, (Object)newPath);
                }
            } else if (request.isDeep(path)) {
                paths.add(path);
                deepPaths.add(path);
            } else {
                paths.add(path);
            }
            filters.put(path, request.getFilters(path));
        }
        return new SimpleDistributionRequest(requestType, paths.toArray(new String[paths.size()]), deepPaths, filters);
    }

    private static FilterSet.Entry<DefaultPathFilter> extractPathPattern(String pattern) throws ConfigurationException {
        FilterSet.Entry result = pattern.startsWith("+") ? new FilterSet.Entry((Filter)new DefaultPathFilter(pattern.substring(1)), true) : (pattern.startsWith("-") ? new FilterSet.Entry((Filter)new DefaultPathFilter(pattern.substring(1)), false) : new FilterSet.Entry((Filter)new DefaultPathFilter(pattern), true));
        return result;
    }

    private static String quote(String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            return "/" + Pattern.quote(path.substring(1));
        }
        return Pattern.quote(path);
    }
}

