/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl.importer;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.log.impl.DefaultDistributionLog;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageInfo;
import org.apache.sling.distribution.packaging.impl.DistributionPackageImporter;
import org.apache.sling.distribution.packaging.impl.DistributionPackageUtils;
import org.apache.sling.distribution.transport.DistributionTransportSecretProvider;
import org.apache.sling.distribution.transport.impl.DistributionEndpoint;
import org.apache.sling.distribution.transport.impl.DistributionTransport;
import org.apache.sling.distribution.transport.impl.DistributionTransportContext;
import org.apache.sling.distribution.transport.impl.HttpConfiguration;
import org.apache.sling.distribution.transport.impl.SimpleHttpDistributionTransport;
import org.jetbrains.annotations.NotNull;

public class RemoteDistributionPackageImporter
implements DistributionPackageImporter {
    private final Map<String, DistributionTransport> transportHandlers = new HashMap<String, DistributionTransport>();
    private final DistributionTransportContext distributionContext = new DistributionTransportContext();

    public RemoteDistributionPackageImporter(DefaultDistributionLog log, DistributionTransportSecretProvider distributionTransportSecretProvider, Map<String, String> endpointsMap, HttpConfiguration httpConfiguration) {
        if (distributionTransportSecretProvider == null) {
            throw new IllegalArgumentException("distributionTransportSecretProvider is required");
        }
        for (Map.Entry<String, String> entry : endpointsMap.entrySet()) {
            String endpointKey = entry.getKey();
            String endpoint = entry.getValue();
            if (endpoint == null || endpoint.length() <= 0) continue;
            this.transportHandlers.put(endpointKey, new SimpleHttpDistributionTransport(log, new DistributionEndpoint(endpoint), null, distributionTransportSecretProvider, httpConfiguration));
        }
    }

    @Override
    public void importPackage(@NotNull ResourceResolver resourceResolver, @NotNull DistributionPackage distributionPackage) throws DistributionException {
        DistributionPackageInfo info = distributionPackage.getInfo();
        String queueName = DistributionPackageUtils.getQueueName(info);
        DistributionTransport distributionTransport = this.transportHandlers.get(queueName);
        if (distributionTransport != null) {
            distributionTransport.deliverPackage(resourceResolver, distributionPackage, this.distributionContext);
        } else {
            for (DistributionTransport transportHandler : this.transportHandlers.values()) {
                transportHandler.deliverPackage(resourceResolver, distributionPackage, this.distributionContext);
            }
        }
    }

    @Override
    @NotNull
    public DistributionPackageInfo importStream(@NotNull ResourceResolver resourceResolver, @NotNull InputStream stream) throws DistributionException {
        throw new DistributionException("not supported");
    }
}

