/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import java.util.UUID;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageInfo;
import org.apache.sling.distribution.packaging.impl.AbstractDistributionPackageBuilder;
import org.apache.sling.distribution.packaging.impl.DistributionPackageUtils;
import org.apache.sling.distribution.packaging.impl.ResourceDistributionPackage;
import org.apache.sling.distribution.serialization.DistributionContentSerializer;
import org.apache.sling.distribution.serialization.DistributionExportFilter;
import org.apache.sling.distribution.serialization.DistributionExportOptions;
import org.apache.sling.distribution.serialization.impl.vlt.VltUtils;
import org.apache.sling.distribution.util.impl.DigestUtils;
import org.apache.sling.distribution.util.impl.FileBackedMemoryOutputStream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceDistributionPackageBuilder
extends AbstractDistributionPackageBuilder {
    private static final String PREFIX_PATH = "/var/sling/distribution/packages/";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String packagesPath;
    private final File tempDirectory;
    private final DistributionContentSerializer distributionContentSerializer;
    private final int fileThreshold;
    private final FileBackedMemoryOutputStream.MemoryUnit memoryUnit;
    private final boolean useOffHeapMemory;
    private final String digestAlgorithm;
    private final NavigableMap<String, List<String>> nodeFilters;
    private final NavigableMap<String, List<String>> propertyFilters;

    public ResourceDistributionPackageBuilder(String type, DistributionContentSerializer distributionContentSerializer, String tempFilesFolder, int fileThreshold, FileBackedMemoryOutputStream.MemoryUnit memoryUnit, boolean useOffHeapMemory, String digestAlgorithm, String[] nodeFilters, String[] propertyFilters) {
        super(type);
        this.distributionContentSerializer = distributionContentSerializer;
        this.nodeFilters = VltUtils.parseFilters(nodeFilters);
        this.propertyFilters = VltUtils.parseFilters(propertyFilters);
        this.packagesPath = PREFIX_PATH + type + "/data";
        this.tempDirectory = VltUtils.getTempFolder(tempFilesFolder);
        this.fileThreshold = fileThreshold;
        this.memoryUnit = memoryUnit;
        this.useOffHeapMemory = useOffHeapMemory;
        this.digestAlgorithm = digestAlgorithm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DistributionPackage createPackageForAdd(@NotNull ResourceResolver resourceResolver, @NotNull DistributionRequest request) throws DistributionException {
        ResourceDistributionPackage distributionPackage;
        try {
            FileBackedMemoryOutputStream outputStream = null;
            DigestOutputStream digestStream = null;
            String digestMessage = null;
            try {
                outputStream = new FileBackedMemoryOutputStream(this.fileThreshold, this.memoryUnit, this.useOffHeapMemory, this.tempDirectory, "distrpck-create-", "." + this.getType());
                if (this.digestAlgorithm != null) {
                    digestStream = DigestUtils.openDigestOutputStream(outputStream, this.digestAlgorithm);
                    this.export(resourceResolver, request, digestStream);
                } else {
                    this.export(resourceResolver, request, outputStream);
                }
                outputStream.flush();
                if (this.digestAlgorithm != null) {
                    digestMessage = DigestUtils.readDigestMessage(digestStream);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                IOUtils.closeQuietly(digestStream);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)outputStream);
            IOUtils.closeQuietly((OutputStream)digestStream);
            Resource packagesRoot = DistributionPackageUtils.getPackagesRoot(resourceResolver, this.packagesPath);
            InputStream inputStream = null;
            Resource packageResource = null;
            try {
                inputStream = outputStream.openWrittenDataInputStream();
                packageResource = this.uploadStream(resourceResolver, packagesRoot, inputStream, outputStream.size(), request);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
                outputStream.clean();
            }
            distributionPackage = new ResourceDistributionPackage(packageResource, this.getType(), resourceResolver, this.digestAlgorithm, digestMessage, null);
        }
        catch (IOException e) {
            throw new DistributionException(e);
        }
        return distributionPackage;
    }

    private void export(@NotNull ResourceResolver resourceResolver, @NotNull DistributionRequest request, OutputStream outputStream) throws DistributionException {
        DistributionExportFilter filter = this.distributionContentSerializer.isRequestFiltering() ? null : DistributionExportFilter.createFilter(request, this.nodeFilters, this.propertyFilters);
        DistributionExportOptions distributionExportOptions = new DistributionExportOptions(request, filter);
        this.distributionContentSerializer.exportToStream(resourceResolver, distributionExportOptions, outputStream);
    }

    @Override
    protected DistributionPackage readPackageInternal(@NotNull ResourceResolver resourceResolver, @NotNull InputStream inputStream) throws DistributionException {
        try {
            Resource packagesRoot = DistributionPackageUtils.getPackagesRoot(resourceResolver, this.packagesPath);
            Resource packageResource = this.uploadStream(resourceResolver, packagesRoot, inputStream, -1L, null);
            return new ResourceDistributionPackage(packageResource, this.getType(), resourceResolver, null, null, null);
        }
        catch (PersistenceException e) {
            throw new DistributionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean installPackageInternal(@NotNull ResourceResolver resourceResolver, @NotNull InputStream inputStream) throws DistributionException {
        try {
            this.distributionContentSerializer.importFromStream(resourceResolver, inputStream);
            boolean bl = true;
            return bl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    @Override
    protected DistributionPackage getPackageInternal(@NotNull ResourceResolver resourceResolver, @NotNull String id) {
        try {
            Resource packagesRoot = DistributionPackageUtils.getPackagesRoot(resourceResolver, this.packagesPath);
            Resource packageResource = packagesRoot.getChild(id);
            if (packageResource == null) {
                return null;
            }
            return new ResourceDistributionPackage(packageResource, this.getType(), resourceResolver, null, null, null);
        }
        catch (PersistenceException e) {
            return null;
        }
    }

    private Resource uploadStream(ResourceResolver resourceResolver, Resource parent, InputStream stream, long size, DistributionRequest request) throws PersistenceException {
        Resource r;
        String name;
        this.log.debug("uploading stream");
        if (size == -1L) {
            HashMap<String, Object> info = new HashMap<String, Object>();
            DistributionPackageUtils.readInfo(stream, info);
            this.log.debug("read header {}", info);
            Object remoteId = info.get("remote.package.id");
            if (remoteId != null) {
                name = remoteId.toString();
                if (name.contains("/")) {
                    name = name.substring(name.lastIndexOf(47) + 1);
                }
                this.log.debug("preserving remote id {}", (Object)name);
            } else {
                name = "dstrpck-" + System.currentTimeMillis() + "-" + UUID.randomUUID().toString();
                this.log.debug("generating a new id {}", (Object)name);
            }
        } else {
            name = "dstrpck-" + System.currentTimeMillis() + "-" + UUID.randomUUID().toString();
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("sling:resourceType", "sling:Folder");
        props.put("type", this.getType());
        if (null != request) {
            DistributionPackageInfo info = new DistributionPackageInfo(this.getType());
            DistributionPackageUtils.fillInfo(info, request);
            props.put("request.paths", info.getPaths());
            props.put("request.deepPaths", info.get("request.deepPaths"));
        }
        if (size != -1L) {
            props.put("size", size);
        }
        if ((r = resourceResolver.getResource(parent, name)) != null) {
            resourceResolver.delete(r);
        } else {
            Resource parentResource = ResourceUtil.getOrCreateResource((ResourceResolver)resourceResolver, (String)parent.getPath(), (String)"nt:unstructured", (String)"nt:unstructured", (boolean)true);
            this.log.debug("created parent {}", (Object)parentResource.getPath());
        }
        Resource resource = resourceResolver.create(parent, name, props);
        try {
            DistributionPackageUtils.uploadStream(resource, stream);
        }
        catch (RepositoryException e) {
            throw new PersistenceException("cannot upload stream", (Throwable)e);
        }
        resourceResolver.commit();
        return resource;
    }

    @NotNull
    public Iterator<ResourceDistributionPackage> getPackages(@NotNull ResourceResolver resourceResolver) throws DistributionException {
        try {
            Resource packagesRoot = DistributionPackageUtils.getPackagesRoot(resourceResolver, this.packagesPath);
            return new ResourceDistributionPackageIterator(packagesRoot, resourceResolver, this.getType());
        }
        catch (PersistenceException e) {
            throw new DistributionException("Failed to get the package list", e);
        }
    }

    private static final class ResourceDistributionPackageIterator
    implements Iterator<ResourceDistributionPackage> {
        final Iterator<Resource> packages;
        final ResourceResolver resourceResolver;
        final String type;

        private ResourceDistributionPackageIterator(@NotNull Resource packagesRoot, @NotNull ResourceResolver resourceResolver, @NotNull String type) {
            this.packages = packagesRoot.listChildren();
            this.resourceResolver = resourceResolver;
            this.type = type;
        }

        @Override
        public boolean hasNext() {
            return this.packages.hasNext();
        }

        @Override
        public ResourceDistributionPackage next() {
            Resource packageResource = this.packages.next();
            return new ResourceDistributionPackage(packageResource, this.type, this.resourceResolver, null, null, null);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

