/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2davex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.spi.ChildInfo;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.NodeInfo;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi2davex.ItemInfoImpl;
import org.apache.jackrabbit.spi2davex.PropertyInfoImpl;

public class NodeInfoImpl
extends ItemInfoImpl
implements NodeInfo {
    private NodeId id;
    private Name primaryNodeTypeName;
    private Name[] mixinNodeTypeNames = Name.EMPTY_ARRAY;
    private final List<PropertyId> propertyIds = new ArrayList<PropertyId>(8);
    private List<ChildInfo> childInfos = null;

    public NodeInfoImpl(NodeId id, Path path) throws RepositoryException {
        super(path, true);
        this.id = id;
    }

    @Override
    public NodeId getId() {
        return this.id;
    }

    @Override
    public int getIndex() {
        return this.getPath().getNormalizedIndex();
    }

    @Override
    public Name getNodetype() {
        return this.primaryNodeTypeName;
    }

    @Override
    public Name[] getMixins() {
        return this.mixinNodeTypeNames;
    }

    @Override
    public PropertyId[] getReferences() {
        return new PropertyId[0];
    }

    @Override
    public Iterator<PropertyId> getPropertyIds() {
        return this.propertyIds.iterator();
    }

    @Override
    public Iterator<ChildInfo> getChildInfos() {
        return this.childInfos == null ? null : this.childInfos.iterator();
    }

    void setPropertyInfos(PropertyInfoImpl[] propInfos, IdFactory idFactory) throws RepositoryException {
        boolean resolveUUID = false;
        for (PropertyInfoImpl propInfo : propInfos) {
            Name pn = propInfo.getId().getName();
            if (NameConstants.JCR_UUID.equals(pn)) {
                this.id = idFactory.createNodeId(propInfo.getValues()[0].getString());
                resolveUUID = true;
                continue;
            }
            if (NameConstants.JCR_PRIMARYTYPE.equals(pn)) {
                this.primaryNodeTypeName = propInfo.getValues()[0].getName();
                continue;
            }
            if (!NameConstants.JCR_MIXINTYPES.equals(pn)) continue;
            QValue[] vs = propInfo.getValues();
            Name[] mixins = new Name[vs.length];
            for (int i = 0; i < vs.length; ++i) {
                mixins[i] = vs[i].getName();
            }
            this.mixinNodeTypeNames = mixins;
        }
        this.propertyIds.clear();
        for (PropertyInfoImpl propInfo : propInfos) {
            if (resolveUUID) {
                propInfo.setId(idFactory.createPropertyId(this.id, propInfo.getName()));
            }
            this.propertyIds.add(propInfo.getId());
        }
    }

    void addChildInfo(ChildInfo childInfo) {
        if (this.childInfos == null) {
            this.childInfos = new ArrayList<ChildInfo>();
        }
        this.childInfos.add(childInfo);
    }

    void markAsLeafNode() {
        this.childInfos = Collections.emptyList();
    }

    boolean isCompleted() {
        return this.id != null && this.primaryNodeTypeName != null && !this.propertyIds.isEmpty();
    }

    String getUniqueID() {
        if (this.id.getUniqueID() != null && this.id.getPath() == null) {
            return this.id.getUniqueID();
        }
        return null;
    }
}

