/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.provider.consumer;

import io.vertx.core.Context;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.InvocationRuntimeType;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.exception.Exceptions;
import org.apache.servicecomb.core.invocation.InvocationFactory;
import org.apache.servicecomb.core.provider.consumer.MicroserviceReferenceConfig;
import org.apache.servicecomb.core.provider.consumer.ReferenceConfig;
import org.apache.servicecomb.foundation.common.utils.AsyncUtils;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.ExceptionFactory;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;

public final class InvokerUtils {
    public static <T> T syncInvoke(String microserviceName, String transport, String schemaId, String operationId, Map<String, Object> swaggerArguments, Type responseType) {
        Invocation invocation = InvokerUtils.createInvocation(microserviceName, transport, schemaId, operationId, swaggerArguments, responseType);
        return (T)InvokerUtils.syncInvoke(invocation);
    }

    public static void reactiveInvoke(String microserviceName, String transport, String schemaId, String operationId, Map<String, Object> swaggerArguments, Type responseType, AsyncResponse asyncResp) {
        Invocation invocation = InvokerUtils.createInvocation(microserviceName, transport, schemaId, operationId, swaggerArguments, responseType);
        InvokerUtils.reactiveInvoke(invocation, asyncResp);
    }

    public static <T> T syncInvoke(String microserviceName, String schemaId, String operationId, Map<String, Object> swaggerArguments, Type responseType) {
        return InvokerUtils.syncInvoke(microserviceName, null, schemaId, operationId, swaggerArguments, responseType);
    }

    public static void reactiveInvoke(String microserviceName, String schemaId, String operationId, Map<String, Object> swaggerArguments, Type responseType, AsyncResponse asyncResp) {
        InvokerUtils.reactiveInvoke(microserviceName, null, schemaId, operationId, swaggerArguments, responseType, asyncResp);
    }

    public static Invocation createInvocation(String microserviceName, String transport, String schemaId, String operationId, Map<String, Object> swaggerArguments, Type responseType) {
        long startCreateInvocation = System.nanoTime();
        MicroserviceReferenceConfig microserviceReferenceConfig = SCBEngine.getInstance().getOrCreateReferenceConfig(microserviceName);
        if (microserviceReferenceConfig == null) {
            throw new InvocationException((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, (Object)new CommonExceptionData(String.format("Failed to invoke service %s. Maybe service not registered or no active instance.", microserviceName)));
        }
        MicroserviceMeta microserviceMeta = microserviceReferenceConfig.getMicroserviceMeta();
        SchemaMeta schemaMeta = microserviceMeta.ensureFindSchemaMeta(schemaId);
        OperationMeta operationMeta = schemaMeta.ensureFindOperation(operationId);
        ReferenceConfig referenceConfig = microserviceReferenceConfig.createReferenceConfig(transport, operationMeta);
        InvocationRuntimeType invocationRuntimeType = operationMeta.buildBaseConsumerRuntimeType();
        invocationRuntimeType.setSuccessResponseType(responseType);
        Invocation result = InvocationFactory.forConsumer(referenceConfig, operationMeta, invocationRuntimeType, swaggerArguments);
        result.getInvocationStageTrace().startCreateInvocation(startCreateInvocation);
        result.getInvocationStageTrace().finishCreateInvocation();
        return result;
    }

    @Deprecated
    public static Object syncInvoke(String microserviceName, String transport, String schemaId, String operationId, Map<String, Object> swaggerArguments) {
        return InvokerUtils.syncInvoke(microserviceName, transport, schemaId, operationId, swaggerArguments, null);
    }

    public static Object syncInvoke(Invocation invocation) throws InvocationException {
        Response response = InvokerUtils.innerSyncInvoke(invocation);
        if (response.isSucceed()) {
            return response.getResult();
        }
        throw ExceptionFactory.convertConsumerException((Throwable)((Throwable)response.getResult()));
    }

    public static boolean isInEventLoop() {
        return Context.isOnEventLoopThread();
    }

    public static Response innerSyncInvoke(Invocation invocation) {
        if (InvokerUtils.isInEventLoop() && ((Boolean)SCBEngine.getInstance().getEnvironment().getProperty("servicecomb.invocation.enableEventLoopBlockingCallCheck", Boolean.TYPE, (Object)true)).booleanValue()) {
            throw new IllegalStateException("Can not execute sync logic in event loop.");
        }
        return InvokerUtils.toSync(InvokerUtils.invoke(invocation), invocation.getWaitTime());
    }

    public static void reactiveInvoke(Invocation invocation, AsyncResponse asyncResp) {
        InvokerUtils.invoke(invocation).whenComplete((r, e) -> {
            if (e == null) {
                asyncResp.complete(r);
            } else {
                asyncResp.consumerFail(e);
            }
        });
    }

    public static boolean isSyncMethod(Method method) {
        return !InvokerUtils.isAsyncMethod(method);
    }

    public static boolean isAsyncMethod(Method method) {
        return method.getReturnType().equals(CompletableFuture.class);
    }

    public static <T> T toSync(CompletableFuture<T> future, long waitInMillis) {
        try {
            if (waitInMillis > 0L) {
                return future.get(waitInMillis, TimeUnit.MILLISECONDS);
            }
            return future.get();
        }
        catch (ExecutionException executionException) {
            throw AsyncUtils.rethrow((Throwable)executionException.getCause());
        }
        catch (TimeoutException timeoutException) {
            throw new InvocationException((Response.StatusType)Response.Status.REQUEST_TIMEOUT, (Object)new CommonExceptionData("Invocation Timeout."), (Throwable)timeoutException);
        }
        catch (Throwable e) {
            throw AsyncUtils.rethrow((Throwable)e);
        }
    }

    public static CompletableFuture<Response> invoke(Invocation invocation) {
        invocation.onStart(null);
        return ((CompletableFuture)invocation.getMicroserviceMeta().getConsumerFilterChain().onFilter(invocation).exceptionally(throwable -> Exceptions.toConsumerResponse(invocation, throwable))).whenComplete((response, throwable) -> invocation.onFinish((Response)response));
    }
}

