/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocumentState;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.ICOSParser;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccessStreamCache;

public class COSDocument
extends COSBase
implements Closeable {
    private static final Log LOG = LogFactory.getLog(COSDocument.class);
    private float version = 1.4f;
    private final Map<COSObjectKey, COSObject> objectPool = new HashMap<COSObjectKey, COSObject>();
    private final Map<COSObjectKey, Long> xrefTable = new HashMap<COSObjectKey, Long>();
    private final List<COSStream> streams = new ArrayList<COSStream>();
    private COSDictionary trailer;
    private boolean isDecrypted = false;
    private long startXref;
    private boolean closed = false;
    private boolean isXRefStream;
    private boolean hasHybridXRef = false;
    private final RandomAccessStreamCache streamCache;
    private long highestXRefObjectNumber;
    private final ICOSParser parser;
    private final COSDocumentState documentState = new COSDocumentState();

    public COSDocument() {
        this(IOUtils.createMemoryOnlyStreamCache());
    }

    public COSDocument(ICOSParser parser) {
        this(IOUtils.createMemoryOnlyStreamCache(), parser);
    }

    public COSDocument(RandomAccessStreamCache.StreamCacheCreateFunction streamCacheCreateFunction) {
        this(streamCacheCreateFunction, null);
    }

    public COSDocument(RandomAccessStreamCache.StreamCacheCreateFunction streamCacheCreateFunction, ICOSParser parser) {
        this.streamCache = this.getStreamCache(streamCacheCreateFunction);
        this.parser = parser;
    }

    private RandomAccessStreamCache getStreamCache(RandomAccessStreamCache.StreamCacheCreateFunction streamCacheCreateFunction) {
        if (streamCacheCreateFunction == null) {
            return null;
        }
        try {
            return streamCacheCreateFunction.create();
        }
        catch (IOException exception1) {
            LOG.warn((Object)"An error occurred when creating stream cache. Using memory only cache as fallback.", (Throwable)exception1);
            try {
                return IOUtils.createMemoryOnlyStreamCache().create();
            }
            catch (IOException exception2) {
                LOG.warn((Object)"An error occurred when creating stream cache for fallback.", (Throwable)exception2);
                return null;
            }
        }
    }

    public COSStream createCOSStream() {
        COSStream stream = new COSStream(this.streamCache);
        this.streams.add(stream);
        return stream;
    }

    public COSStream createCOSStream(COSDictionary dictionary, long startPosition, long streamLength) throws IOException {
        COSStream stream = new COSStream(this.streamCache, this.parser.createRandomAccessReadView(startPosition, streamLength));
        dictionary.forEach(stream::setItem);
        stream.setKey(dictionary.getKey());
        return stream;
    }

    public COSDictionary getLinearizedDictionary() {
        List objectKeys = this.xrefTable.entrySet().stream().filter(e -> (Long)e.getValue() > 0L).sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).collect(Collectors.toList());
        for (COSObjectKey objectKey : objectKeys) {
            COSDictionary dic;
            COSObject objectFromPool = this.getObjectFromPool(objectKey);
            COSBase realObject = objectFromPool.getObject();
            if (!(realObject instanceof COSDictionary) || (dic = (COSDictionary)realObject).getItem(COSName.LINEARIZED) == null) continue;
            return dic;
        }
        return null;
    }

    public List<COSObject> getObjectsByType(COSName type) {
        return this.getObjectsByType(type, null);
    }

    public List<COSObject> getObjectsByType(COSName type1, COSName type2) {
        ArrayList<COSObjectKey> originKeys = new ArrayList<COSObjectKey>(this.xrefTable.keySet());
        List<COSObject> retval = this.getObjectsByType(originKeys, type1, type2);
        if (originKeys.size() < this.xrefTable.size()) {
            ArrayList<COSObjectKey> additionalKeys = new ArrayList<COSObjectKey>(this.xrefTable.keySet());
            additionalKeys.removeAll(originKeys);
            retval.addAll(this.getObjectsByType(additionalKeys, type1, type2));
        }
        return retval;
    }

    private List<COSObject> getObjectsByType(List<COSObjectKey> keys, COSName type1, COSName type2) {
        ArrayList<COSObject> retval = new ArrayList<COSObject>();
        for (COSObjectKey objectKey : keys) {
            COSName dictType;
            COSObject objectFromPool = this.getObjectFromPool(objectKey);
            COSBase realObject = objectFromPool.getObject();
            if (!(realObject instanceof COSDictionary) || !type1.equals(dictType = ((COSDictionary)realObject).getCOSName(COSName.TYPE)) && (type2 == null || !type2.equals(dictType))) continue;
            retval.add(objectFromPool);
        }
        return retval;
    }

    public void setVersion(float versionValue) {
        this.version = versionValue;
    }

    public float getVersion() {
        return this.version;
    }

    public void setDecrypted() {
        this.isDecrypted = true;
    }

    public boolean isDecrypted() {
        return this.isDecrypted;
    }

    public boolean isEncrypted() {
        return this.trailer != null && this.trailer.getCOSDictionary(COSName.ENCRYPT) != null;
    }

    public COSDictionary getEncryptionDictionary() {
        return this.trailer.getCOSDictionary(COSName.ENCRYPT);
    }

    public void setEncryptionDictionary(COSDictionary encDictionary) {
        this.trailer.setItem(COSName.ENCRYPT, (COSBase)encDictionary);
    }

    public COSArray getDocumentID() {
        return this.getTrailer().getCOSArray(COSName.ID);
    }

    public void setDocumentID(COSArray id) {
        this.getTrailer().setItem(COSName.ID, (COSBase)id);
    }

    public COSDictionary getTrailer() {
        return this.trailer;
    }

    public void setTrailer(COSDictionary newTrailer) {
        this.trailer = newTrailer;
        this.trailer.getUpdateState().setOriginDocumentState(this.documentState);
    }

    public long getHighestXRefObjectNumber() {
        return this.highestXRefObjectNumber;
    }

    public void setHighestXRefObjectNumber(long highestXRefObjectNumber) {
        this.highestXRefObjectNumber = highestXRefObjectNumber;
    }

    @Override
    public void accept(ICOSVisitor visitor) throws IOException {
        visitor.visitFromDocument(this);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        IOException firstException = null;
        for (COSObject object : this.objectPool.values()) {
            COSBase cosObject;
            if (object.isObjectNull() || !((cosObject = object.getObject()) instanceof COSStream)) continue;
            firstException = IOUtils.closeAndLogException((Closeable)((COSStream)cosObject), (Log)LOG, (String)"COSStream", (IOException)firstException);
        }
        for (COSStream stream : this.streams) {
            firstException = IOUtils.closeAndLogException((Closeable)stream, (Log)LOG, (String)"COSStream", firstException);
        }
        if (this.streamCache != null) {
            firstException = IOUtils.closeAndLogException((Closeable)this.streamCache, (Log)LOG, (String)"Stream Cache", firstException);
        }
        this.closed = true;
        if (firstException != null) {
            throw firstException;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public COSObject getObjectFromPool(COSObjectKey key) {
        COSObject obj = null;
        if (key != null) {
            obj = this.objectPool.computeIfAbsent(key, k -> new COSObject((COSObjectKey)k, this.parser));
        }
        return obj;
    }

    public void addXRefTable(Map<COSObjectKey, Long> xrefTableValues) {
        this.xrefTable.putAll(xrefTableValues);
    }

    public Map<COSObjectKey, Long> getXrefTable() {
        return this.xrefTable;
    }

    public void setStartXref(long startXrefValue) {
        this.startXref = startXrefValue;
    }

    public long getStartXref() {
        return this.startXref;
    }

    public boolean isXRefStream() {
        return this.isXRefStream;
    }

    public void setIsXRefStream(boolean isXRefStreamValue) {
        this.isXRefStream = isXRefStreamValue;
    }

    public boolean hasHybridXRef() {
        return this.hasHybridXRef;
    }

    public void setHasHybridXRef() {
        this.hasHybridXRef = true;
    }

    public COSDocumentState getDocumentState() {
        return this.documentState;
    }
}

