/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.webbeans.test.profields;

import java.util.ArrayList;
import java.util.Collection;

import org.junit.Assert;

import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.test.AbstractUnitTest;
import org.apache.webbeans.test.profields.beans.classproducer.MyProductBean;
import org.apache.webbeans.test.profields.beans.classproducer.MyProductProducer;
import org.apache.webbeans.test.profields.beans.classproducer.ProductInjectedBean;
import org.junit.Test;

public class ProductProducerTest extends AbstractUnitTest
{
    @Test
    public void testProductProducer()
    {
        Collection<Class<?>> beanClasses = new ArrayList<Class<?>>();
        beanClasses.add(ProductInjectedBean.class);
        beanClasses.add(MyProductProducer.class);
        beanClasses.add(MyProductBean.class);
        
        startContainer(beanClasses);
        
        ProductInjectedBean pib = getInstance(ProductInjectedBean.class, new DefaultLiteral());
        Assert.assertNotNull(pib);
        
        pib.getX();
        
        shutDownContainer();
    }
    

}
