/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.monitoring;

import opennlp.tools.monitoring.StopCriteria;
import opennlp.tools.util.TrainingParameters;

public class LogLikelihoodThresholdBreached
implements StopCriteria<Double> {
    public static String STOP = "Stopping: Difference between log likelihood of current and previous iteration is less than threshold %s .";
    private final TrainingParameters trainingParameters;

    public LogLikelihoodThresholdBreached(TrainingParameters trainingParameters) {
        this.trainingParameters = trainingParameters;
    }

    @Override
    public String getMessageIfSatisfied() {
        return String.format(STOP, this.getThreshold());
    }

    @Override
    public boolean test(Double currVsPrevLLDiff) {
        return currVsPrevLLDiff < this.getThreshold();
    }

    private double getThreshold() {
        return this.trainingParameters != null ? this.trainingParameters.getDoubleParameter("LLThreshold", 1.0E-4) : 1.0E-4;
    }
}

