/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.instrumentation;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.PluginListValue;
import org.apache.openjpa.lib.instrumentation.Instrument;
import org.apache.openjpa.lib.instrumentation.InstrumentationLevel;
import org.apache.openjpa.lib.instrumentation.InstrumentationProvider;

public abstract class AbstractInstrumentationProvider
implements InstrumentationProvider,
Configurable {
    private Map<String, Instrument> _instruments = new ConcurrentHashMap<String, Instrument>();
    private boolean _started = false;
    private PluginListValue _instrumentValues;
    private String _options;
    private Configuration _config;

    @Override
    public void setConfiguration(Configuration conf) {
        this._config = conf;
    }

    @Override
    public Configuration getConfiguration() {
        return this._config;
    }

    @Override
    public void startConfiguration() {
    }

    @Override
    public void endConfiguration() {
    }

    @Override
    public void setInstrument(String instrument) {
        Instrument[] instruments;
        this._instrumentValues = new PluginListValue("Instrument");
        if (this.getInstrumentAliases() != null) {
            this._instrumentValues.setAliases(this.getInstrumentAliases());
        }
        this._instrumentValues.setString(instrument);
        for (Instrument inst : instruments = (Instrument[])this._instrumentValues.instantiate(Instrument.class, this._config)) {
            inst.setProvider(this);
            this._instruments.put(inst.getName(), inst);
        }
    }

    @Override
    public String getInstrument() {
        return this._instrumentValues.getString();
    }

    @Override
    public void setOptions(String options) {
        this._options = options;
    }

    @Override
    public String getOptions() {
        return this._options;
    }

    @Override
    public void addInstrument(Instrument instrument) {
        if (instrument == null) {
            return;
        }
        instrument.setProvider(this);
        this._instruments.put(instrument.getName(), instrument);
    }

    @Override
    public void initializeInstrument(Instrument instrument, Object context) {
        this.initializeInstrument(instrument, this._options, context);
    }

    @Override
    public void initializeInstrument(Instrument instrument, String options, Object context) {
        instrument.setProvider(this);
        instrument.setOptions(options);
        instrument.setContext(context);
        instrument.initialize();
    }

    @Override
    public Instrument getInstrumentByName(String name) {
        return this._instruments.get(name);
    }

    @Override
    public Set<Instrument> getInstruments() {
        return new HashSet<Instrument>(this._instruments.values());
    }

    @Override
    public void stopInstruments(InstrumentationLevel level, Object context) {
        try {
            Set<Instrument> instruments = this.getInstruments();
            for (Instrument instrument : instruments) {
                if (instrument.getLevel() != level || !AbstractInstrumentationProvider.contextEquals(instrument.getContext(), context)) continue;
                this.stopInstrument(instrument);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void startInstruments(InstrumentationLevel level, Object context) {
        Set<Instrument> instruments = this.getInstruments();
        for (Instrument instrument : instruments) {
            if (instrument.getLevel() != level) continue;
            this.initializeInstrument(instrument, context);
            this.startInstrument(instrument);
        }
    }

    @Override
    public void stopInstrument(Instrument instrument) {
        this.stopInstrument(instrument, true);
    }

    @Override
    public void removeInstrumentByName(String name) {
        Instrument ins = this._instruments.remove(name);
        if (ins != null) {
            ins.stop();
        }
    }

    @Override
    public boolean isStarted() {
        return this._started;
    }

    protected void setStarted(boolean started) {
        this._started = started;
    }

    @Override
    public String[] getInstrumentAliases() {
        return null;
    }

    @Override
    public abstract void start();

    @Override
    public abstract void stop();

    private static boolean contextEquals(Object ctx1, Object ctx2) {
        if (ctx1 == ctx2) {
            return true;
        }
        if (ctx1 == null) {
            return false;
        }
        return ctx1.equals(ctx2);
    }
}

