/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import java.nio.file.Path;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.nifi.properties.StandardReadableProperties;

public class BootstrapProperties
extends StandardReadableProperties {
    private final String propertyPrefix;
    private final Path configFilePath;

    public BootstrapProperties(String propertyPrefix, Properties properties, Path configFilePath) {
        super(new Properties());
        Objects.requireNonNull(properties, "Properties are required");
        this.propertyPrefix = Objects.requireNonNull(propertyPrefix, "Property prefix is required");
        this.configFilePath = configFilePath;
        this.filterProperties(properties);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String property = super.getProperty(key, defaultValue);
        return BootstrapProperties.isBlank(property) ? null : property;
    }

    @Override
    public String getProperty(String key) {
        String property = super.getProperty(key);
        return BootstrapProperties.isBlank(property) ? null : property;
    }

    private void filterProperties(Properties properties) {
        this.getRawProperties().clear();
        Properties filteredProperties = new Properties();
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            if (!key.startsWith(this.propertyPrefix)) continue;
            filteredProperties.put(key, properties.getProperty(key));
        }
        this.getRawProperties().putAll((Map<?, ?>)filteredProperties);
    }

    public String toString() {
        return String.format("Bootstrap properties [%s] with prefix [%s]", this.configFilePath, this.propertyPrefix);
    }

    private static boolean isBlank(String string) {
        return string == null || string.isBlank();
    }
}

