/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.xml;

import com.ctc.wstx.stax.WstxOutputFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.api.xml.XmlService;
import org.codehaus.stax2.util.StreamWriterDelegate;

public class DefaultXmlService
extends XmlService {
    private static final boolean DEFAULT_TRIM = true;

    @Nonnull
    public XmlNode doRead(InputStream input, @Nullable XmlService.InputLocationBuilder locationBuilder) throws XMLStreamException {
        XMLStreamReader parser = XMLInputFactory.newFactory().createXMLStreamReader(input);
        return this.doRead(parser, locationBuilder);
    }

    @Nonnull
    public XmlNode doRead(Reader reader, @Nullable XmlService.InputLocationBuilder locationBuilder) throws XMLStreamException {
        XMLStreamReader parser = XMLInputFactory.newFactory().createXMLStreamReader(reader);
        return this.doRead(parser, locationBuilder);
    }

    @Nonnull
    public XmlNode doRead(XMLStreamReader parser, @Nullable XmlService.InputLocationBuilder locationBuilder) throws XMLStreamException {
        return this.doBuild(parser, true, locationBuilder);
    }

    private XmlNode doBuild(XMLStreamReader parser, boolean trim, XmlService.InputLocationBuilder locationBuilder) throws XMLStreamException {
        boolean spacePreserve = false;
        String lPrefix = null;
        String lNamespaceUri = null;
        String lName = null;
        String lValue = null;
        Object location = null;
        HashMap<Object, String> attrs = null;
        ArrayList<XmlNode> children = null;
        int eventType = parser.getEventType();
        int lastStartTag = -1;
        while (eventType != 8) {
            if (eventType == 1) {
                lastStartTag = parser.getLocation().getLineNumber() * 1000 + parser.getLocation().getColumnNumber();
                if (lName == null) {
                    int namespacesSize = parser.getNamespaceCount();
                    lPrefix = parser.getPrefix();
                    lNamespaceUri = parser.getNamespaceURI();
                    lName = parser.getLocalName();
                    location = locationBuilder != null ? locationBuilder.toInputLocation(parser) : null;
                    int attributesSize = parser.getAttributeCount();
                    if (attributesSize > 0 || namespacesSize > 0) {
                        int i;
                        attrs = new HashMap<Object, String>();
                        for (i = 0; i < namespacesSize; ++i) {
                            String nsPrefix = parser.getNamespacePrefix(i);
                            String nsUri = parser.getNamespaceURI(i);
                            attrs.put(nsPrefix != null && !nsPrefix.isEmpty() ? "xmlns:" + nsPrefix : "xmlns", nsUri);
                        }
                        for (i = 0; i < attributesSize; ++i) {
                            Object aName = parser.getAttributeLocalName(i);
                            String aValue = parser.getAttributeValue(i);
                            String aPrefix = parser.getAttributePrefix(i);
                            if (aPrefix != null && !aPrefix.isEmpty()) {
                                aName = aPrefix + ":" + (String)aName;
                            }
                            attrs.put(aName, aValue);
                            spacePreserve = spacePreserve || "xml:space".equals(aName) && "preserve".equals(aValue);
                        }
                    }
                } else {
                    if (children == null) {
                        children = new ArrayList<XmlNode>();
                    }
                    XmlNode child = this.doBuild(parser, trim, locationBuilder);
                    children.add(child);
                }
            } else if (eventType == 4 || eventType == 12) {
                String text = parser.getText();
                lValue = lValue != null ? lValue + text : text;
            } else if (eventType == 2) {
                boolean emptyTag;
                boolean bl = emptyTag = lastStartTag == parser.getLocation().getLineNumber() * 1000 + parser.getLocation().getColumnNumber();
                if (lValue != null && trim && !spacePreserve) {
                    lValue = lValue.trim();
                }
                return XmlNode.newBuilder().prefix(lPrefix).namespaceUri(lNamespaceUri).name(lName).value(children == null ? (lValue != null ? lValue : (emptyTag ? null : "")) : null).attributes(attrs).children(children).inputLocation(location).build();
            }
            eventType = parser.next();
        }
        throw new IllegalStateException("End of document found before returning to 0 depth");
    }

    public void doWrite(XmlNode node, Writer writer) throws IOException {
        try {
            WstxOutputFactory factory = new WstxOutputFactory();
            factory.setProperty("javax.xml.stream.isRepairingNamespaces", false);
            factory.setProperty("com.ctc.wstx.useDoubleQuotesInXmlDecl", true);
            factory.setProperty("com.ctc.wstx.addSpaceAfterEmptyElem", true);
            IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(writer));
            this.writeNode((XMLStreamWriter)((Object)serializer), node);
            serializer.close();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private void writeNode(XMLStreamWriter xmlWriter, XmlNode node) throws XMLStreamException {
        xmlWriter.writeStartElement(node.prefix(), node.name(), node.namespaceUri());
        for (Map.Entry attr : node.attributes().entrySet()) {
            xmlWriter.writeAttribute((String)attr.getKey(), (String)attr.getValue());
        }
        for (XmlNode child : node.children()) {
            this.writeNode(xmlWriter, child);
        }
        String value = node.value();
        if (value != null) {
            xmlWriter.writeCharacters(value);
        }
        xmlWriter.writeEndElement();
    }

    public XmlNode doMerge(XmlNode dominant, XmlNode recessive, Boolean childMergeOverride) {
        if (recessive == null) {
            return dominant;
        }
        if (dominant == null) {
            return recessive;
        }
        boolean mergeSelf = true;
        String selfMergeMode = DefaultXmlService.getSelfCombinationMode(dominant);
        if ("override".equals(selfMergeMode)) {
            mergeSelf = false;
        }
        if (mergeSelf) {
            String value = dominant.value();
            Object location = dominant.inputLocation();
            HashMap<String, String> attrs = dominant.attributes();
            ArrayList<XmlNode> children = null;
            for (Map.Entry attr : recessive.attributes().entrySet()) {
                String key = (String)attr.getKey();
                if (!DefaultXmlService.isEmpty((String)attrs.get(key))) continue;
                if (attrs == dominant.attributes()) {
                    attrs = new HashMap<String, String>(attrs);
                }
                attrs.put(key, (String)attr.getValue());
            }
            if (!recessive.children().isEmpty()) {
                boolean mergeChildren = true;
                if (childMergeOverride != null) {
                    mergeChildren = childMergeOverride;
                } else {
                    String childCombinationMode = DefaultXmlService.getChildCombinationMode((Map<String, String>)attrs);
                    if ("append".equals(childCombinationMode)) {
                        mergeChildren = false;
                    }
                }
                HashMap<String, Iterator> commonChildren = new HashMap<String, Iterator>();
                Set names = recessive.children().stream().map(XmlNode::name).collect(Collectors.toSet());
                for (String name : names) {
                    List<XmlNode> dominantChildren = dominant.children().stream().filter(n -> n.name().equals(name)).toList();
                    if (dominantChildren.isEmpty()) continue;
                    commonChildren.put(name, dominantChildren.iterator());
                }
                String keysValue = recessive.attribute("combine.keys");
                int recessiveChildIndex = 0;
                for (XmlNode recessiveChild : recessive.children()) {
                    String idValue = recessiveChild.attribute("combine.id");
                    XmlNode childDom = null;
                    if (!DefaultXmlService.isEmpty(idValue)) {
                        for (XmlNode dominantChild : dominant.children()) {
                            if (!idValue.equals(dominantChild.attribute("combine.id"))) continue;
                            childDom = dominantChild;
                            mergeChildren = true;
                        }
                    } else if (!DefaultXmlService.isEmpty(keysValue)) {
                        String[] keys = keysValue.split(",");
                        Map<String, Optional> recessiveKeyValues = Stream.of(keys).collect(Collectors.toMap(k -> k, k -> Optional.ofNullable(recessiveChild.attribute(k))));
                        for (XmlNode dominantChild : dominant.children()) {
                            Map<String, Optional> dominantKeyValues = Stream.of(keys).collect(Collectors.toMap(k -> k, k -> Optional.ofNullable(dominantChild.attribute(k))));
                            if (!recessiveKeyValues.equals(dominantKeyValues)) continue;
                            childDom = dominantChild;
                            mergeChildren = true;
                        }
                    } else {
                        childDom = dominant.child(recessiveChild.name());
                    }
                    if (mergeChildren && childDom != null) {
                        String name = recessiveChild.name();
                        Iterator it = commonChildren.computeIfAbsent(name, n1 -> Stream.of(dominant.children().stream().filter(n2 -> n2.name().equals(n1)).collect(Collectors.toList())).filter(l -> !l.isEmpty()).map(List::iterator).findFirst().orElse(null));
                        if (it == null) {
                            if (children == null) {
                                children = new ArrayList(dominant.children());
                            }
                            children.add(recessiveChild);
                        } else if (it.hasNext()) {
                            XmlNode dominantChild = (XmlNode)it.next();
                            String dominantChildCombinationMode = DefaultXmlService.getSelfCombinationMode(dominantChild);
                            if ("remove".equals(dominantChildCombinationMode)) {
                                if (children == null) {
                                    children = new ArrayList(dominant.children());
                                }
                                children.remove(dominantChild);
                            } else {
                                int idx = dominant.children().indexOf(dominantChild);
                                XmlNode merged = DefaultXmlService.merge((XmlNode)dominantChild, (XmlNode)recessiveChild, (Boolean)childMergeOverride);
                                if (merged != dominantChild) {
                                    if (children == null) {
                                        children = new ArrayList(dominant.children());
                                    }
                                    children.set(idx, merged);
                                }
                            }
                        }
                    } else {
                        if (children == null) {
                            children = new ArrayList<XmlNode>(dominant.children());
                        }
                        int idx = mergeChildren ? children.size() : recessiveChildIndex;
                        children.add(idx, recessiveChild);
                    }
                    ++recessiveChildIndex;
                }
            }
            if (value != null || attrs != dominant.attributes() || children != null) {
                if (children == null) {
                    children = dominant.children();
                }
                if (!(Objects.equals(value, dominant.value()) && Objects.equals(attrs, dominant.attributes()) && Objects.equals(children, dominant.children()) && Objects.equals(location, dominant.inputLocation()))) {
                    return XmlNode.newBuilder().prefix(dominant.prefix()).namespaceUri(dominant.namespaceUri()).name(dominant.name()).value(value != null ? value : dominant.value()).attributes(attrs).children((List)children).inputLocation(location).build();
                }
                return dominant;
            }
        }
        return dominant;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private static String getSelfCombinationMode(XmlNode node) {
        String value = node.attribute("combine.self");
        return !DefaultXmlService.isEmpty(value) ? value : "merge";
    }

    private static String getChildCombinationMode(Map<String, String> attributes) {
        String value = attributes.get("combine.children");
        return !DefaultXmlService.isEmpty(value) ? value : "merge";
    }

    @Nullable
    private static XmlNode findNodeById(@Nonnull List<XmlNode> nodes, @Nonnull String id) {
        return nodes.stream().filter(n -> id.equals(n.attribute("combine.id"))).findFirst().orElse(null);
    }

    @Nullable
    private static XmlNode findNodeByKeys(@Nonnull List<XmlNode> nodes, @Nonnull XmlNode target, @Nonnull String[] keys) {
        return nodes.stream().filter(n -> DefaultXmlService.matchesKeys(n, target, keys)).findFirst().orElse(null);
    }

    private static boolean matchesKeys(@Nonnull XmlNode node1, @Nonnull XmlNode node2, @Nonnull String[] keys) {
        for (String key : keys) {
            String value2;
            String value1 = node1.attribute(key);
            if (Objects.equals(value1, value2 = node2.attribute(key))) continue;
            return false;
        }
        return true;
    }

    static class IndentingXMLStreamWriter
    extends StreamWriterDelegate {
        int depth = 0;
        boolean hasChildren = false;
        boolean anew = true;

        IndentingXMLStreamWriter(XMLStreamWriter parent) {
            super(parent);
        }

        public void writeStartDocument() throws XMLStreamException {
            super.writeStartDocument();
            this.anew = false;
        }

        public void writeStartDocument(String version) throws XMLStreamException {
            super.writeStartDocument(version);
            this.anew = false;
        }

        public void writeStartDocument(String encoding, String version) throws XMLStreamException {
            super.writeStartDocument(encoding, version);
            this.anew = false;
        }

        public void writeEmptyElement(String localName) throws XMLStreamException {
            this.indent();
            super.writeEmptyElement(localName);
            this.hasChildren = true;
            this.anew = false;
        }

        public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
            this.indent();
            super.writeEmptyElement(namespaceURI, localName);
            this.hasChildren = true;
            this.anew = false;
        }

        public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.indent();
            super.writeEmptyElement(prefix, localName, namespaceURI);
            this.hasChildren = true;
            this.anew = false;
        }

        public void writeStartElement(String localName) throws XMLStreamException {
            this.indent();
            super.writeStartElement(localName);
            ++this.depth;
            this.hasChildren = false;
            this.anew = false;
        }

        public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
            this.indent();
            super.writeStartElement(namespaceURI, localName);
            ++this.depth;
            this.hasChildren = false;
            this.anew = false;
        }

        public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.indent();
            super.writeStartElement(prefix, localName, namespaceURI);
            ++this.depth;
            this.hasChildren = false;
            this.anew = false;
        }

        public void writeEndElement() throws XMLStreamException {
            --this.depth;
            if (this.hasChildren) {
                this.indent();
            }
            super.writeEndElement();
            this.hasChildren = true;
            this.anew = false;
        }

        private void indent() throws XMLStreamException {
            if (!this.anew) {
                super.writeCharacters("\n");
            }
            for (int i = 0; i < this.depth; ++i) {
                super.writeCharacters("  ");
            }
        }
    }
}

