/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.xml.SettingsXmlFactory;
import org.apache.maven.api.services.xml.XmlReaderException;
import org.apache.maven.api.services.xml.XmlReaderRequest;
import org.apache.maven.api.services.xml.XmlWriterException;
import org.apache.maven.api.services.xml.XmlWriterRequest;
import org.apache.maven.api.settings.InputSource;
import org.apache.maven.api.settings.Settings;
import org.apache.maven.impl.StaxLocation;
import org.apache.maven.settings.v4.SettingsStaxReader;
import org.apache.maven.settings.v4.SettingsStaxWriter;

@Named
@Singleton
public class DefaultSettingsXmlFactory
implements SettingsXmlFactory {
    public Settings read(@Nonnull XmlReaderRequest request) throws XmlReaderException {
        DefaultSettingsXmlFactory.nonNull(request, "request");
        Reader reader = request.getReader();
        InputStream inputStream = request.getInputStream();
        if (reader == null && inputStream == null) {
            throw new IllegalArgumentException("reader or inputStream must be non null");
        }
        try {
            InputSource source = null;
            if (request.getModelId() != null || request.getLocation() != null) {
                source = new InputSource(request.getLocation());
            }
            SettingsStaxReader xml = request.getTransformer() != null ? new SettingsStaxReader((arg_0, arg_1) -> ((XmlReaderRequest.Transformer)request.getTransformer()).transform(arg_0, arg_1)) : new SettingsStaxReader();
            xml.setAddDefaultEntities(request.isAddDefaultEntities());
            if (reader != null) {
                return xml.read(reader, request.isStrict(), source);
            }
            return xml.read(inputStream, request.isStrict(), source);
        }
        catch (Exception e) {
            throw new XmlReaderException("Unable to read settings: " + StaxLocation.getMessage(e), StaxLocation.getLocation(e), e);
        }
    }

    public void write(XmlWriterRequest<Settings> request) throws XmlWriterException {
        DefaultSettingsXmlFactory.nonNull(request, "request");
        Settings content = DefaultSettingsXmlFactory.nonNull((Settings)request.getContent(), "content");
        OutputStream outputStream = request.getOutputStream();
        Writer writer = request.getWriter();
        if (writer == null && outputStream == null) {
            throw new IllegalArgumentException("writer or outputStream must be non null");
        }
        try {
            if (writer != null) {
                new SettingsStaxWriter().write(writer, content);
            } else {
                new SettingsStaxWriter().write(outputStream, content);
            }
        }
        catch (Exception e) {
            throw new XmlWriterException("Unable to write settings: " + StaxLocation.getMessage(e), StaxLocation.getLocation(e), e);
        }
    }

    static <T> T nonNull(T t, String name) {
        if (t == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
        return t;
    }
}

