/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer.annotation;

import java.nio.charset.Charset;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.BinaryFormat;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.serializer.OutputStreamSerializer;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerListener;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.serializer.annotation.SerializerConfig;
import org.apache.juneau.svl.VarResolverSession;

public class SerializerConfigAnnotation {

    public static class WriterSerializerApply
    extends AnnotationApplier<SerializerConfig, WriterSerializer.Builder> {
        public WriterSerializerApply(VarResolverSession vr) {
            super(SerializerConfig.class, WriterSerializer.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<SerializerConfig> ai, WriterSerializer.Builder b) {
            SerializerConfig a = ai.inner();
            this.charset(a.fileCharset()).ifPresent(x -> b.fileCharset((Charset)x));
            this.integer(a.maxIndent(), "maxIndent").ifPresent(x -> b.maxIndent((int)x));
            this.character(a.quoteChar(), "quoteChar").ifPresent(x -> b.quoteChar(x.charValue()));
            this.charset(a.streamCharset()).ifPresent(x -> b.streamCharset((Charset)x));
            this.bool(a.useWhitespace()).ifPresent(x -> b.useWhitespace((boolean)x));
        }
    }

    public static class OutputStreamSerializerApply
    extends AnnotationApplier<SerializerConfig, OutputStreamSerializer.Builder> {
        public OutputStreamSerializerApply(VarResolverSession vr) {
            super(SerializerConfig.class, OutputStreamSerializer.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<SerializerConfig> ai, OutputStreamSerializer.Builder b) {
            SerializerConfig a = ai.inner();
            this.string(a.binaryFormat()).map(BinaryFormat::valueOf).ifPresent(x -> b.binaryFormat((BinaryFormat)((Object)x)));
        }
    }

    public static class SerializerApply
    extends AnnotationApplier<SerializerConfig, Serializer.Builder> {
        public SerializerApply(VarResolverSession vr) {
            super(SerializerConfig.class, Serializer.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<SerializerConfig> ai, Serializer.Builder b) {
            SerializerConfig a = ai.inner();
            this.bool(a.addBeanTypes()).ifPresent(x -> b.addBeanTypes((boolean)x));
            this.bool(a.addRootType()).ifPresent(x -> b.addRootType((boolean)x));
            this.bool(a.keepNullProperties()).ifPresent(x -> b.keepNullProperties((boolean)x));
            this.type(a.listener()).ifPresent(x -> b.listener((Class<? extends SerializerListener>)x));
            this.bool(a.sortCollections()).ifPresent(x -> b.sortCollections((boolean)x));
            this.bool(a.sortMaps()).ifPresent(x -> b.sortMaps((boolean)x));
            this.bool(a.trimEmptyCollections()).ifPresent(x -> b.trimEmptyCollections((boolean)x));
            this.bool(a.trimEmptyMaps()).ifPresent(x -> b.trimEmptyMaps((boolean)x));
            this.bool(a.trimStrings()).ifPresent(x -> b.trimStrings((boolean)x));
            this.string(a.uriContext()).map(UriContext::of).ifPresent(x -> b.uriContext((UriContext)x));
            this.string(a.uriRelativity()).map(UriRelativity::valueOf).ifPresent(x -> b.uriRelativity((UriRelativity)((Object)x)));
            this.string(a.uriResolution()).map(UriResolution::valueOf).ifPresent(x -> b.uriResolution((UriResolution)((Object)x)));
            this.bool(a.detectRecursions()).ifPresent(x -> b.detectRecursions((boolean)x));
            this.bool(a.ignoreRecursions()).ifPresent(x -> b.ignoreRecursions((boolean)x));
            this.integer(a.initialDepth(), "initialDepth").ifPresent(x -> b.initialDepth((int)x));
            this.integer(a.maxDepth(), "maxDepth").ifPresent(x -> b.maxDepth((int)x));
        }
    }
}

