/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.plaintext;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.plaintext.PlainTextBeanPropertyMeta;
import org.apache.juneau.plaintext.PlainTextClassMeta;
import org.apache.juneau.plaintext.PlainTextCommon;
import org.apache.juneau.plaintext.PlainTextMetaProvider;
import org.apache.juneau.plaintext.PlainTextParserBuilder;
import org.apache.juneau.plaintext.PlainTextParserSession;

@ConfigurableContext
public class PlainTextParser
extends ReaderParser
implements PlainTextMetaProvider,
PlainTextCommon {
    static final String PREFIX = "PlainTextParser";
    public static final PlainTextParser DEFAULT = new PlainTextParser(PropertyStore.DEFAULT);
    private final Map<ClassMeta<?>, PlainTextClassMeta> plainTextClassMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, PlainTextBeanPropertyMeta> plainTextBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, PlainTextBeanPropertyMeta>();

    public PlainTextParser(PropertyStore ps) {
        this(ps, "text/plain");
    }

    public PlainTextParser(PropertyStore ps, String ... consumes) {
        super(ps, consumes);
    }

    @Override
    public PlainTextParserBuilder builder() {
        return new PlainTextParserBuilder(this.getPropertyStore());
    }

    public static PlainTextParserBuilder create() {
        return new PlainTextParserBuilder();
    }

    @Override
    public PlainTextParserSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public PlainTextParserSession createSession(ParserSessionArgs args) {
        return new PlainTextParserSession(this, args);
    }

    @Override
    public PlainTextClassMeta getPlainTextClassMeta(ClassMeta<?> cm) {
        PlainTextClassMeta m = this.plainTextClassMetas.get(cm);
        if (m == null) {
            m = new PlainTextClassMeta(cm, this);
            this.plainTextClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public PlainTextBeanPropertyMeta getPlainTextBeanPropertyMeta(BeanPropertyMeta bpm) {
        if (bpm == null) {
            return PlainTextBeanPropertyMeta.DEFAULT;
        }
        PlainTextBeanPropertyMeta m = this.plainTextBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new PlainTextBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.plainTextBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append(PREFIX, new DefaultFilteringObjectMap());
    }
}

