/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.core.impl.util.AdhocStatusHealthCheck;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class JmxAdjustableStatusHealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(JmxAdjustableStatusHealthCheck.class);
    public static final String OBJECT_NAME = "org.apache.felix.healthcheck:type=AdjustableStatusHealthCheck";
    private BundleContext bundleContext;
    private ServiceRegistration<DynamicMBean> mbeanRegistration;
    private ServiceRegistration<HealthCheck> healthCheckRegistration;

    @Activate
    protected final void activate(ComponentContext context) {
        this.bundleContext = context.getBundleContext();
        this.registerMbean();
    }

    @Deactivate
    protected final void deactivate(ComponentContext context) {
        this.unregisterMbean();
        this.unregisterDynamicHealthCheck();
    }

    private void registerMbean() {
        Hashtable<String, String> mbeanProps = new Hashtable<String, String>();
        ((Dictionary)mbeanProps).put("jmx.objectname", OBJECT_NAME);
        AdjustableHealthCheckStatusMBean adjustableHealthCheckStatusMBean = new AdjustableHealthCheckStatusMBean();
        this.mbeanRegistration = this.bundleContext.registerService(DynamicMBean.class, (Object)adjustableHealthCheckStatusMBean, mbeanProps);
        LOG.debug("Registered mbean {} as {}", (Object)adjustableHealthCheckStatusMBean, (Object)OBJECT_NAME);
    }

    private void unregisterMbean() {
        if (this.mbeanRegistration != null) {
            this.mbeanRegistration.unregister();
            this.mbeanRegistration = null;
            LOG.debug("Unregistered mbean AdjustableHealthCheckStatusMBean");
        }
    }

    private synchronized void registerDynamicHealthCheck(Result.Status status, String[] tags) {
        this.unregisterDynamicHealthCheck();
        AdhocStatusHealthCheck healthCheck = new AdhocStatusHealthCheck(status, "Set dynamically via JMX bean org.apache.felix.healthcheck:type=AdjustableStatusHealthCheck");
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("hc.name", "JMX Adhoc Result");
        ((Dictionary)props).put("hc.tags", tags);
        this.healthCheckRegistration = this.bundleContext.registerService(HealthCheck.class, (Object)healthCheck, props);
    }

    private synchronized void unregisterDynamicHealthCheck() {
        if (this.healthCheckRegistration != null) {
            this.healthCheckRegistration.unregister();
            this.healthCheckRegistration = null;
            LOG.debug("Unregistered DynamicTestingHealthCheck");
        }
    }

    private class AdjustableHealthCheckStatusMBean
    implements DynamicMBean {
        private static final String OP_RESET = "reset";
        private static final String OP_ADD_WARN_RESULT_FOR_TAGS = "addWarnResultForTags";
        private static final String OP_ADD_TEMPORARILY_UNAVAILABLE_RESULT_FOR_TAGS = "addTemporarilyUnavailableResultForTags";
        private static final String OP_ADD_CRITICAL_RESULT_FOR_TAGS = "addCriticalResultForTags";
        private static final String ATT_TAGS = "tags";
        private static final String ATT_STATUS = "status";
        private static final String STATUS_INACTIVE = "INACTIVE";
        private final MBeanInfo mbeanInfo;
        private List<String> tags = new ArrayList<String>();
        private String status = "INACTIVE";

        public AdjustableHealthCheckStatusMBean() {
            this.mbeanInfo = this.createMBeanInfo();
        }

        @Override
        public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
            if (ATT_TAGS.equals(attribute)) {
                return String.join((CharSequence)",", this.tags);
            }
            if (ATT_STATUS.equals(attribute)) {
                return this.status.toString();
            }
            throw new AttributeNotFoundException("Attribute " + attribute + " not found.");
        }

        @Override
        public AttributeList getAttributes(String[] attributes) {
            AttributeList result = new AttributeList();
            for (String att : attributes) {
                try {
                    result.add(new Attribute(att, this.getAttribute(att)));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
            }
            return result;
        }

        private MBeanInfo createMBeanInfo() {
            ArrayList<MBeanAttributeInfo> attrs = new ArrayList<MBeanAttributeInfo>();
            attrs.add(new MBeanAttributeInfo(ATT_TAGS, String.class.getName(), "Tags", true, false, false));
            attrs.add(new MBeanAttributeInfo(ATT_STATUS, String.class.getName(), "Status", true, false, false));
            MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo(ATT_TAGS, "java.lang.String", "Comma separated list of tags")};
            ArrayList<MBeanOperationInfo> ops = new ArrayList<MBeanOperationInfo>();
            ops.add(new MBeanOperationInfo(OP_RESET, "Resets this testing mechanism and removes the failing HC", new MBeanParameterInfo[0], "java.lang.String", 1));
            ops.add(new MBeanOperationInfo(OP_ADD_TEMPORARILY_UNAVAILABLE_RESULT_FOR_TAGS, "Adds a TEMPORARILY_UNAVAILABLE result for the given tags", params, "java.lang.String", 1));
            ops.add(new MBeanOperationInfo(OP_ADD_CRITICAL_RESULT_FOR_TAGS, "Adds a CRITICAL result for the given tags", params, "java.lang.String", 1));
            ops.add(new MBeanOperationInfo(OP_ADD_WARN_RESULT_FOR_TAGS, "Adds a WARN result for the given tags", params, "java.lang.String", 1));
            return new MBeanInfo(this.getClass().getName(), "Adjustable Health Check", attrs.toArray(new MBeanAttributeInfo[attrs.size()]), null, ops.toArray(new MBeanOperationInfo[ops.size()]), null);
        }

        @Override
        public MBeanInfo getMBeanInfo() {
            return this.mbeanInfo;
        }

        @Override
        public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
            Result.Status newStatus = null;
            List<String> list = this.tags = params.length > 0 ? Arrays.asList(params[0].toString().split("[,; ]+")) : Arrays.asList("");
            if (OP_RESET.equals(actionName)) {
                JmxAdjustableStatusHealthCheck.this.unregisterDynamicHealthCheck();
                LOG.info("JMX-adjustable Health Check was reset");
                this.status = STATUS_INACTIVE;
                return "Reset successful";
            }
            if (OP_ADD_TEMPORARILY_UNAVAILABLE_RESULT_FOR_TAGS.equals(actionName)) {
                newStatus = Result.Status.TEMPORARILY_UNAVAILABLE;
            } else if (OP_ADD_CRITICAL_RESULT_FOR_TAGS.equals(actionName)) {
                newStatus = Result.Status.CRITICAL;
            } else if (OP_ADD_WARN_RESULT_FOR_TAGS.equals(actionName)) {
                newStatus = Result.Status.WARN;
            } else {
                throw new MBeanException(new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support operation " + actionName));
            }
            this.status = newStatus.toString();
            JmxAdjustableStatusHealthCheck.this.registerDynamicHealthCheck(newStatus, this.tags.toArray(new String[this.tags.size()]));
            LOG.info("Activated JMX-adjustable Health Check with status " + newStatus + " and tags " + String.join((CharSequence)",", this.tags));
            return "Added check with result " + newStatus;
        }

        @Override
        public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
            throw new MBeanException(new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support setting attributes."));
        }

        @Override
        public AttributeList setAttributes(AttributeList attributes) {
            return new AttributeList();
        }
    }
}

