/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifeditor;

import java.io.IOException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.directory.studio.ldifeditor.LdifEditorConstants;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.GlobalTemplateVariables;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class LdifEditorActivator
extends AbstractUIPlugin {
    private static LdifEditorActivator plugin;
    private ResourceBundle resourceBundle;
    private ColorRegistry colorRegistry;
    private ContributionTemplateStore ldifTemplateStore;
    private ContributionContextTypeRegistry ldifTemplateContextTypeRegistry;
    private PropertyResourceBundle properties;

    public LdifEditorActivator() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.apache.directory.studio.ldifeditor.messages");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        if (this.colorRegistry == null) {
            this.colorRegistry = new ColorRegistry(this.getWorkbench().getDisplay());
        }
        if (this.ldifTemplateContextTypeRegistry == null) {
            this.ldifTemplateContextTypeRegistry = new ContributionContextTypeRegistry();
            this.ldifTemplateContextTypeRegistry.addContextType(LdifEditorConstants.LDIF_FILE_TEMPLATE_ID);
            this.ldifTemplateContextTypeRegistry.getContextType(LdifEditorConstants.LDIF_FILE_TEMPLATE_ID).addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Cursor());
            this.ldifTemplateContextTypeRegistry.addContextType(LdifEditorConstants.LDIF_ATTR_VAL_RECORD_TEMPLATE_ID);
            this.ldifTemplateContextTypeRegistry.getContextType(LdifEditorConstants.LDIF_ATTR_VAL_RECORD_TEMPLATE_ID).addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Cursor());
            this.ldifTemplateContextTypeRegistry.addContextType(LdifEditorConstants.LDIF_MODIFICATION_RECORD_TEMPLATE_ID);
            this.ldifTemplateContextTypeRegistry.getContextType(LdifEditorConstants.LDIF_MODIFICATION_RECORD_TEMPLATE_ID).addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Cursor());
            this.ldifTemplateContextTypeRegistry.addContextType(LdifEditorConstants.LDIF_MODIFICATION_ITEM_TEMPLATE_ID);
            this.ldifTemplateContextTypeRegistry.addContextType(LdifEditorConstants.LDIF_MODDN_RECORD_TEMPLATE_ID);
        }
        if (this.ldifTemplateStore == null) {
            this.ldifTemplateStore = new ContributionTemplateStore(this.getLdifTemplateContextTypeRegistry(), this.getPreferenceStore(), "templates");
            try {
                this.ldifTemplateStore.load();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        if (this.colorRegistry != null) {
            this.colorRegistry = null;
        }
        if (this.ldifTemplateContextTypeRegistry != null) {
            this.ldifTemplateContextTypeRegistry = null;
        }
        if (this.ldifTemplateStore != null) {
            try {
                this.ldifTemplateStore.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.ldifTemplateStore = null;
        }
    }

    public static LdifEditorActivator getDefault() {
        return plugin;
    }

    public Color getColor(RGB rgb) {
        if (!this.colorRegistry.hasValueFor(rgb.toString())) {
            this.colorRegistry.put(rgb.toString(), rgb);
        }
        return this.colorRegistry.get(rgb.toString());
    }

    public ImageDescriptor getImageDescriptor(String key) {
        if (key != null) {
            URL url = FileLocator.find((Bundle)this.getBundle(), (IPath)new Path(key), null);
            if (url != null) {
                return ImageDescriptor.createFromURL((URL)url);
            }
            return null;
        }
        return null;
    }

    public Image getImage(String key) {
        ImageDescriptor id;
        Image image = this.getImageRegistry().get(key);
        if (image == null && (id = this.getImageDescriptor(key)) != null) {
            image = id.createImage();
            this.getImageRegistry().put(key, image);
        }
        return image;
    }

    public ContextTypeRegistry getLdifTemplateContextTypeRegistry() {
        return this.ldifTemplateContextTypeRegistry;
    }

    public TemplateStore getLdifTemplateStore() {
        return this.ldifTemplateStore;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public PropertyResourceBundle getPluginProperties() {
        if (this.properties == null) {
            try {
                this.properties = new PropertyResourceBundle(FileLocator.openStream((Bundle)this.getBundle(), (IPath)new Path("plugin.properties"), (boolean)false));
            }
            catch (IOException e) {
                this.getLog().log((IStatus)new Status(4, "org.apache.directory.studio.ldifeditor", 0, "Unable to get the plugin properties.", (Throwable)e));
            }
        }
        return this.properties;
    }
}

