/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.jobs;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import org.apache.directory.api.ldap.model.constants.SchemaConstants;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.config.ConfigPartitionInitializer;
import org.apache.directory.server.config.ConfigPartitionReader;
import org.apache.directory.server.config.ReadOnlyConfigurationPartition;
import org.apache.directory.server.config.beans.ConfigBean;
import org.apache.directory.server.core.api.DnFactory;
import org.apache.directory.server.core.api.InstanceLayout;
import org.apache.directory.server.core.partition.impl.btree.AbstractBTreePartition;
import org.apache.directory.server.core.partition.ldif.LdifPartition;
import org.apache.directory.studio.apacheds.configuration.ApacheDS2ConfigurationPlugin;
import org.apache.directory.studio.apacheds.configuration.editor.Configuration;
import org.apache.directory.studio.apacheds.configuration.editor.ConnectionServerConfigurationInput;
import org.apache.directory.studio.apacheds.configuration.editor.NewServerConfigurationInput;
import org.apache.directory.studio.apacheds.configuration.editor.ServerConfigurationEditor;
import org.apache.directory.studio.apacheds.configuration.jobs.EntryBasedConfigurationPartition;
import org.apache.directory.studio.apacheds.configuration.jobs.Messages;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.common.core.jobs.StudioRunnableWithProgress;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.IConnectionListener;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.jobs.SearchRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.SearchParameter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.framework.Bundle;

public class LoadConfigurationRunnable
implements StudioRunnableWithProgress {
    private ServerConfigurationEditor editor;

    public LoadConfigurationRunnable(ServerConfigurationEditor editor) {
        this.editor = editor;
    }

    public String getErrorMessage() {
        return Messages.getString("LoadConfigurationRunnable.UnableToLoadConfiguration");
    }

    public Object[] getLockedObjects() {
        return new Object[0];
    }

    public String getName() {
        return Messages.getString("LoadConfigurationRunnable.LoadConfiguration");
    }

    public void run(StudioProgressMonitor monitor) {
        IEditorInput input = this.editor.getEditorInput();
        try {
            final Configuration configuration = this.getConfiguration(input, monitor);
            if (configuration != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        LoadConfigurationRunnable.this.editor.configurationLoaded(configuration);
                    }
                });
            }
        }
        catch (Exception e) {
            ApacheDS2ConfigurationPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.apache.directory.studio.apacheds.configuration", e.getMessage()));
            monitor.reportError(e);
            final Exception exception = e;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    LoadConfigurationRunnable.this.editor.configurationLoadFailed(exception);
                }
            });
        }
    }

    public Configuration getConfiguration(IEditorInput input, StudioProgressMonitor monitor) throws Exception {
        String inputClassName = input.getClass().getName();
        if (input instanceof NewServerConfigurationInput) {
            Bundle bundle = Platform.getBundle((String)"org.apache.directory.server.config");
            URL resource = bundle.getResource("config.ldif");
            InputStream is = resource.openStream();
            return LoadConfigurationRunnable.readSingleFileConfiguration(is);
        }
        if (input instanceof ConnectionServerConfigurationInput) {
            return this.readConfiguration((ConnectionServerConfigurationInput)input, monitor);
        }
        if (input instanceof FileEditorInput) {
            File file = ((FileEditorInput)input).getFile().getLocation().toFile();
            return LoadConfigurationRunnable.readConfiguration(file);
        }
        if (input instanceof IPathEditorInput) {
            File file = ((IPathEditorInput)input).getPath().toFile();
            return LoadConfigurationRunnable.readConfiguration(file);
        }
        if (inputClassName.equals("org.eclipse.ui.internal.editors.text.JavaFileEditorInput") || inputClassName.equals("org.eclipse.ui.ide.FileStoreEditorInput")) {
            File file = new File(input.getToolTipText());
            return LoadConfigurationRunnable.readConfiguration(file);
        }
        return null;
    }

    public static Configuration readConfiguration(File file) throws Exception {
        if (file != null) {
            if (file.getName().equals("config.ldif")) {
                return LoadConfigurationRunnable.readSingleFileConfiguration(file);
            }
            if (file.getName().equals("ou=config.ldif")) {
                return LoadConfigurationRunnable.readMultiFileConfigureation(file.getParentFile());
            }
        }
        return null;
    }

    private static Configuration readSingleFileConfiguration(File configLdifFile) throws Exception {
        FileInputStream is = new FileInputStream(configLdifFile);
        return LoadConfigurationRunnable.readSingleFileConfiguration(is);
    }

    private static Configuration readSingleFileConfiguration(InputStream is) throws Exception {
        ReadOnlyConfigurationPartition configurationPartition = new ReadOnlyConfigurationPartition(is, ApacheDS2ConfigurationPlugin.getDefault().getSchemaManager());
        configurationPartition.initialize();
        return LoadConfigurationRunnable.readConfiguration((AbstractBTreePartition)configurationPartition);
    }

    private static synchronized Configuration readMultiFileConfigureation(File confDirectory) throws Exception {
        InstanceLayout instanceLayout = new InstanceLayout(confDirectory.getParentFile());
        SchemaManager schemaManager = ApacheDS2ConfigurationPlugin.getDefault().getSchemaManager();
        DnFactory dnFactory = null;
        ConfigPartitionInitializer init = new ConfigPartitionInitializer(instanceLayout, dnFactory, schemaManager);
        LdifPartition configurationPartition = init.initConfigPartition();
        return LoadConfigurationRunnable.readConfiguration((AbstractBTreePartition)configurationPartition);
    }

    private static Configuration readConfiguration(AbstractBTreePartition partition) throws LdapException {
        if (partition != null) {
            ConfigPartitionReader cpReader = new ConfigPartitionReader(partition);
            ConfigBean configBean = cpReader.readConfig();
            return new Configuration(configBean, partition);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private Configuration readConfiguration(ConnectionServerConfigurationInput input, StudioProgressMonitor monitor) throws Exception {
        block5: {
            if (input == null) break block5;
            schemaManager = ApacheDS2ConfigurationPlugin.getDefault().getSchemaManager();
            browserConnection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnection(input.getConnection());
            configurationPartition = new EntryBasedConfigurationPartition(schemaManager);
            configurationPartition.initialize();
            this.openConnection(input, monitor);
            configSearchParameter = new SearchParameter();
            configSearchParameter.setSearchBase(new Dn(new String[]{"ou=config"}));
            configSearchParameter.setFilter("(objectClass=*)");
            configSearchParameter.setScope(SearchScope.OBJECT);
            configSearchParameter.setReturningAttributes(SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
            configEntry = null;
            enumeration = SearchRunnable.search((IBrowserConnection)browserConnection, (SearchParameter)configSearchParameter, (StudioProgressMonitor)monitor);
            if (monitor.errorsReported()) {
                throw monitor.getException();
            }
            if (enumeration.hasMore()) {
                searchResult = enumeration.next();
                configEntry = new DefaultEntry(schemaManager, searchResult.getEntry());
            }
            enumeration.close();
            if (configEntry == null) {
                ApacheDS2ConfigurationPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.apache.directory.studio.apacheds.configuration", Messages.getString("LoadConfigurationRunnable.UnableToFindConfigBaseEntry")));
                throw new LdapNoSuchObjectException(Messages.getString("LoadConfigurationRunnable.UnableToFindConfigBaseEntry"));
            }
            entries = new ArrayList<DefaultEntry>();
            entries.add(configEntry);
            while (!entries.isEmpty()) {
                entry = (Entry)entries.remove(0);
                configurationPartition.addEntry(entry);
                searchParameter = new SearchParameter();
                searchParameter.setSearchBase(entry.getDn());
                searchParameter.setFilter("(objectClass=*)");
                searchParameter.setScope(SearchScope.ONELEVEL);
                searchParameter.setReturningAttributes(SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
                childrenEnumeration = SearchRunnable.search((IBrowserConnection)browserConnection, (SearchParameter)searchParameter, (StudioProgressMonitor)monitor);
                if (!monitor.errorsReported()) ** GOTO lbl40
                throw monitor.getException();
lbl-1000:
                // 1 sources

                {
                    searchResult = childrenEnumeration.next();
                    entries.add(new DefaultEntry(schemaManager, searchResult.getEntry()));
lbl40:
                    // 2 sources

                    ** while (childrenEnumeration.hasMore())
                }
lbl41:
                // 1 sources

                childrenEnumeration.close();
            }
            input.setOriginalPartition(configurationPartition);
            return LoadConfigurationRunnable.readConfiguration((AbstractBTreePartition)configurationPartition);
        }
        return null;
    }

    private void openConnection(ConnectionServerConfigurationInput input, StudioProgressMonitor monitor) {
        Connection connection = input.getConnection();
        if (connection != null && !connection.getConnectionWrapper().isConnected()) {
            connection.getConnectionWrapper().connect(monitor);
            if (connection.getConnectionWrapper().isConnected()) {
                connection.getConnectionWrapper().bind(monitor);
            }
            if (connection.getConnectionWrapper().isConnected()) {
                for (IConnectionListener listener : ConnectionCorePlugin.getDefault().getConnectionListeners()) {
                    listener.connectionOpened(connection, monitor);
                }
                ConnectionEventRegistry.fireConnectionOpened((Connection)connection, (Object)input);
            }
        }
    }
}

