/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util;

import jakarta.enterprise.inject.Vetoed;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@Vetoed
public abstract class ParameterUtil {
    private static boolean parameterSupported = true;
    private static Class<?> parameterClass;
    private static Method getNameMethod;
    private static Method getParametersMethod;

    public static boolean isParameterSupported() {
        return parameterSupported;
    }

    public static String getName(Method method, int parameterIndex) {
        if (!ParameterUtil.isParameterSupported() || method == null) {
            return null;
        }
        try {
            Object[] parameters = (Object[])getParametersMethod.invoke((Object)method, new Object[0]);
            return (String)getNameMethod.invoke(parameters[parameterIndex], new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    static {
        try {
            parameterClass = Class.forName("java.lang.reflect.Parameter");
            getNameMethod = parameterClass.getMethod("getName", new Class[0]);
            getParametersMethod = Method.class.getMethod("getParameters", new Class[0]);
        }
        catch (Exception e) {
            parameterSupported = false;
            parameterClass = null;
            getNameMethod = null;
            getParametersMethod = null;
        }
    }
}

