/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableBuffer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.ResourceImpl;
import org.apache.datasketches.memory.internal.Util;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LeafImplTest {
    private static final ByteOrder NBO = ByteOrder.nativeOrder();
    private static final ByteOrder NNBO = Util.NON_NATIVE_BYTE_ORDER;
    private static final MemoryRequestServer dummyMemReqSvr = new DummyMemoryRequestServer();

    @Test
    public void checkDirectLeaves() throws Exception {
        long off = 0L;
        long cap = 128L;
        try (WritableMemory memNO = WritableMemory.allocateDirect((long)cap, (ByteOrder)NBO, (MemoryRequestServer)dummyMemReqSvr);){
            memNO.putShort(0L, (short)1);
            Assert.assertNull((Object)((ResourceImpl)memNO).getUnsafeObject());
            Assert.assertTrue((boolean)memNO.isDirect());
            LeafImplTest.checkCombinations(memNO, off, cap, memNO.isDirect(), NBO, false, true);
        }
        var6_4 = null;
        try (WritableMemory memNNO = WritableMemory.allocateDirect((long)cap, (ByteOrder)NNBO, (MemoryRequestServer)dummyMemReqSvr);){
            memNNO.putShort(0L, (short)1);
            Assert.assertNull((Object)((ResourceImpl)memNNO).getUnsafeObject());
            Assert.assertTrue((boolean)memNNO.isDirect());
            LeafImplTest.checkCombinations(memNNO, off, cap, memNNO.isDirect(), NNBO, false, true);
        }
        catch (Throwable throwable) {
            var6_4 = throwable;
            throw throwable;
        }
    }

    @Test
    public void checkByteBufferLeaves() {
        long off = 0L;
        long cap = 128L;
        ByteBuffer bb = ByteBuffer.allocate((int)cap);
        bb.order(NBO);
        bb.putShort(0, (short)1);
        WritableMemory mem = WritableMemory.writableWrap((ByteBuffer)bb, (ByteOrder)NBO, (MemoryRequestServer)dummyMemReqSvr);
        Assert.assertEquals((boolean)bb.isDirect(), (boolean)mem.isDirect());
        Assert.assertNotNull((Object)((ResourceImpl)mem).getUnsafeObject());
        LeafImplTest.checkCombinations(mem, off, cap, mem.isDirect(), mem.getTypeByteOrder(), true, true);
        ByteBuffer dbb = ByteBuffer.allocateDirect((int)cap);
        dbb.order(NBO);
        dbb.putShort(0, (short)1);
        mem = WritableMemory.writableWrap((ByteBuffer)dbb, (ByteOrder)NBO, (MemoryRequestServer)dummyMemReqSvr);
        Assert.assertEquals((boolean)dbb.isDirect(), (boolean)mem.isDirect());
        Assert.assertNull((Object)((ResourceImpl)mem).getUnsafeObject());
        LeafImplTest.checkCombinations(mem, off, cap, mem.isDirect(), mem.getTypeByteOrder(), true, true);
        bb = ByteBuffer.allocate((int)cap);
        bb.order(NNBO);
        bb.putShort(0, (short)1);
        mem = WritableMemory.writableWrap((ByteBuffer)bb, (ByteOrder)NNBO, (MemoryRequestServer)dummyMemReqSvr);
        Assert.assertEquals((boolean)bb.isDirect(), (boolean)mem.isDirect());
        Assert.assertNotNull((Object)((ResourceImpl)mem).getUnsafeObject());
        LeafImplTest.checkCombinations(mem, off, cap, mem.isDirect(), mem.getTypeByteOrder(), true, true);
        dbb = ByteBuffer.allocateDirect((int)cap);
        dbb.order(NNBO);
        dbb.putShort(0, (short)1);
        mem = WritableMemory.writableWrap((ByteBuffer)dbb, (ByteOrder)NNBO, (MemoryRequestServer)dummyMemReqSvr);
        Assert.assertEquals((boolean)dbb.isDirect(), (boolean)mem.isDirect());
        Assert.assertNull((Object)((ResourceImpl)mem).getUnsafeObject());
        LeafImplTest.checkCombinations(mem, off, cap, mem.isDirect(), mem.getTypeByteOrder(), true, true);
    }

    @Test
    public void checkMapLeaves() throws Exception {
        long off = 0L;
        long cap = 128L;
        File file = new File("TestFile2.bin");
        if (file.exists()) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Assert.assertTrue((boolean)file.createNewFile());
        Assert.assertTrue((boolean)file.setWritable(true, false));
        Assert.assertTrue((boolean)file.isFile());
        file.deleteOnExit();
        try (WritableMemory memNO = WritableMemory.writableMap((File)file, (long)off, (long)cap, (ByteOrder)NBO);){
            memNO.putShort(0L, (short)1);
            Assert.assertNull((Object)((ResourceImpl)memNO).getUnsafeObject());
            Assert.assertTrue((boolean)memNO.isDirect());
            LeafImplTest.checkCombinations(memNO, off, cap, memNO.isDirect(), NBO, false, false);
        }
        var7_6 = null;
        try (WritableMemory memNNO = WritableMemory.writableMap((File)file, (long)off, (long)cap, (ByteOrder)NNBO);){
            memNNO.putShort(0L, (short)1);
            Assert.assertNull((Object)((ResourceImpl)memNNO).getUnsafeObject());
            Assert.assertTrue((boolean)memNNO.isDirect());
            LeafImplTest.checkCombinations(memNNO, off, cap, memNNO.isDirect(), NNBO, false, false);
        }
        catch (Throwable throwable) {
            var7_6 = throwable;
            throw throwable;
        }
    }

    @Test
    public void checkHeapLeaves() {
        long off = 0L;
        long cap = 128L;
        WritableMemory memNO = WritableMemory.allocate((int)((int)cap));
        memNO.putShort(0L, (short)1);
        Assert.assertNotNull((Object)((ResourceImpl)memNO).getUnsafeObject());
        Assert.assertFalse((boolean)memNO.isDirect());
        LeafImplTest.checkCombinations(memNO, off, cap, memNO.isDirect(), NBO, false, false);
        WritableMemory memNNO = WritableMemory.allocate((int)((int)cap), (ByteOrder)NNBO);
        memNNO.putShort(0L, (short)1);
        Assert.assertNotNull((Object)((ResourceImpl)memNNO).getUnsafeObject());
        Assert.assertFalse((boolean)memNNO.isDirect());
        LeafImplTest.checkCombinations(memNNO, off, cap, memNNO.isDirect(), NNBO, false, false);
    }

    private static void checkCombinations(WritableMemory mem, long off, long cap, boolean direct, ByteOrder bo, boolean hasByteBuffer, boolean hasMemReqSvr) {
        ByteOrder oo = Util.otherByteOrder((ByteOrder)bo);
        Assert.assertEquals((int)mem.writableRegion(off, cap, bo).getShort(0L), (int)1);
        Assert.assertEquals((int)mem.writableRegion(off, cap, oo).getShort(0L), (int)256);
        Assert.assertEquals((int)mem.asWritableBuffer(bo).getShort(0L), (int)1);
        Assert.assertEquals((int)mem.asWritableBuffer(oo).getShort(0L), (int)256);
        Assert.assertEquals((long)mem.getRelativeOffset(), (long)0L);
        ByteBuffer bb = ((ResourceImpl)mem).getByteBuffer();
        Assert.assertTrue((boolean)(hasByteBuffer ? bb != null : bb == null));
        Assert.assertTrue((mem.getTypeByteOrder() == bo ? 1 : 0) != 0);
        if (hasMemReqSvr) {
            Assert.assertTrue((boolean)(mem.getMemoryRequestServer() instanceof DummyMemoryRequestServer));
        } else {
            Assert.assertNull((Object)mem.getMemoryRequestServer());
        }
        Object obj = ((ResourceImpl)mem).getUnsafeObject();
        if (direct) {
            Assert.assertTrue((boolean)mem.isDirect());
            Assert.assertNull((Object)obj);
            Assert.assertTrue((((ResourceImpl)mem).getCumulativeOffset(0L) != 0L ? 1 : 0) != 0);
        } else {
            Assert.assertFalse((boolean)mem.isDirect());
            Assert.assertNotNull((Object)obj);
            Assert.assertTrue((((ResourceImpl)mem).getCumulativeOffset(0L) != 0L ? 1 : 0) != 0);
        }
        Assert.assertTrue((mem.isAlive() ? 1 : 0) != 0);
        WritableBuffer buf = mem.asWritableBuffer();
        Assert.assertEquals((int)buf.writableRegion(off, cap, bo).getShort(0L), (int)1);
        Assert.assertEquals((int)buf.writableRegion(off, cap, oo).getShort(0L), (int)256);
        Assert.assertEquals((int)buf.writableDuplicate(bo).getShort(0L), (int)1);
        Assert.assertEquals((int)buf.writableDuplicate(oo).getShort(0L), (int)256);
        Assert.assertEquals((long)buf.getRelativeOffset(), (long)0L);
        bb = ((ResourceImpl)buf).getByteBuffer();
        Assert.assertTrue((boolean)(hasByteBuffer ? bb != null : bb == null));
        Assert.assertTrue((buf.getTypeByteOrder() == bo ? 1 : 0) != 0);
        if (hasMemReqSvr) {
            Assert.assertTrue((boolean)(buf.getMemoryRequestServer() instanceof DummyMemoryRequestServer));
        } else {
            Assert.assertNull((Object)buf.getMemoryRequestServer());
        }
        obj = ((ResourceImpl)buf).getUnsafeObject();
        if (direct) {
            Assert.assertTrue((boolean)buf.isDirect());
            Assert.assertNull((Object)obj);
            Assert.assertTrue((((ResourceImpl)buf).getCumulativeOffset(0L) != 0L ? 1 : 0) != 0);
        } else {
            Assert.assertFalse((boolean)buf.isDirect());
            Assert.assertNotNull((Object)obj);
            Assert.assertTrue((((ResourceImpl)buf).getCumulativeOffset(0L) != 0L ? 1 : 0) != 0);
        }
        Assert.assertTrue((buf.isAlive() ? 1 : 0) != 0);
        WritableMemory nnMem = mem.writableRegion(off, cap, oo);
        Assert.assertEquals((int)nnMem.writableRegion(off, cap, bo).getShort(0L), (int)1);
        Assert.assertEquals((int)nnMem.writableRegion(off, cap, oo).getShort(0L), (int)256);
        Assert.assertEquals((int)nnMem.asWritableBuffer(bo).getShort(0L), (int)1);
        Assert.assertEquals((int)nnMem.asWritableBuffer(oo).getShort(0L), (int)256);
        bb = ((ResourceImpl)nnMem).getByteBuffer();
        Assert.assertTrue((boolean)(hasByteBuffer ? bb != null : bb == null));
        Assert.assertTrue((nnMem.getTypeByteOrder() == oo ? 1 : 0) != 0);
        if (hasMemReqSvr) {
            Assert.assertTrue((boolean)(nnMem.getMemoryRequestServer() instanceof DummyMemoryRequestServer));
        }
        obj = ((ResourceImpl)nnMem).getUnsafeObject();
        if (direct) {
            Assert.assertTrue((boolean)nnMem.isDirect());
            Assert.assertNull((Object)obj);
            Assert.assertTrue((((ResourceImpl)nnMem).getCumulativeOffset(0L) != 0L ? 1 : 0) != 0);
        } else {
            Assert.assertFalse((boolean)nnMem.isDirect());
            Assert.assertNotNull((Object)obj);
            Assert.assertTrue((((ResourceImpl)nnMem).getCumulativeOffset(0L) != 0L ? 1 : 0) != 0);
        }
        Assert.assertTrue((nnMem.isAlive() ? 1 : 0) != 0);
        WritableBuffer nnBuf = mem.asWritableBuffer(oo);
        Assert.assertEquals((int)nnBuf.writableRegion(off, cap, bo).getShort(0L), (int)1);
        Assert.assertEquals((int)nnBuf.writableRegion(off, cap, oo).getShort(0L), (int)256);
        Assert.assertEquals((int)nnBuf.writableDuplicate(bo).getShort(0L), (int)1);
        Assert.assertEquals((int)nnBuf.writableDuplicate(oo).getShort(0L), (int)256);
        bb = ((ResourceImpl)nnBuf).getByteBuffer();
        Assert.assertTrue((boolean)(hasByteBuffer ? bb != null : bb == null));
        Assert.assertTrue((nnBuf.getTypeByteOrder() == oo ? 1 : 0) != 0);
        if (hasMemReqSvr) {
            Assert.assertTrue((boolean)(nnBuf.getMemoryRequestServer() instanceof DummyMemoryRequestServer));
        }
        obj = ((ResourceImpl)nnBuf).getUnsafeObject();
        if (direct) {
            Assert.assertTrue((boolean)nnBuf.isDirect());
            Assert.assertNull((Object)obj);
            Assert.assertTrue((((ResourceImpl)nnBuf).getCumulativeOffset(0L) != 0L ? 1 : 0) != 0);
        } else {
            Assert.assertFalse((boolean)nnBuf.isDirect());
            Assert.assertNotNull((Object)obj);
            Assert.assertTrue((((ResourceImpl)nnBuf).getCumulativeOffset(0L) != 0L ? 1 : 0) != 0);
        }
        Assert.assertTrue((nnBuf.isAlive() ? 1 : 0) != 0);
    }

    static class DummyMemoryRequestServer
    implements MemoryRequestServer {
        DummyMemoryRequestServer() {
        }

        public WritableMemory request(WritableMemory currentWMem, long capacityBytes) {
            return null;
        }

        public void requestClose(WritableMemory memToClose, WritableMemory newMemory) {
        }
    }
}

