/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantilescommon;

import java.util.Comparator;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.kll.KllItemsSketch;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.datasketches.quantilescommon.GenericPartitionBoundaries;
import org.apache.datasketches.quantilescommon.GenericSortedViewIterator;
import org.apache.datasketches.quantilescommon.ItemsSketchSortedView;
import org.apache.datasketches.quantilescommon.LongsAsOrderableStrings;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PartitionBoundariesTest {
    private ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();
    private static String[] hdr = new String[]{"N", "MaxItem", "MinItem", "NumParts", "SearchCriteria"};
    private static String hdrfmt = "%6s %10s %10s %10s %15s" + Util.LS;
    private static String hdrdfmt = "%6d %10s %10s %10d %15s" + Util.LS;
    private static String[] rowhdr = new String[]{"Row", "NormRanks", "NatRanks", "Boundaries", "DeltaItems"};
    private static String rowhdrfmt = "%5s %12s %12s %12s %12s" + Util.LS;
    private static String rowdfmt = "%5d %12.8f %12d %12s %12d" + Util.LS;
    private static String[] rowhdr2 = new String[]{"Row", "NormRanks", "NatRanks", "Boundaries"};
    private static String rowhdrfmt2 = "%5s %12s %12s %12s" + Util.LS;
    private static String rowdfmt2 = "%5d %12.8f %12d %12s" + Util.LS;
    private static final boolean enablePrinting = false;

    public void checkSkewWithClassic() {
        long i;
        int n = 2050;
        int k = 32768;
        int n2 = 200;
        int totalN = n + n2;
        int numDigits = LongsAsOrderableStrings.digits(totalN);
        long v2 = 1000L;
        QuantileSearchCriteria searchCrit = QuantileSearchCriteria.INCLUSIVE;
        ItemsSketch sk = ItemsSketch.getInstance(String.class, (int)k, Comparator.naturalOrder());
        for (i = 1L; i <= (long)n; ++i) {
            sk.update((Object)LongsAsOrderableStrings.getString(i, numDigits));
        }
        for (i = 1L; i <= (long)n2; ++i) {
            sk.update((Object)LongsAsOrderableStrings.getString(v2, numDigits));
        }
        int numParts = sk.getMaxPartitions();
        ItemsSketchSortedView sv = sk.getSortedView();
        GenericSortedViewIterator itr = sv.iterator();
        PartitionBoundariesTest.println("SORTED VIEW:");
        PartitionBoundariesTest.printf(rowhdrfmt2, rowhdr2);
        int j = 0;
        while (itr.next()) {
            PartitionBoundariesTest.printf(rowdfmt2, j++, itr.getNormalizedRank(searchCrit), itr.getNaturalRank(searchCrit), itr.getQuantile());
        }
        GenericPartitionBoundaries gpb = sv.getPartitionBoundariesFromNumParts(numParts, searchCrit);
        int arrLen = ((String[])gpb.getBoundaries()).length;
        double[] normRanks = gpb.getNormalizedRanks();
        long[] natRanks = gpb.getNaturalRanks();
        String[] boundaries = (String[])gpb.getBoundaries();
        long[] numDeltaItems = gpb.getNumDeltaItems();
        PartitionBoundariesTest.println("");
        PartitionBoundariesTest.println("GET PARTITION BOUNDARIES:");
        PartitionBoundariesTest.printf(hdrfmt, hdr);
        PartitionBoundariesTest.printf(hdrdfmt, totalN, gpb.getMaxItem(), gpb.getMinItem(), numParts, searchCrit.toString());
        PartitionBoundariesTest.println("");
        PartitionBoundariesTest.printf(rowhdrfmt, rowhdr);
        for (int i2 = 0; i2 < arrLen; ++i2) {
            PartitionBoundariesTest.printf(rowdfmt, i2, normRanks[i2], natRanks[i2], boundaries[i2], numDeltaItems[i2]);
        }
    }

    public void checkSkewWithKll() {
        long i;
        int n = 2050;
        int k = 32768;
        int n2 = 200;
        int totalN = n + n2;
        int numDigits = LongsAsOrderableStrings.digits(totalN);
        long v2 = 1000L;
        QuantileSearchCriteria searchCrit = QuantileSearchCriteria.INCLUSIVE;
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)k, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        for (i = 1L; i <= (long)n; ++i) {
            sk.update((Object)LongsAsOrderableStrings.getString(i, numDigits));
        }
        for (i = 1L; i <= (long)n2; ++i) {
            sk.update((Object)LongsAsOrderableStrings.getString(v2, numDigits));
        }
        int numParts = sk.getMaxPartitions();
        ItemsSketchSortedView sv = sk.getSortedView();
        GenericSortedViewIterator itr = sv.iterator();
        PartitionBoundariesTest.println("SORTED VIEW:");
        PartitionBoundariesTest.printf(rowhdrfmt2, rowhdr2);
        int j = 0;
        while (itr.next()) {
            PartitionBoundariesTest.printf(rowdfmt2, j++, itr.getNormalizedRank(searchCrit), itr.getNaturalRank(searchCrit), itr.getQuantile());
        }
        GenericPartitionBoundaries gpb = sv.getPartitionBoundariesFromNumParts(numParts, searchCrit);
        int arrLen = ((String[])gpb.getBoundaries()).length;
        double[] normRanks = gpb.getNormalizedRanks();
        long[] natRanks = gpb.getNaturalRanks();
        String[] boundaries = (String[])gpb.getBoundaries();
        long[] numDeltaItems = gpb.getNumDeltaItems();
        PartitionBoundariesTest.println("");
        PartitionBoundariesTest.println("GET PARTITION BOUNDARIES:");
        PartitionBoundariesTest.printf(hdrfmt, hdr);
        PartitionBoundariesTest.printf(hdrdfmt, totalN, gpb.getMaxItem(), gpb.getMinItem(), numParts, searchCrit.toString());
        PartitionBoundariesTest.println("");
        PartitionBoundariesTest.printf(rowhdrfmt, rowhdr);
        for (int i2 = 0; i2 < arrLen; ++i2) {
            PartitionBoundariesTest.printf(rowdfmt, i2, normRanks[i2], natRanks[i2], boundaries[i2], numDeltaItems[i2]);
        }
    }

    @Test
    public void getQuantilesVsPartitionBoundariesKll() {
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sketch.update((Object)"A");
        sketch.update((Object)"B");
        sketch.update((Object)"C");
        sketch.update((Object)"D");
        Object[] quantiles1 = (String[])sketch.getQuantiles(new double[]{0.0, 0.5, 1.0}, QuantileSearchCriteria.EXCLUSIVE);
        Object[] quantiles2 = (String[])sketch.getPartitionBoundariesFromNumParts(2, QuantileSearchCriteria.EXCLUSIVE).getBoundaries();
        Assert.assertEquals((Object[])quantiles1, (Object[])quantiles2);
        quantiles1 = (String[])sketch.getQuantiles(new double[]{0.0, 0.5, 1.0}, QuantileSearchCriteria.INCLUSIVE);
        quantiles2 = (String[])sketch.getPartitionBoundariesFromNumParts(2, QuantileSearchCriteria.INCLUSIVE).getBoundaries();
        Assert.assertEquals((Object[])quantiles1, (Object[])quantiles2);
    }

    @Test
    public void getQuantilesVsPartitionBoundariesClassic() {
        ItemsSketch sketch = ItemsSketch.getInstance(Integer.class, Comparator.naturalOrder());
        sketch.update((Object)1);
        sketch.update((Object)2);
        sketch.update((Object)3);
        sketch.update((Object)4);
        Object[] quantiles1 = (Integer[])sketch.getQuantiles(new double[]{0.0, 0.5, 1.0}, QuantileSearchCriteria.EXCLUSIVE);
        Object[] quantiles2 = (Integer[])sketch.getPartitionBoundariesFromNumParts(2, QuantileSearchCriteria.EXCLUSIVE).getBoundaries();
        Assert.assertEquals((Object[])quantiles1, (Object[])quantiles2);
        quantiles1 = (Integer[])sketch.getQuantiles(new double[]{0.0, 0.5, 1.0}, QuantileSearchCriteria.INCLUSIVE);
        quantiles2 = (Integer[])sketch.getPartitionBoundariesFromNumParts(2, QuantileSearchCriteria.INCLUSIVE).getBoundaries();
        Assert.assertEquals((Object[])quantiles1, (Object[])quantiles2);
    }

    @Test
    public void checkSimpleEndsAdjustment() {
        Object[] quantiles = new String[]{"2", "4", "6", "7"};
        long[] cumWeights = new long[]{2L, 4L, 6L, 8L};
        long totalN = 8L;
        Comparator comparator = Comparator.naturalOrder();
        String maxItem = "8";
        String minItem = "1";
        ItemsSketchSortedView sv = new ItemsSketchSortedView(quantiles, cumWeights, 8L, comparator, (Object)"8", (Object)"1", String.class, 0.01, 4);
        GenericSortedViewIterator itr = sv.iterator();
        while (itr.next()) {
            PartitionBoundariesTest.println(itr.getNaturalRank(QuantileSearchCriteria.INCLUSIVE) + ", " + (String)itr.getQuantile(QuantileSearchCriteria.INCLUSIVE));
        }
        GenericPartitionBoundaries gpb = sv.getPartitionBoundariesFromNumParts(2);
        Object[] boundaries = (String[])gpb.getBoundaries();
        long[] natRanks = gpb.getNaturalRanks();
        double[] normRanks = gpb.getNormalizedRanks();
        long[] deltaItems = gpb.getNumDeltaItems();
        int numParts = gpb.getNumPartitions();
        String maxItm = (String)gpb.getMaxItem();
        String minItm = (String)gpb.getMinItem();
        Assert.assertEquals((Object[])boundaries, (Object[])new String[]{"1", "4", "8"});
        Assert.assertEquals((long[])natRanks, (long[])new long[]{1L, 4L, 8L});
        Assert.assertEquals((double[])normRanks, (double[])new double[]{0.125, 0.5, 1.0});
        Assert.assertEquals((long[])deltaItems, (long[])new long[]{0L, 4L, 4L});
        Assert.assertEquals((int)numParts, (int)2);
        Assert.assertEquals((String)maxItm, (String)"8");
        Assert.assertEquals((String)minItm, (String)"1");
    }

    @Test
    public void checkSketchPartitionLimits() {
        long totalN = 2000L;
        Comparator comparator = Comparator.naturalOrder();
        ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();
        int k = 32768;
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)32768, comparator, (ArrayOfItemsSerDe)serDe);
        int d = LongsAsOrderableStrings.digits(2000L);
        int i = 1;
        while ((long)i <= 2000L) {
            sk.update((Object)LongsAsOrderableStrings.getString(i, d));
            ++i;
        }
        int numRet = sk.getNumRetained();
        PartitionBoundariesTest.println("NumRetained: " + numRet + " /2: " + numRet / 2);
        double eps = sk.getNormalizedRankError(true);
        PartitionBoundariesTest.printf("NormRankErr: %10.6f     1/eps: %10.3f" + Util.LS, eps, 1.0 / eps);
        int goodNumPartsRequest = sk.getMaxPartitions();
        PartitionBoundariesTest.println("Good numPartsRequest " + goodNumPartsRequest);
        GenericPartitionBoundaries gpb = sk.getPartitionBoundariesFromNumParts(goodNumPartsRequest);
        try {
            int badNumPartsRequest = goodNumPartsRequest + 1;
            PartitionBoundariesTest.println("Bad numPartsRequest " + badNumPartsRequest);
            gpb = sk.getPartitionBoundariesFromNumParts(badNumPartsRequest);
            Assert.fail((String)("Bad numPartsRequest should have failed. " + badNumPartsRequest));
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkSketchPartitionLimits2() {
        long totalN = 2000L;
        Comparator comparator = Comparator.naturalOrder();
        ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();
        int k = 32768;
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)32768, comparator, (ArrayOfItemsSerDe)serDe);
        int d = LongsAsOrderableStrings.digits(2000L);
        int i = 1;
        while ((long)i <= 2000L) {
            sk.update((Object)LongsAsOrderableStrings.getString(i, d));
            ++i;
        }
        double eps = sk.getNormalizedRankError(true);
        PartitionBoundariesTest.printf("NormRankErr: %10.6f     1/eps: %10.3f" + Util.LS, eps, 1.0 / eps);
        PartitionBoundariesTest.println("N: " + sk.getN());
        PartitionBoundariesTest.println("Max Parts: " + sk.getMaxPartitions());
        long goodPartSizeRequest = sk.getMinPartitionSizeItems();
        PartitionBoundariesTest.println("Good partSizeRequest " + goodPartSizeRequest);
        GenericPartitionBoundaries gpb = sk.getPartitionBoundariesFromPartSize(goodPartSizeRequest);
        try {
            long badPartSizeRequest = goodPartSizeRequest - 1L;
            PartitionBoundariesTest.println("Bad partSizeRequest " + badPartSizeRequest);
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void printlnTest() {
        PartitionBoundariesTest.println("PRINTING: " + this.getClass().getName());
    }

    static final void printf(String format, Object ... args) {
    }

    static final void println(Object o) {
    }
}

