/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.JaroWinklerDistance;
import org.apache.commons.text.similarity.SimilarityInputTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class JaroWinklerDistanceTest {
    private static JaroWinklerDistance distance;

    JaroWinklerDistanceTest() {
    }

    @BeforeAll
    public static void setUp() {
        distance = new JaroWinklerDistance();
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.text.similarity.SimilarityInputTest#similarityInputsEquals()"})
    void testGetJaroWinklerDistance(Class<?> cls) {
        Assertions.assertEquals((double)0.07501, (double)distance.apply(SimilarityInputTest.build(cls, "frog"), SimilarityInputTest.build(cls, "fog")), (double)1.0E-5);
        Assertions.assertEquals((double)1.0, (double)distance.apply(SimilarityInputTest.build(cls, "fly"), SimilarityInputTest.build(cls, "ant")), (double)1.0E-20);
        Assertions.assertEquals((double)0.55834, (double)distance.apply(SimilarityInputTest.build(cls, "elephant"), SimilarityInputTest.build(cls, "hippo")), (double)1.0E-5);
        Assertions.assertEquals((double)0.09334, (double)distance.apply(SimilarityInputTest.build(cls, "ABC Corporation"), SimilarityInputTest.build(cls, "ABC Corp")), (double)1.0E-5);
        Assertions.assertEquals((double)0.04749, (double)distance.apply(SimilarityInputTest.build(cls, "D N H Enterprises Inc"), SimilarityInputTest.build(cls, "D & H Enterprises, Inc.")), (double)1.0E-5);
        Assertions.assertEquals((double)0.058, (double)distance.apply(SimilarityInputTest.build(cls, "My Gym Children's Fitness Center"), SimilarityInputTest.build(cls, "My Gym. Childrens Fitness")), (double)1.0E-5);
        Assertions.assertEquals((double)0.101982, (double)distance.apply(SimilarityInputTest.build(cls, "PENNSYLVANIA"), SimilarityInputTest.build(cls, "PENNCISYLVNIA")), (double)1.0E-5);
        Assertions.assertEquals((double)0.028572, (double)distance.apply(SimilarityInputTest.build(cls, "/opt/software1"), SimilarityInputTest.build(cls, "/opt/software2")), (double)1.0E-5);
        Assertions.assertEquals((double)0.058334, (double)distance.apply(SimilarityInputTest.build(cls, "aaabcd"), SimilarityInputTest.build(cls, "aaacdb")), (double)1.0E-5);
        Assertions.assertEquals((double)0.088889, (double)distance.apply(SimilarityInputTest.build(cls, "John Horn"), SimilarityInputTest.build(cls, "John Hopkins")), (double)1.0E-5);
        Assertions.assertEquals((double)0.0, (double)distance.apply(SimilarityInputTest.build(cls, ""), SimilarityInputTest.build(cls, "")), (double)1.0E-5);
        Assertions.assertEquals((double)0.0, (double)distance.apply(SimilarityInputTest.build(cls, "foo"), SimilarityInputTest.build(cls, "foo")), (double)1.0E-5);
        Assertions.assertEquals((double)0.05833999999999995, (double)distance.apply(SimilarityInputTest.build(cls, "foo"), SimilarityInputTest.build(cls, "foo ")), (double)1.0E-5);
        Assertions.assertEquals((double)0.09333999999999998, (double)distance.apply(SimilarityInputTest.build(cls, "foo"), SimilarityInputTest.build(cls, "foo  ")), (double)1.0E-5);
        Assertions.assertEquals((double)0.13334000000000001, (double)distance.apply(SimilarityInputTest.build(cls, "foo"), SimilarityInputTest.build(cls, " foo ")), (double)1.0E-5);
        Assertions.assertEquals((double)0.48889000000000005, (double)distance.apply(SimilarityInputTest.build(cls, "foo"), SimilarityInputTest.build(cls, "  foo")), (double)1.0E-5);
    }

    @Test
    void testGetJaroWinklerDistance_NullNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> distance.apply((CharSequence)null, null));
    }

    @Test
    void testGetJaroWinklerDistance_NullString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> distance.apply(null, (CharSequence)"clear"));
    }

    @Test
    void testGetJaroWinklerDistance_StringNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> distance.apply((CharSequence)" ", null));
    }

    @Test
    void testGetJaroWinklerDistance_StringString() {
        Assertions.assertEquals((double)0.07501, (double)distance.apply((CharSequence)"frog", (CharSequence)"fog"), (double)1.0E-5);
        Assertions.assertEquals((double)1.0, (double)distance.apply((CharSequence)"fly", (CharSequence)"ant"), (double)1.0E-20);
        Assertions.assertEquals((double)0.55834, (double)distance.apply((CharSequence)"elephant", (CharSequence)"hippo"), (double)1.0E-5);
        Assertions.assertEquals((double)0.09334, (double)distance.apply((CharSequence)"ABC Corporation", (CharSequence)"ABC Corp"), (double)1.0E-5);
        Assertions.assertEquals((double)0.04749, (double)distance.apply((CharSequence)"D N H Enterprises Inc", (CharSequence)"D & H Enterprises, Inc."), (double)1.0E-5);
        Assertions.assertEquals((double)0.058, (double)distance.apply((CharSequence)"My Gym Children's Fitness Center", (CharSequence)"My Gym. Childrens Fitness"), (double)1.0E-5);
        Assertions.assertEquals((double)0.101982, (double)distance.apply((CharSequence)"PENNSYLVANIA", (CharSequence)"PENNCISYLVNIA"), (double)1.0E-5);
        Assertions.assertEquals((double)0.028572, (double)distance.apply((CharSequence)"/opt/software1", (CharSequence)"/opt/software2"), (double)1.0E-5);
        Assertions.assertEquals((double)0.058334, (double)distance.apply((CharSequence)"aaabcd", (CharSequence)"aaacdb"), (double)1.0E-5);
        Assertions.assertEquals((double)0.088889, (double)distance.apply((CharSequence)"John Horn", (CharSequence)"John Hopkins"), (double)1.0E-5);
        Assertions.assertEquals((double)0.0, (double)distance.apply((CharSequence)"", (CharSequence)""), (double)1.0E-5);
        Assertions.assertEquals((double)0.0, (double)distance.apply((CharSequence)"foo", (CharSequence)"foo"), (double)1.0E-5);
        Assertions.assertEquals((double)0.05833999999999995, (double)distance.apply((CharSequence)"foo", (CharSequence)"foo "), (double)1.0E-5);
        Assertions.assertEquals((double)0.09333999999999998, (double)distance.apply((CharSequence)"foo", (CharSequence)"foo  "), (double)1.0E-5);
        Assertions.assertEquals((double)0.13334000000000001, (double)distance.apply((CharSequence)"foo", (CharSequence)" foo "), (double)1.0E-5);
        Assertions.assertEquals((double)0.48889000000000005, (double)distance.apply((CharSequence)"foo", (CharSequence)"  foo"), (double)1.0E-5);
    }
}

