/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.commons.text.WordUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class WordUtilsTest {
    @Test
    public void testConstructor() {
        Assertions.assertThat((Object)new WordUtils()).isNotNull();
        Constructor<?>[] cons = WordUtils.class.getDeclaredConstructors();
        Assertions.assertThat((int)cons.length).isEqualTo(1);
        Assertions.assertThat((boolean)Modifier.isPublic(cons[0].getModifiers())).isTrue();
        Assertions.assertThat((boolean)Modifier.isPublic(WordUtils.class.getModifiers())).isTrue();
        Assertions.assertThat((boolean)Modifier.isFinal(WordUtils.class.getModifiers())).isFalse();
    }

    @Test
    public void testWrap_StringInt() {
        Assertions.assertThat((String)WordUtils.wrap(null, (int)20)).isNull();
        Assertions.assertThat((String)WordUtils.wrap(null, (int)-1)).isNull();
        Assertions.assertThat((String)WordUtils.wrap((String)"", (int)20)).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.wrap((String)"", (int)-1)).isEqualTo((Object)"");
        String systemNewLine = System.lineSeparator();
        String input = "Here is one line of text that is going to be wrapped after 20 columns.";
        String expected = "Here is one line of" + systemNewLine + "text that is going" + systemNewLine + "to be wrapped after" + systemNewLine + "20 columns.";
        Assertions.assertThat((String)WordUtils.wrap((String)input, (int)20)).isEqualTo((Object)expected);
        input = "Click here to jump to the commons website - http://commons.apache.org";
        expected = "Click here to jump" + systemNewLine + "to the commons" + systemNewLine + "website -" + systemNewLine + "http://commons.apache.org";
        Assertions.assertThat((String)WordUtils.wrap((String)input, (int)20)).isEqualTo((Object)expected);
        input = "Click here, http://commons.apache.org, to jump to the commons website";
        expected = "Click here," + systemNewLine + "http://commons.apache.org," + systemNewLine + "to jump to the" + systemNewLine + "commons website";
        Assertions.assertThat((String)WordUtils.wrap((String)input, (int)20)).isEqualTo((Object)expected);
        input = "word1             word2                        word3";
        expected = "word1  " + systemNewLine + "word2  " + systemNewLine + "word3";
        Assertions.assertThat((String)WordUtils.wrap((String)input, (int)7)).isEqualTo((Object)expected);
    }

    @Test
    public void testWrap_StringIntStringBoolean() {
        Assertions.assertThat((String)WordUtils.wrap(null, (int)20, (String)"\n", (boolean)false)).isNull();
        Assertions.assertThat((String)WordUtils.wrap(null, (int)20, (String)"\n", (boolean)true)).isNull();
        Assertions.assertThat((String)WordUtils.wrap(null, (int)20, null, (boolean)true)).isNull();
        Assertions.assertThat((String)WordUtils.wrap(null, (int)20, null, (boolean)false)).isNull();
        Assertions.assertThat((String)WordUtils.wrap(null, (int)-1, null, (boolean)true)).isNull();
        Assertions.assertThat((String)WordUtils.wrap(null, (int)-1, null, (boolean)false)).isNull();
        Assertions.assertThat((String)WordUtils.wrap((String)"", (int)20, (String)"\n", (boolean)false)).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.wrap((String)"", (int)20, (String)"\n", (boolean)true)).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.wrap((String)"", (int)20, null, (boolean)false)).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.wrap((String)"", (int)20, null, (boolean)true)).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.wrap((String)"", (int)-1, null, (boolean)false)).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.wrap((String)"", (int)-1, null, (boolean)true)).isEqualTo((Object)"");
        String input = "Here is one line of text that is going to be wrapped after 20 columns.";
        String expected = "Here is one line of\ntext that is going\nto be wrapped after\n20 columns.";
        Assertions.assertThat((String)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false)).isEqualTo((Object)expected);
        Assertions.assertThat((String)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true)).isEqualTo((Object)expected);
        input = "Here is one line of text that is going to be wrapped after 20 columns.";
        expected = "Here is one line of<br />text that is going<br />to be wrapped after<br />20 columns.";
        Assertions.assertThat((String)WordUtils.wrap((String)input, (int)20, (String)"<br />", (boolean)false)).isEqualTo((Object)expected);
        Assertions.assertThat((String)WordUtils.wrap((String)input, (int)20, (String)"<br />", (boolean)true)).isEqualTo((Object)expected);
        input = "Here is one line";
        expected = "Here\nis one\nline";
        Assertions.assertThat((String)WordUtils.wrap((String)input, (int)6, (String)"\n", (boolean)false)).isEqualTo((Object)expected);
        expected = "Here\nis\none\nline";
        Assertions.assertThat((String)WordUtils.wrap((String)input, (int)2, (String)"\n", (boolean)false)).isEqualTo((Object)expected);
        Assertions.assertThat((String)WordUtils.wrap((String)input, (int)-1, (String)"\n", (boolean)false)).isEqualTo((Object)expected);
        String systemNewLine = System.lineSeparator();
        input = "Here is one line of text that is going to be wrapped after 20 columns.";
        expected = "Here is one line of" + systemNewLine + "text that is going" + systemNewLine + "to be wrapped after" + systemNewLine + "20 columns.";
        Assertions.assertThat((String)WordUtils.wrap((String)input, (int)20, null, (boolean)false)).isEqualTo((Object)expected);
        Assertions.assertThat((String)WordUtils.wrap((String)input, (int)20, null, (boolean)true)).isEqualTo((Object)expected);
        input = " Here:  is  one  line  of  text  that  is  going  to  be  wrapped  after  20  columns.";
        expected = "Here:  is  one  line\nof  text  that  is \ngoing  to  be \nwrapped  after  20 \ncolumns.";
        Assertions.assertThat((String)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false)).isEqualTo((Object)expected);
        Assertions.assertThat((String)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true)).isEqualTo((Object)expected);
        input = "Here is\tone line of text that is going to be wrapped after 20 columns.";
        expected = "Here is\tone line of\ntext that is going\nto be wrapped after\n20 columns.";
        Assertions.assertThat((String)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false)).isEqualTo((Object)expected);
        Assertions.assertThat((String)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true)).isEqualTo((Object)expected);
        input = "Here is one line of\ttext that is going to be wrapped after 20 columns.";
        expected = "Here is one line\nof\ttext that is\ngoing to be wrapped\nafter 20 columns.";
        Assertions.assertThat((String)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false)).isEqualTo((Object)expected);
        Assertions.assertThat((String)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true)).isEqualTo((Object)expected);
        input = "Click here to jump to the commons website - http://commons.apache.org";
        expected = "Click here to jump\nto the commons\nwebsite -\nhttp://commons.apache.org";
        Assertions.assertThat((String)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false)).isEqualTo((Object)expected);
        expected = "Click here to jump\nto the commons\nwebsite -\nhttp://commons.apach\ne.org";
        Assertions.assertThat((String)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true)).isEqualTo((Object)expected);
        input = "Click here, http://commons.apache.org, to jump to the commons website";
        expected = "Click here,\nhttp://commons.apache.org,\nto jump to the\ncommons website";
        Assertions.assertThat((String)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false)).isEqualTo((Object)expected);
        expected = "Click here,\nhttp://commons.apach\ne.org, to jump to\nthe commons website";
        Assertions.assertThat((String)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true)).isEqualTo((Object)expected);
    }

    @Test
    public void testWrap_StringIntStringBooleanString() {
        String input = "flammable/inflammable";
        String expected = "flammable/inflammable";
        Assertions.assertThat((String)WordUtils.wrap((String)input, (int)30, (String)"\n", (boolean)false, (String)"/")).isEqualTo((Object)expected);
        expected = "flammable\ninflammable";
        Assertions.assertThat((String)WordUtils.wrap((String)input, (int)2, (String)"\n", (boolean)false, (String)"/")).isEqualTo((Object)expected);
        expected = "flammable\ninflammab\nle";
        Assertions.assertThat((String)WordUtils.wrap((String)input, (int)9, (String)"\n", (boolean)true, (String)"/")).isEqualTo((Object)expected);
        expected = "flammable\ninflammable";
        Assertions.assertThat((String)WordUtils.wrap((String)input, (int)15, (String)"\n", (boolean)true, (String)"/")).isEqualTo((Object)expected);
        input = "flammableinflammable";
        expected = "flammableinflam\nmable";
        Assertions.assertThat((String)WordUtils.wrap((String)input, (int)15, (String)"\n", (boolean)true, (String)"/")).isEqualTo((Object)expected);
    }

    @Test
    public void testCapitalize_String() {
        Assertions.assertThat((String)WordUtils.capitalize(null)).isNull();
        Assertions.assertThat((String)WordUtils.capitalize((String)"")).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.capitalize((String)"  ")).isEqualTo((Object)"  ");
        Assertions.assertThat((String)WordUtils.capitalize((String)"I")).isEqualTo((Object)"I");
        Assertions.assertThat((String)WordUtils.capitalize((String)"i")).isEqualTo((Object)"I");
        Assertions.assertThat((String)WordUtils.capitalize((String)"i am here 123")).isEqualTo((Object)"I Am Here 123");
        Assertions.assertThat((String)WordUtils.capitalize((String)"I Am Here 123")).isEqualTo((Object)"I Am Here 123");
        Assertions.assertThat((String)WordUtils.capitalize((String)"i am HERE 123")).isEqualTo((Object)"I Am HERE 123");
        Assertions.assertThat((String)WordUtils.capitalize((String)"I AM HERE 123")).isEqualTo((Object)"I AM HERE 123");
    }

    @Test
    public void testCapitalizeWithDelimiters_String() {
        Assertions.assertThat((String)WordUtils.capitalize(null, null)).isNull();
        Assertions.assertThat((String)WordUtils.capitalize((String)"", (char[])new char[0])).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.capitalize((String)"  ", (char[])new char[0])).isEqualTo((Object)"  ");
        char[] chars = new char[]{'-', '+', ' ', '@'};
        Assertions.assertThat((String)WordUtils.capitalize((String)"I", (char[])chars)).isEqualTo((Object)"I");
        Assertions.assertThat((String)WordUtils.capitalize((String)"i", (char[])chars)).isEqualTo((Object)"I");
        Assertions.assertThat((String)WordUtils.capitalize((String)"i-am here+123", (char[])chars)).isEqualTo((Object)"I-Am Here+123");
        Assertions.assertThat((String)WordUtils.capitalize((String)"I Am+Here-123", (char[])chars)).isEqualTo((Object)"I Am+Here-123");
        Assertions.assertThat((String)WordUtils.capitalize((String)"i+am-HERE 123", (char[])chars)).isEqualTo((Object)"I+Am-HERE 123");
        Assertions.assertThat((String)WordUtils.capitalize((String)"I-AM HERE+123", (char[])chars)).isEqualTo((Object)"I-AM HERE+123");
        chars = new char[]{'.'};
        Assertions.assertThat((String)WordUtils.capitalize((String)"i aM.fine", (char[])chars)).isEqualTo((Object)"I aM.Fine");
        Assertions.assertThat((String)WordUtils.capitalize((String)"i am.fine", null)).isEqualTo((Object)"I Am.fine");
    }

    @Test
    public void testCapitalizeFully_String() {
        Assertions.assertThat((String)WordUtils.capitalizeFully(null)).isNull();
        Assertions.assertThat((String)WordUtils.capitalizeFully((String)"")).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.capitalizeFully((String)"  ")).isEqualTo((Object)"  ");
        Assertions.assertThat((String)WordUtils.capitalizeFully((String)"I")).isEqualTo((Object)"I");
        Assertions.assertThat((String)WordUtils.capitalizeFully((String)"i")).isEqualTo((Object)"I");
        Assertions.assertThat((String)WordUtils.capitalizeFully((String)"i am here 123")).isEqualTo((Object)"I Am Here 123");
        Assertions.assertThat((String)WordUtils.capitalizeFully((String)"I Am Here 123")).isEqualTo((Object)"I Am Here 123");
        Assertions.assertThat((String)WordUtils.capitalizeFully((String)"i am HERE 123")).isEqualTo((Object)"I Am Here 123");
        Assertions.assertThat((String)WordUtils.capitalizeFully((String)"I AM HERE 123")).isEqualTo((Object)"I Am Here 123");
        Assertions.assertThat((String)WordUtils.capitalizeFully((String)"alphabet")).isEqualTo((Object)"Alphabet");
    }

    @Test
    public void testCapitalizeFully_Text88() {
        Assertions.assertThat((String)WordUtils.capitalizeFully((String)"i am fine now", (char[])new char[0])).isEqualTo((Object)"I am fine now");
    }

    @Test
    public void testUnCapitalize_Text88() {
        Assertions.assertThat((String)WordUtils.uncapitalize((String)"I am fine now", (char[])new char[0])).isEqualTo((Object)"i am fine now");
    }

    @Test
    public void testCapitalizeFullyWithDelimiters_String() {
        Assertions.assertThat((String)WordUtils.capitalizeFully(null, null)).isNull();
        Assertions.assertThat((String)WordUtils.capitalizeFully((String)"", (char[])new char[0])).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.capitalizeFully((String)"  ", (char[])new char[0])).isEqualTo((Object)"  ");
        char[] chars = new char[]{'-', '+', ' ', '@'};
        Assertions.assertThat((String)WordUtils.capitalizeFully((String)"I", (char[])chars)).isEqualTo((Object)"I");
        Assertions.assertThat((String)WordUtils.capitalizeFully((String)"i", (char[])chars)).isEqualTo((Object)"I");
        Assertions.assertThat((String)WordUtils.capitalizeFully((String)"i-am here+123", (char[])chars)).isEqualTo((Object)"I-Am Here+123");
        Assertions.assertThat((String)WordUtils.capitalizeFully((String)"I Am+Here-123", (char[])chars)).isEqualTo((Object)"I Am+Here-123");
        Assertions.assertThat((String)WordUtils.capitalizeFully((String)"i+am-HERE 123", (char[])chars)).isEqualTo((Object)"I+Am-Here 123");
        Assertions.assertThat((String)WordUtils.capitalizeFully((String)"I-AM HERE+123", (char[])chars)).isEqualTo((Object)"I-Am Here+123");
        chars = new char[]{'.'};
        Assertions.assertThat((String)WordUtils.capitalizeFully((String)"i aM.fine", (char[])chars)).isEqualTo((Object)"I am.Fine");
        Assertions.assertThat((String)WordUtils.capitalizeFully((String)"i am.fine", null)).isEqualTo((Object)"I Am.fine");
        Assertions.assertThat((String)WordUtils.capitalizeFully((String)"alphabet", null)).isEqualTo((Object)"Alphabet");
        Assertions.assertThat((String)WordUtils.capitalizeFully((String)"alphabet", (char[])new char[]{'!'})).isEqualTo((Object)"Alphabet");
    }

    @Test
    public void testContainsAllWords_StringString() {
        Assertions.assertThat((boolean)WordUtils.containsAllWords(null, (CharSequence[])new CharSequence[]{null})).isFalse();
        Assertions.assertThat((boolean)WordUtils.containsAllWords(null, (CharSequence[])new CharSequence[]{""})).isFalse();
        Assertions.assertThat((boolean)WordUtils.containsAllWords(null, (CharSequence[])new CharSequence[]{"ab"})).isFalse();
        Assertions.assertThat((boolean)WordUtils.containsAllWords((CharSequence)"", (CharSequence[])new CharSequence[]{null})).isFalse();
        Assertions.assertThat((boolean)WordUtils.containsAllWords((CharSequence)"", (CharSequence[])new CharSequence[]{""})).isFalse();
        Assertions.assertThat((boolean)WordUtils.containsAllWords((CharSequence)"", (CharSequence[])new CharSequence[]{"ab"})).isFalse();
        Assertions.assertThat((boolean)WordUtils.containsAllWords((CharSequence)"foo", (CharSequence[])new CharSequence[]{null})).isFalse();
        Assertions.assertThat((boolean)WordUtils.containsAllWords((CharSequence)"bar", (CharSequence[])new CharSequence[]{""})).isFalse();
        Assertions.assertThat((boolean)WordUtils.containsAllWords((CharSequence)"zzabyycdxx", (CharSequence[])new CharSequence[]{"by"})).isFalse();
        Assertions.assertThat((boolean)WordUtils.containsAllWords((CharSequence)"lorem ipsum dolor sit amet", (CharSequence[])new CharSequence[]{"ipsum", "lorem", "dolor"})).isTrue();
        Assertions.assertThat((boolean)WordUtils.containsAllWords((CharSequence)"lorem ipsum dolor sit amet", (CharSequence[])new CharSequence[]{"ipsum", null, "lorem", "dolor"})).isFalse();
        Assertions.assertThat((boolean)WordUtils.containsAllWords((CharSequence)"lorem ipsum null dolor sit amet", (CharSequence[])new CharSequence[]{"ipsum", null, "lorem", "dolor"})).isFalse();
        Assertions.assertThat((boolean)WordUtils.containsAllWords((CharSequence)"ab", (CharSequence[])new CharSequence[]{"b"})).isFalse();
        Assertions.assertThat((boolean)WordUtils.containsAllWords((CharSequence)"ab", (CharSequence[])new CharSequence[]{"z"})).isFalse();
    }

    @Test
    public void testUncapitalize_String() {
        Assertions.assertThat((String)WordUtils.uncapitalize(null)).isNull();
        Assertions.assertThat((String)WordUtils.uncapitalize((String)"")).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.uncapitalize((String)"  ")).isEqualTo((Object)"  ");
        Assertions.assertThat((String)WordUtils.uncapitalize((String)"I")).isEqualTo((Object)"i");
        Assertions.assertThat((String)WordUtils.uncapitalize((String)"i")).isEqualTo((Object)"i");
        Assertions.assertThat((String)WordUtils.uncapitalize((String)"i am here 123")).isEqualTo((Object)"i am here 123");
        Assertions.assertThat((String)WordUtils.uncapitalize((String)"I Am Here 123")).isEqualTo((Object)"i am here 123");
        Assertions.assertThat((String)WordUtils.uncapitalize((String)"i am HERE 123")).isEqualTo((Object)"i am hERE 123");
        Assertions.assertThat((String)WordUtils.uncapitalize((String)"I AM HERE 123")).isEqualTo((Object)"i aM hERE 123");
    }

    @Test
    public void testUncapitalizeWithDelimiters_String() {
        Assertions.assertThat((String)WordUtils.uncapitalize(null, null)).isNull();
        Assertions.assertThat((String)WordUtils.uncapitalize((String)"", (char[])new char[0])).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.uncapitalize((String)"  ", (char[])new char[0])).isEqualTo((Object)"  ");
        char[] chars = new char[]{'-', '+', ' ', '@'};
        Assertions.assertThat((String)WordUtils.uncapitalize((String)"I", (char[])chars)).isEqualTo((Object)"i");
        Assertions.assertThat((String)WordUtils.uncapitalize((String)"i", (char[])chars)).isEqualTo((Object)"i");
        Assertions.assertThat((String)WordUtils.uncapitalize((String)"i am-here+123", (char[])chars)).isEqualTo((Object)"i am-here+123");
        Assertions.assertThat((String)WordUtils.uncapitalize((String)"I+Am Here-123", (char[])chars)).isEqualTo((Object)"i+am here-123");
        Assertions.assertThat((String)WordUtils.uncapitalize((String)"i-am+HERE 123", (char[])chars)).isEqualTo((Object)"i-am+hERE 123");
        Assertions.assertThat((String)WordUtils.uncapitalize((String)"I AM-HERE+123", (char[])chars)).isEqualTo((Object)"i aM-hERE+123");
        chars = new char[]{'.'};
        Assertions.assertThat((String)WordUtils.uncapitalize((String)"I AM.FINE", (char[])chars)).isEqualTo((Object)"i AM.fINE");
        Assertions.assertThat((String)WordUtils.uncapitalize((String)"I AM.FINE", null)).isEqualTo((Object)"i aM.FINE");
    }

    @Test
    public void testInitials_String() {
        Assertions.assertThat((String)WordUtils.initials(null)).isNull();
        Assertions.assertThat((String)WordUtils.initials((String)"")).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.initials((String)"  ")).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.initials((String)"I")).isEqualTo((Object)"I");
        Assertions.assertThat((String)WordUtils.initials((String)"i")).isEqualTo((Object)"i");
        Assertions.assertThat((String)WordUtils.initials((String)"Ben John Lee")).isEqualTo((Object)"BJL");
        Assertions.assertThat((String)WordUtils.initials((String)"   Ben \n   John\tLee\t")).isEqualTo((Object)"BJL");
        Assertions.assertThat((String)WordUtils.initials((String)"Ben J.Lee")).isEqualTo((Object)"BJ");
        Assertions.assertThat((String)WordUtils.initials((String)" Ben   John  . Lee")).isEqualTo((Object)"BJ.L");
        Assertions.assertThat((String)WordUtils.initials((String)"i am here 123")).isEqualTo((Object)"iah1");
    }

    @Test
    public void testInitials_String_charArray() {
        char[] array = null;
        Assertions.assertThat((String)WordUtils.initials(null, array)).isNull();
        Assertions.assertThat((String)WordUtils.initials((String)"", array)).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.initials((String)"  ", array)).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.initials((String)"I", array)).isEqualTo((Object)"I");
        Assertions.assertThat((String)WordUtils.initials((String)"i", array)).isEqualTo((Object)"i");
        Assertions.assertThat((String)WordUtils.initials((String)"SJC", array)).isEqualTo((Object)"S");
        Assertions.assertThat((String)WordUtils.initials((String)"Ben John Lee", array)).isEqualTo((Object)"BJL");
        Assertions.assertThat((String)WordUtils.initials((String)"   Ben \n   John\tLee\t", array)).isEqualTo((Object)"BJL");
        Assertions.assertThat((String)WordUtils.initials((String)"Ben J.Lee", array)).isEqualTo((Object)"BJ");
        Assertions.assertThat((String)WordUtils.initials((String)" Ben   John  . Lee", array)).isEqualTo((Object)"BJ.L");
        Assertions.assertThat((String)WordUtils.initials((String)"Kay O'Murphy", array)).isEqualTo((Object)"KO");
        Assertions.assertThat((String)WordUtils.initials((String)"i am here 123", array)).isEqualTo((Object)"iah1");
        array = new char[]{};
        Assertions.assertThat((String)WordUtils.initials(null, (char[])array)).isNull();
        Assertions.assertThat((String)WordUtils.initials((String)"", (char[])array)).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.initials((String)"  ", (char[])array)).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.initials((String)"I", (char[])array)).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.initials((String)"i", (char[])array)).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.initials((String)"SJC", (char[])array)).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.initials((String)"Ben John Lee", (char[])array)).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.initials((String)"   Ben \n   John\tLee\t", (char[])array)).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.initials((String)"Ben J.Lee", (char[])array)).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.initials((String)" Ben   John  . Lee", (char[])array)).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.initials((String)"Kay O'Murphy", (char[])array)).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.initials((String)"i am here 123", (char[])array)).isEqualTo((Object)"");
        array = " ".toCharArray();
        Assertions.assertThat((String)WordUtils.initials(null, (char[])array)).isNull();
        Assertions.assertThat((String)WordUtils.initials((String)"", (char[])array)).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.initials((String)"  ", (char[])array)).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.initials((String)"I", (char[])array)).isEqualTo((Object)"I");
        Assertions.assertThat((String)WordUtils.initials((String)"i", (char[])array)).isEqualTo((Object)"i");
        Assertions.assertThat((String)WordUtils.initials((String)"SJC", (char[])array)).isEqualTo((Object)"S");
        Assertions.assertThat((String)WordUtils.initials((String)"Ben John Lee", (char[])array)).isEqualTo((Object)"BJL");
        Assertions.assertThat((String)WordUtils.initials((String)"Ben J.Lee", (char[])array)).isEqualTo((Object)"BJ");
        Assertions.assertThat((String)WordUtils.initials((String)"   Ben \n   John\tLee\t", (char[])array)).isEqualTo((Object)"B\nJ");
        Assertions.assertThat((String)WordUtils.initials((String)" Ben   John  . Lee", (char[])array)).isEqualTo((Object)"BJ.L");
        Assertions.assertThat((String)WordUtils.initials((String)"Kay O'Murphy", (char[])array)).isEqualTo((Object)"KO");
        Assertions.assertThat((String)WordUtils.initials((String)"i am here 123", (char[])array)).isEqualTo((Object)"iah1");
        array = " .".toCharArray();
        Assertions.assertThat((String)WordUtils.initials(null, (char[])array)).isNull();
        Assertions.assertThat((String)WordUtils.initials((String)"", (char[])array)).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.initials((String)"  ", (char[])array)).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.initials((String)"I", (char[])array)).isEqualTo((Object)"I");
        Assertions.assertThat((String)WordUtils.initials((String)"i", (char[])array)).isEqualTo((Object)"i");
        Assertions.assertThat((String)WordUtils.initials((String)"SJC", (char[])array)).isEqualTo((Object)"S");
        Assertions.assertThat((String)WordUtils.initials((String)"Ben John Lee", (char[])array)).isEqualTo((Object)"BJL");
        Assertions.assertThat((String)WordUtils.initials((String)"Ben J.Lee", (char[])array)).isEqualTo((Object)"BJL");
        Assertions.assertThat((String)WordUtils.initials((String)" Ben   John  . Lee", (char[])array)).isEqualTo((Object)"BJL");
        Assertions.assertThat((String)WordUtils.initials((String)"Kay O'Murphy", (char[])array)).isEqualTo((Object)"KO");
        Assertions.assertThat((String)WordUtils.initials((String)"i am here 123", (char[])array)).isEqualTo((Object)"iah1");
        array = " .'".toCharArray();
        Assertions.assertThat((String)WordUtils.initials(null, (char[])array)).isNull();
        Assertions.assertThat((String)WordUtils.initials((String)"", (char[])array)).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.initials((String)"  ", (char[])array)).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.initials((String)"I", (char[])array)).isEqualTo((Object)"I");
        Assertions.assertThat((String)WordUtils.initials((String)"i", (char[])array)).isEqualTo((Object)"i");
        Assertions.assertThat((String)WordUtils.initials((String)"SJC", (char[])array)).isEqualTo((Object)"S");
        Assertions.assertThat((String)WordUtils.initials((String)"Ben John Lee", (char[])array)).isEqualTo((Object)"BJL");
        Assertions.assertThat((String)WordUtils.initials((String)"Ben J.Lee", (char[])array)).isEqualTo((Object)"BJL");
        Assertions.assertThat((String)WordUtils.initials((String)" Ben   John  . Lee", (char[])array)).isEqualTo((Object)"BJL");
        Assertions.assertThat((String)WordUtils.initials((String)"Kay O'Murphy", (char[])array)).isEqualTo((Object)"KOM");
        Assertions.assertThat((String)WordUtils.initials((String)"i am here 123", (char[])array)).isEqualTo((Object)"iah1");
        array = "SIJo1".toCharArray();
        Assertions.assertThat((String)WordUtils.initials(null, (char[])array)).isNull();
        Assertions.assertThat((String)WordUtils.initials((String)"", (char[])array)).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.initials((String)"  ", (char[])array)).isEqualTo((Object)" ");
        Assertions.assertThat((String)WordUtils.initials((String)"I", (char[])array)).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.initials((String)"i", (char[])array)).isEqualTo((Object)"i");
        Assertions.assertThat((String)WordUtils.initials((String)"SJC", (char[])array)).isEqualTo((Object)"C");
        Assertions.assertThat((String)WordUtils.initials((String)"Ben John Lee", (char[])array)).isEqualTo((Object)"Bh");
        Assertions.assertThat((String)WordUtils.initials((String)"Ben J.Lee", (char[])array)).isEqualTo((Object)"B.");
        Assertions.assertThat((String)WordUtils.initials((String)" Ben   John  . Lee", (char[])array)).isEqualTo((Object)" h");
        Assertions.assertThat((String)WordUtils.initials((String)"Kay O'Murphy", (char[])array)).isEqualTo((Object)"K");
        Assertions.assertThat((String)WordUtils.initials((String)"i am here 123", (char[])array)).isEqualTo((Object)"i2");
    }

    @Test
    public void testInitialsSurrogatePairs() {
        Assertions.assertThat((String)WordUtils.initials((String)"\ud800\udf00\ud800\udf01 \ud800\udf02\ud800\udf03")).isEqualTo((Object)"\ud800\udf00\ud800\udf02");
        Assertions.assertThat((String)WordUtils.initials((String)"\ud800\udf00\ud800\udf01 \ud800\udf02\ud800\udf03", null)).isEqualTo((Object)"\ud800\udf00\ud800\udf02");
        Assertions.assertThat((String)WordUtils.initials((String)"\ud800\udf00 \ud800\udf02 ", null)).isEqualTo((Object)"\ud800\udf00\ud800\udf02");
        Assertions.assertThat((String)WordUtils.initials((String)"\ud800\udf00\ud800\udf01.\ud800\udf02\ud800\udf03", (char[])new char[]{'.'})).isEqualTo((Object)"\ud800\udf00\ud800\udf02");
        Assertions.assertThat((String)WordUtils.initials((String)"\ud800\udf00\ud800\udf01A\ud800\udf02\ud800\udf03", (char[])new char[]{'A'})).isEqualTo((Object)"\ud800\udf00\ud800\udf02");
        Assertions.assertThat((String)WordUtils.initials((String)"\ud800\udf00\ud800\udf01\ud800\udf14\ud800\udf02\ud800\udf03", (char[])new char[]{'\ud800', '\udf14'})).isEqualTo((Object)"\ud800\udf00\ud800\udf02");
        Assertions.assertThat((String)WordUtils.initials((String)"\ud800\udf00\ud800\udf01\ud800\udf14\ud800\udf18\ud800\udf02\ud800\udf03", (char[])new char[]{'\ud800', '\udf14', '\ud800', '\udf18'})).isEqualTo((Object)"\ud800\udf00\ud800\udf02");
    }

    @Test
    public void testSwapCase_String() {
        Assertions.assertThat((String)WordUtils.swapCase(null)).isNull();
        Assertions.assertThat((String)WordUtils.swapCase((String)"")).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.swapCase((String)"  ")).isEqualTo((Object)"  ");
        Assertions.assertThat((String)WordUtils.swapCase((String)"I")).isEqualTo((Object)"i");
        Assertions.assertThat((String)WordUtils.swapCase((String)"i")).isEqualTo((Object)"I");
        Assertions.assertThat((String)WordUtils.swapCase((String)"i am here 123")).isEqualTo((Object)"I AM HERE 123");
        Assertions.assertThat((String)WordUtils.swapCase((String)"I Am Here 123")).isEqualTo((Object)"i aM hERE 123");
        Assertions.assertThat((String)WordUtils.swapCase((String)"i am HERE 123")).isEqualTo((Object)"I AM here 123");
        Assertions.assertThat((String)WordUtils.swapCase((String)"I AM HERE 123")).isEqualTo((Object)"i am here 123");
        String test = "This String contains a TitleCase character: \u01c8";
        String expect = "tHIS sTRING CONTAINS A tITLEcASE CHARACTER: \u01c9";
        Assertions.assertThat((String)WordUtils.swapCase((String)"This String contains a TitleCase character: \u01c8")).isEqualTo((Object)"tHIS sTRING CONTAINS A tITLEcASE CHARACTER: \u01c9");
    }

    @Test
    public void testAbbreviateForNullAndEmptyString() {
        Assertions.assertThat((String)WordUtils.abbreviate(null, (int)1, (int)-1, (String)"")).isNull();
        Assertions.assertThat((String)WordUtils.abbreviate((String)"", (int)1, (int)-1, (String)"")).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.abbreviate((String)"0123456790", (int)0, (int)0, (String)"")).isEqualTo((Object)"");
        Assertions.assertThat((String)WordUtils.abbreviate((String)" 0123456790", (int)0, (int)-1, (String)"")).isEqualTo((Object)"");
    }

    @Test
    public void testAbbreviateForUpperLimit() {
        Assertions.assertThat((String)WordUtils.abbreviate((String)"0123456789", (int)0, (int)5, (String)"")).isEqualTo((Object)"01234");
        Assertions.assertThat((String)WordUtils.abbreviate((String)"012 3456789", (int)2, (int)5, (String)"")).isEqualTo((Object)"012");
        Assertions.assertThat((String)WordUtils.abbreviate((String)"0123456789", (int)0, (int)-1, (String)"")).isEqualTo((Object)"0123456789");
    }

    @Test
    public void testAbbreviateForUpperLimitAndAppendedString() {
        Assertions.assertThat((String)WordUtils.abbreviate((String)"0123456789", (int)0, (int)5, (String)"-")).isEqualTo((Object)"01234-");
        Assertions.assertThat((String)WordUtils.abbreviate((String)"012 3456789", (int)2, (int)5, null)).isEqualTo((Object)"012");
        Assertions.assertThat((String)WordUtils.abbreviate((String)"0123456789", (int)0, (int)-1, (String)"")).isEqualTo((Object)"0123456789");
    }

    @Test
    public void testAbbreviateForLowerValue() {
        Assertions.assertThat((String)WordUtils.abbreviate((String)"012 3456789", (int)0, (int)5, null)).isEqualTo((Object)"012");
        Assertions.assertThat((String)WordUtils.abbreviate((String)"01234 56789", (int)5, (int)10, null)).isEqualTo((Object)"01234");
        Assertions.assertThat((String)WordUtils.abbreviate((String)"01 23 45 67 89", (int)9, (int)-1, null)).isEqualTo((Object)"01 23 45 67");
        Assertions.assertThat((String)WordUtils.abbreviate((String)"01 23 45 67 89", (int)9, (int)10, null)).isEqualTo((Object)"01 23 45 6");
        Assertions.assertThat((String)WordUtils.abbreviate((String)"0123456789", (int)15, (int)20, null)).isEqualTo((Object)"0123456789");
    }

    @Test
    public void testAbbreviateForLowerValueAndAppendedString() {
        Assertions.assertThat((String)WordUtils.abbreviate((String)"012 3456789", (int)0, (int)5, null)).isEqualTo((Object)"012");
        Assertions.assertThat((String)WordUtils.abbreviate((String)"01234 56789", (int)5, (int)10, (String)"-")).isEqualTo((Object)"01234-");
        Assertions.assertThat((String)WordUtils.abbreviate((String)"01 23 45 67 89", (int)9, (int)-1, (String)"abc")).isEqualTo((Object)"01 23 45 67abc");
        Assertions.assertThat((String)WordUtils.abbreviate((String)"01 23 45 67 89", (int)9, (int)10, (String)"")).isEqualTo((Object)"01 23 45 6");
    }

    @Test
    public void testAbbreviateForLowerThanMinusOneValues() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> Assertions.assertThat((String)WordUtils.abbreviate((String)"01 23 45 67 89", (int)9, (int)-10, null)).isEqualTo((Object)"01 23 45 67"));
    }

    @Test
    public void testAbbreviateUpperLessThanLowerValues() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> Assertions.assertThat((String)WordUtils.abbreviate((String)"0123456789", (int)5, (int)2, (String)"")).isEqualTo((Object)"01234"));
    }

    @Test
    public void testLANG673() {
        Assertions.assertThat((String)WordUtils.abbreviate((String)"01 23 45 67 89", (int)0, (int)40, (String)"")).isEqualTo((Object)"01");
        Assertions.assertThat((String)WordUtils.abbreviate((String)"01 23 45 67 89", (int)10, (int)40, (String)"")).isEqualTo((Object)"01 23 45 67");
        Assertions.assertThat((String)WordUtils.abbreviate((String)"01 23 45 67 89", (int)40, (int)40, (String)"")).isEqualTo((Object)"01 23 45 67 89");
    }

    @Test
    public void testLANG1292() {
        WordUtils.wrap((String)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", (int)70);
    }

    @Test
    public void testText123() throws Exception {
        WordUtils.wrap((String)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", (int)Integer.MAX_VALUE);
    }

    @Test
    public void testContainsAllWordsWithNull() {
        Assertions.assertThat((boolean)WordUtils.containsAllWords((CharSequence)"M", null)).isFalse();
    }
}

