/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.stream;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.stream.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FailableStreamTest {
    FailableStreamTest() {
    }

    private Integer failable(Map.Entry<String, AtomicInteger> value) throws IOException {
        if (value == new Object()) {
            throw new IOException();
        }
        return value.getValue().incrementAndGet();
    }

    private String failable(String value) throws IOException {
        if (value == new Object()) {
            throw new IOException();
        }
        return value.toLowerCase(Locale.ROOT);
    }

    @Test
    void testFailableStreamOfArray() {
        Assertions.assertArrayEquals((Object[])new String[0], (Object[])this.toArray(new String[0]));
        Assertions.assertArrayEquals((Object[])new String[]{"a"}, (Object[])this.toArray("A"));
        Assertions.assertArrayEquals((Object[])new String[]{"a", "b"}, (Object[])this.toArray("A", "B"));
        Assertions.assertArrayEquals((Object[])new String[]{"a", "b", "c"}, (Object[])this.toArray("A", "B", "C"));
    }

    @Test
    void testFailableStreamOfCollection() {
        Assertions.assertArrayEquals((Object[])new String[0], (Object[])this.toArray(new String[0]));
        Assertions.assertArrayEquals((Object[])new String[]{"a"}, (Object[])this.toArray(Arrays.asList("A")));
        Assertions.assertArrayEquals((Object[])new String[]{"a", "b"}, (Object[])this.toArray(Arrays.asList("A", "B")));
        Assertions.assertArrayEquals((Object[])new String[]{"a", "b", "c"}, (Object[])this.toArray(Arrays.asList("A", "B", "C")));
    }

    @Test
    void testFailableStreamOfMap() {
        LinkedHashMap<String, AtomicInteger> map = new LinkedHashMap<String, AtomicInteger>();
        Assertions.assertArrayEquals((Object[])new Integer[0], (Object[])this.toArrayMap(map));
        map.put("a", new AtomicInteger(1));
        Assertions.assertArrayEquals((Object[])new Integer[]{2}, (Object[])this.toArrayMap(map));
        map.put("b", new AtomicInteger(2));
        Assertions.assertArrayEquals((Object[])new Integer[]{3, 3}, (Object[])this.toArrayMap(map));
        map.put("c", new AtomicInteger(3));
        Assertions.assertArrayEquals((Object[])new Integer[]{4, 4, 4}, (Object[])this.toArrayMap(map));
    }

    private String[] toArray(Collection<String> strings) {
        return ((List)Streams.failableStream(strings).map(this::failable).collect(Collectors.toList())).toArray(new String[0]);
    }

    private String[] toArray(String string) {
        return ((List)Streams.failableStream((Object)string).map(this::failable).collect(Collectors.toList())).toArray(new String[0]);
    }

    private String[] toArray(String ... strings) {
        return ((List)Streams.failableStream((Object[])strings).map(this::failable).collect(Collectors.toList())).toArray(new String[0]);
    }

    private Integer[] toArrayMap(Map<String, AtomicInteger> map) {
        return ((List)Streams.failableStream(map.entrySet()).map(this::failable).collect(Collectors.toList())).toArray(new Integer[0]);
    }
}

