/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal.introspection;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jexl3.internal.introspection.MethodKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MethodKeyTest {
    private static final Class<?>[] PRIMS = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, String.class, Date.class};
    private static final Object[] ARGS = new Object[]{Boolean.TRUE, (byte)1, Character.valueOf('2'), 4.0, Float.valueOf(8.0f), 16, 32L, (short)64, "foobar", new Date()};
    private static final String[] METHODS = new String[]{"plus", "minus", "execute", "activate", "perform", "apply", "invoke", "executeAction", "activateAction", "performAction", "applyAction", "invokeAction", "executeFunctor", "activateFunctor", "performFunctor", "applyFunctor", "invokeFunctor", "executeIt", "activateIt", "performIt", "applyIt", "invokeIt"};
    private static final Map<MethodKey, String> BY_KEY = new HashMap<MethodKey, String>();
    private static final Map<String, MethodKey> BY_STRING = new HashMap<String, MethodKey>();
    private static final MethodKey[] KEY_LIST;
    private static final int LOOP = 3;

    private static void setUpKey(String name, Class<?>[] parms) {
        MethodKey key = new MethodKey(name, (Class[])parms);
        String str = key.toString();
        BY_KEY.put(key, str);
        BY_STRING.put(str, key);
    }

    void checkKey(String method, Class<?> ... params) {
        MethodKey key = this.makeKey(method, params);
        String out = BY_KEY.get(key);
        Assertions.assertNotNull((Object)out);
    }

    void checkStringKey(String method, Class<?> ... params) {
        String key = this.makeStringKey(method, params);
        MethodKey out = BY_STRING.get(key);
        Assertions.assertNotNull((Object)out);
    }

    MethodKey makeKey(String method, Class<?> ... params) {
        return new MethodKey(method, (Class[])params);
    }

    String makeStringKey(String method, Class<?> ... params) {
        StringBuilder builder = new StringBuilder(method);
        for (Class<?> param : params) {
            builder.append(MethodKey.primitiveClass(param).getName());
        }
        return builder.toString();
    }

    @Test
    public void testDebugString() throws Exception {
        MethodKey c = KEY_LIST[0];
        String str = c.debugString();
        Assertions.assertNotNull((Object)str);
    }

    @Test
    public void testObjectKey() throws Exception {
        for (MethodKey ctl : KEY_LIST) {
            MethodKey key = this.makeKey(ctl.getMethod(), ctl.getParameters());
            String out = BY_KEY.get(key);
            Assertions.assertNotNull((Object)out);
            Assertions.assertEquals((Object)ctl.toString(), (Object)out, () -> ctl.toString() + " != " + out);
        }
    }

    @Test
    public void testPerfKey() throws Exception {
        for (int l = 0; l < 3; ++l) {
            for (MethodKey ctl : KEY_LIST) {
                MethodKey key = this.makeKey(ctl.getMethod(), ctl.getParameters());
                String out = BY_KEY.get(key);
                Assertions.assertNotNull((Object)out);
            }
        }
    }

    @Test
    public void testPerfKey2() throws Exception {
        for (int l = 0; l < 3; ++l) {
            for (String method : METHODS) {
                for (Object value : ARGS) {
                    this.checkKey(method, value.getClass());
                    for (Object o : ARGS) {
                        this.checkKey(method, value.getClass(), o.getClass());
                        for (Object arg : ARGS) {
                            this.checkKey(method, value.getClass(), o.getClass(), arg.getClass());
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testPerfString() throws Exception {
        for (int l = 0; l < 3; ++l) {
            for (MethodKey ctl : KEY_LIST) {
                String key = this.makeStringKey(ctl.getMethod(), ctl.getParameters());
                MethodKey out = BY_STRING.get(key);
                Assertions.assertNotNull((Object)out);
            }
        }
    }

    @Test
    public void testPerfStringKey2() throws Exception {
        for (int l = 0; l < 3; ++l) {
            for (String method : METHODS) {
                for (Object value : ARGS) {
                    this.checkStringKey(method, value.getClass());
                    for (Object o : ARGS) {
                        this.checkStringKey(method, value.getClass(), o.getClass());
                        for (Object arg : ARGS) {
                            this.checkStringKey(method, value.getClass(), o.getClass(), arg.getClass());
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testStringKey() throws Exception {
        for (MethodKey ctl : KEY_LIST) {
            String key = this.makeStringKey(ctl.getMethod(), ctl.getParameters());
            MethodKey out = BY_STRING.get(key);
            Assertions.assertNotNull((Object)out);
            Assertions.assertEquals((Object)ctl, (Object)out, (String)(ctl.toString() + " != " + key));
        }
    }

    static {
        for (String method : METHODS) {
            for (Class<?> value : PRIMS) {
                Class[] arg0 = new Class[]{value};
                MethodKeyTest.setUpKey(method, arg0);
                for (Class<?> aClass : PRIMS) {
                    Class[] arg1 = new Class[]{value, aClass};
                    MethodKeyTest.setUpKey(method, arg1);
                    for (Class<?> prim : PRIMS) {
                        Class[] arg2 = new Class[]{value, aClass, prim};
                        MethodKeyTest.setUpKey(method, arg2);
                    }
                }
            }
        }
        KEY_LIST = BY_KEY.keySet().toArray(new MethodKey[0]);
    }
}

