/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.file.PathFilter;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.PathVisitor;
import org.apache.commons.io.file.TempFile;
import org.apache.commons.io.filefilter.AbstractFilterTest;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.CanExecuteFileFilter;
import org.apache.commons.io.filefilter.CanReadFileFilter;
import org.apache.commons.io.filefilter.CanWriteFileFilter;
import org.apache.commons.io.filefilter.DelegateFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.EmptyFileFilter;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.FileEqualsFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.MagicNumberFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.PathEqualsFileFilter;
import org.apache.commons.io.filefilter.PathVisitorFileFilter;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFilter;
import org.apache.commons.io.test.TestUtils;
import org.apache.commons.lang3.SystemUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

class FileFilterTest
extends AbstractFilterTest {
    FileFilterTest() {
    }

    @Test
    void testAgeFilter() throws Exception {
        File oldFile = new File(this.temporaryFolder, "old.txt");
        Path oldPath = oldFile.toPath();
        File reference = new File(this.temporaryFolder, "reference.txt");
        File newFile = new File(this.temporaryFolder, "new.txt");
        Path newPath = newFile.toPath();
        if (!oldFile.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + oldFile + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output1 = new BufferedOutputStream(Files.newOutputStream(oldFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output1, 0L);
        }
        do {
            try {
                TestUtils.sleep(1000L);
            }
            catch (InterruptedException output1) {
                // empty catch block
            }
            if (!reference.getParentFile().exists()) {
                Assertions.fail((String)("Cannot create file " + reference + " as the parent directory does not exist"));
            }
            try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(reference.toPath(), new OpenOption[0]));){
                TestUtils.generateTestData(output, 0L);
            }
        } while (this.equalsLastModified(oldFile, reference));
        Date date = new Date();
        long now = date.getTime();
        do {
            try {
                TestUtils.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!newFile.getParentFile().exists()) {
                Assertions.fail((String)("Cannot create file " + newFile + " as the parent directory does not exist"));
            }
            try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(newFile.toPath(), new OpenOption[0]));){
                TestUtils.generateTestData(output, 0L);
            }
        } while (this.equalsLastModified(reference, newFile));
        IOFileFilter filter1 = FileFilterUtils.ageFileFilter((long)now);
        IOFileFilter filter2 = FileFilterUtils.ageFileFilter((long)now, (boolean)true);
        IOFileFilter filter3 = FileFilterUtils.ageFileFilter((long)now, (boolean)false);
        IOFileFilter filter4 = FileFilterUtils.ageFileFilter((Date)date);
        IOFileFilter filter5 = FileFilterUtils.ageFileFilter((Date)date, (boolean)true);
        IOFileFilter filter6 = FileFilterUtils.ageFileFilter((Date)date, (boolean)false);
        IOFileFilter filter7 = FileFilterUtils.ageFileFilter((File)reference);
        IOFileFilter filter8 = FileFilterUtils.ageFileFilter((File)reference, (boolean)true);
        IOFileFilter filter9 = FileFilterUtils.ageFileFilter((File)reference, (boolean)false);
        this.assertFiltering(filter1, oldFile, true);
        this.assertFiltering(filter2, oldFile, true);
        this.assertFiltering(filter3, oldFile, false);
        this.assertFiltering(filter4, oldFile, true);
        this.assertFiltering(filter5, oldFile, true);
        this.assertFiltering(filter6, oldFile, false);
        this.assertFiltering(filter7, oldFile, true);
        this.assertFiltering(filter8, oldFile, true);
        this.assertFiltering(filter9, oldFile, false);
        this.assertFiltering(filter1, newFile, false);
        this.assertFiltering(filter2, newFile, false);
        this.assertFiltering(filter3, newFile, true);
        this.assertFiltering(filter4, newFile, false);
        this.assertFiltering(filter5, newFile, false);
        this.assertFiltering(filter6, newFile, true);
        this.assertFiltering(filter7, newFile, false);
        this.assertFiltering(filter8, newFile, false);
        this.assertFiltering(filter9, newFile, true);
        this.assertFiltering(filter1, oldPath, true);
        this.assertFiltering(filter2, oldPath, true);
        this.assertFiltering(filter3, oldPath, false);
        this.assertFiltering(filter4, oldPath, true);
        this.assertFiltering(filter5, oldPath, true);
        this.assertFiltering(filter6, oldPath, false);
        this.assertFiltering(filter7, oldPath, true);
        this.assertFiltering(filter8, oldPath, true);
        this.assertFiltering(filter9, oldPath, false);
        this.assertFiltering(filter1, newPath, false);
        this.assertFiltering(filter2, newPath, false);
        this.assertFiltering(filter3, newPath, true);
        this.assertFiltering(filter4, newPath, false);
        this.assertFiltering(filter5, newPath, false);
        this.assertFiltering(filter6, newPath, true);
        this.assertFiltering(filter7, newPath, false);
        this.assertFiltering(filter8, newPath, false);
        this.assertFiltering(filter9, newPath, true);
    }

    @Test
    void testAnd() throws IOException {
        IOFileFilter trueFilter = TrueFileFilter.INSTANCE;
        IOFileFilter falseFilter = FalseFileFilter.INSTANCE;
        this.assertFiltering(trueFilter.and(trueFilter), new File("foo.test"), true);
        this.assertFiltering(trueFilter.and(falseFilter), new File("foo.test"), false);
        this.assertFiltering(falseFilter.and(trueFilter), new File("foo.test"), false);
        this.assertFiltering(falseFilter.and(falseFilter), new File("foo.test"), false);
    }

    @Test
    void testAnd2() throws IOException {
        IOFileFilter trueFilter = TrueFileFilter.INSTANCE;
        IOFileFilter falseFilter = FalseFileFilter.INSTANCE;
        this.assertFiltering((IOFileFilter)new AndFileFilter(trueFilter, trueFilter), new File("foo.test"), true);
        this.assertFiltering((IOFileFilter)new AndFileFilter(trueFilter, falseFilter), new File("foo.test"), false);
        this.assertFiltering((IOFileFilter)new AndFileFilter(falseFilter, trueFilter), new File("foo.test"), false);
        this.assertFiltering((IOFileFilter)new AndFileFilter(falseFilter, falseFilter), new File("foo.test"), false);
        ArrayList filters = new ArrayList();
        this.assertFiltering((IOFileFilter)new AndFileFilter(filters), new File("test"), false);
        this.assertFiltering((IOFileFilter)new AndFileFilter(), new File("test"), false);
        Assertions.assertThrows(NullPointerException.class, () -> new AndFileFilter(falseFilter, null));
        Assertions.assertThrows(NullPointerException.class, () -> new AndFileFilter(null, falseFilter));
        Assertions.assertThrows(NullPointerException.class, () -> new AndFileFilter((List)null));
    }

    @Test
    void testAndArray() throws IOException {
        IOFileFilter trueFilter = TrueFileFilter.INSTANCE;
        IOFileFilter falseFilter = FalseFileFilter.INSTANCE;
        this.assertFiltering((IOFileFilter)new AndFileFilter(new IOFileFilter[]{trueFilter, trueFilter, trueFilter}), new File("foo.test"), true);
        this.assertFiltering((IOFileFilter)new AndFileFilter(new IOFileFilter[]{trueFilter, falseFilter, falseFilter}), new File("foo.test"), false);
        this.assertFiltering((IOFileFilter)new AndFileFilter(new IOFileFilter[]{falseFilter, trueFilter, trueFilter}), new File("foo.test"), false);
        this.assertFiltering((IOFileFilter)new AndFileFilter(new IOFileFilter[]{falseFilter, falseFilter, falseFilter}), new File("foo.test"), false);
        ArrayList filters = new ArrayList();
        this.assertFiltering((IOFileFilter)new AndFileFilter(filters), new File("test"), false);
        this.assertFiltering((IOFileFilter)new AndFileFilter(), new File("test"), false);
    }

    @Test
    void testCanExecute() throws Exception {
        Assumptions.assumeTrue((boolean)SystemUtils.IS_OS_WINDOWS);
        try (TempFile executablePath = TempFile.create(this.getClass().getSimpleName(), null, new FileAttribute[0]);){
            File executableFile = executablePath.toFile();
            try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(executablePath.get(), new OpenOption[0]));){
                TestUtils.generateTestData(output, 32L);
            }
            Assertions.assertTrue((boolean)executableFile.setExecutable(true));
            this.assertFiltering(CanExecuteFileFilter.CAN_EXECUTE, executablePath.get(), true);
            this.assertFiltering(CanExecuteFileFilter.CAN_EXECUTE, (Path)null, false);
            this.assertFiltering(CanExecuteFileFilter.CAN_EXECUTE, executableFile, true);
            this.assertFiltering(CanExecuteFileFilter.CAN_EXECUTE, (File)null, false);
            executableFile.setExecutable(false);
            this.assertFiltering(CanExecuteFileFilter.CANNOT_EXECUTE, executablePath.get(), false);
            this.assertFiltering(CanExecuteFileFilter.CANNOT_EXECUTE, (Path)null, true);
            this.assertFiltering(CanExecuteFileFilter.CANNOT_EXECUTE, executableFile, false);
            this.assertFiltering(CanExecuteFileFilter.CANNOT_EXECUTE, (File)null, true);
        }
    }

    @Test
    void testCanRead() throws Exception {
        File readOnlyFile = new File(this.temporaryFolder, "read-only-file1.txt");
        Path readOnlyPath = readOnlyFile.toPath();
        if (!readOnlyFile.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + readOnlyFile + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(readOnlyFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 32L);
        }
        Assertions.assertTrue((boolean)readOnlyFile.setReadOnly());
        this.assertFiltering(CanReadFileFilter.CAN_READ, readOnlyFile, true);
        this.assertFiltering(CanReadFileFilter.CAN_READ, (File)null, false);
        this.assertFiltering(CanReadFileFilter.CAN_READ, readOnlyPath, true);
        this.assertFiltering(CanReadFileFilter.CAN_READ, (Path)null, false);
        this.assertFiltering(CanReadFileFilter.CANNOT_READ, readOnlyFile, false);
        this.assertFiltering(CanReadFileFilter.CANNOT_READ, (File)null, true);
        this.assertFiltering(CanReadFileFilter.CANNOT_READ, readOnlyPath, false);
        this.assertFiltering(CanReadFileFilter.CANNOT_READ, (Path)null, true);
        this.assertFiltering(CanReadFileFilter.READ_ONLY, readOnlyFile, true);
        this.assertFiltering(CanReadFileFilter.READ_ONLY, (File)null, false);
        this.assertFiltering(CanReadFileFilter.READ_ONLY, readOnlyPath, true);
        this.assertFiltering(CanReadFileFilter.READ_ONLY, (Path)null, false);
        readOnlyFile.delete();
    }

    @Test
    void testCanWrite() throws Exception {
        File readOnlyFile = new File(this.temporaryFolder, "read-only-file2.txt");
        Path readOnlyPath = readOnlyFile.toPath();
        if (!readOnlyFile.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + readOnlyFile + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(readOnlyFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 32L);
        }
        Assertions.assertTrue((boolean)readOnlyFile.setReadOnly());
        this.assertFiltering(CanWriteFileFilter.CAN_WRITE, this.temporaryFolder, true);
        this.assertFiltering(CanWriteFileFilter.CAN_WRITE, readOnlyFile, false);
        this.assertFiltering(CanWriteFileFilter.CAN_WRITE, (File)null, false);
        this.assertFiltering(CanWriteFileFilter.CAN_WRITE, readOnlyPath, false);
        this.assertFiltering(CanWriteFileFilter.CAN_WRITE, (Path)null, false);
        this.assertFiltering(CanWriteFileFilter.CANNOT_WRITE, this.temporaryFolder, false);
        this.assertFiltering(CanWriteFileFilter.CANNOT_WRITE, readOnlyFile, true);
        this.assertFiltering(CanWriteFileFilter.CANNOT_WRITE, readOnlyPath, true);
        this.assertFiltering(CanWriteFileFilter.CANNOT_WRITE, (File)null, true);
        this.assertFiltering(CanWriteFileFilter.CANNOT_WRITE, (Path)null, true);
        readOnlyFile.delete();
    }

    @Test
    void testDelegateFileFilter() throws IOException {
        OrFileFilter orFilter = new OrFileFilter();
        File testFile = new File("test.txt");
        DelegateFileFilter filter = new DelegateFileFilter((FileFilter)orFilter);
        this.assertFiltering((IOFileFilter)filter, testFile, false);
        Assertions.assertNotNull((Object)filter.toString());
        filter = new DelegateFileFilter((FilenameFilter)orFilter);
        this.assertFiltering((IOFileFilter)filter, testFile, false);
        Assertions.assertNotNull((Object)filter.toString());
        Assertions.assertThrows(NullPointerException.class, () -> new DelegateFileFilter((FileFilter)null));
        Assertions.assertThrows(NullPointerException.class, () -> new DelegateFileFilter((FilenameFilter)null));
    }

    @Test
    void testDelegation() {
        Assertions.assertNotNull((Object)FileFilterUtils.asFileFilter((FileFilter)FalseFileFilter.INSTANCE));
        Assertions.assertNotNull((Object)FileFilterUtils.asFileFilter((FilenameFilter)FalseFileFilter.INSTANCE).toString());
    }

    @Test
    void testDeprecatedWildcard() throws IOException {
        WildcardFilter filter = new WildcardFilter("*.txt");
        List<String> patternList = Arrays.asList("*.txt", "*.xml", "*.gif");
        WildcardFilter listFilter = new WildcardFilter(patternList);
        File txtFile = new File("test.txt");
        Path txtPath = txtFile.toPath();
        File bmpFile = new File("test.bmp");
        Path bmpPath = bmpFile.toPath();
        File dirFile = new File("src/java");
        Path dirPath = dirFile.toPath();
        this.assertFiltering((IOFileFilter)filter, new File("log.txt"), true);
        this.assertFiltering((IOFileFilter)filter, new File("log.txt").toPath(), true);
        filter = new WildcardFilter("log?.txt");
        this.assertFiltering((IOFileFilter)filter, new File("log1.txt"), true);
        this.assertFiltering((IOFileFilter)filter, new File("log12.txt"), false);
        this.assertFiltering((IOFileFilter)filter, new File("log1.txt").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("log12.txt").toPath(), false);
        filter = new WildcardFilter("open??.????04");
        this.assertFiltering((IOFileFilter)filter, new File("openAB.102504"), true);
        this.assertFiltering((IOFileFilter)filter, new File("openA.102504"), false);
        this.assertFiltering((IOFileFilter)filter, new File("openXY.123103"), false);
        this.assertFiltering((IOFileFilter)filter, new File("openAB.102504").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("openA.102504").toPath(), false);
        this.assertFiltering((IOFileFilter)filter, new File("openXY.123103").toPath(), false);
        filter = new WildcardFilter(new String[]{"*.java", "*.class"});
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.class"), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.jsp"), false);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.class").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.jsp").toPath(), false);
        this.assertFiltering((IOFileFilter)listFilter, new File("Test.txt"), true);
        this.assertFiltering((IOFileFilter)listFilter, new File("Test.xml"), true);
        this.assertFiltering((IOFileFilter)listFilter, new File("Test.gif"), true);
        this.assertFiltering((IOFileFilter)listFilter, new File("Test.bmp"), false);
        this.assertFiltering((IOFileFilter)listFilter, new File("Test.txt").toPath(), true);
        this.assertFiltering((IOFileFilter)listFilter, new File("Test.xml").toPath(), true);
        this.assertFiltering((IOFileFilter)listFilter, new File("Test.gif").toPath(), true);
        this.assertFiltering((IOFileFilter)listFilter, new File("Test.bmp").toPath(), false);
        Assertions.assertTrue((boolean)listFilter.accept(txtFile));
        Assertions.assertFalse((boolean)listFilter.accept(bmpFile));
        Assertions.assertFalse((boolean)listFilter.accept(dirFile));
        Assertions.assertTrue((boolean)listFilter.matches(txtPath));
        Assertions.assertFalse((boolean)listFilter.matches(bmpPath));
        Assertions.assertFalse((boolean)listFilter.matches(dirPath));
        Assertions.assertEquals((Object)((Object)FileVisitResult.CONTINUE), (Object)((Object)listFilter.accept(txtPath, null)));
        Assertions.assertEquals((Object)((Object)FileVisitResult.TERMINATE), (Object)((Object)listFilter.accept(bmpPath, null)));
        Assertions.assertEquals((Object)((Object)FileVisitResult.TERMINATE), (Object)((Object)listFilter.accept(dirPath, null)));
        Assertions.assertTrue((boolean)listFilter.accept(txtFile.getParentFile(), txtFile.getName()));
        Assertions.assertFalse((boolean)listFilter.accept(bmpFile.getParentFile(), bmpFile.getName()));
        Assertions.assertFalse((boolean)listFilter.accept(dirFile.getParentFile(), dirFile.getName()));
        Assertions.assertEquals((Object)((Object)FileVisitResult.CONTINUE), (Object)((Object)listFilter.accept(txtPath, null)));
        Assertions.assertEquals((Object)((Object)FileVisitResult.TERMINATE), (Object)((Object)listFilter.accept(bmpPath, null)));
        Assertions.assertEquals((Object)((Object)FileVisitResult.TERMINATE), (Object)((Object)listFilter.accept(dirPath, null)));
        Assertions.assertThrows(NullPointerException.class, () -> new WildcardFilter((String)null));
        Assertions.assertThrows(NullPointerException.class, () -> new WildcardFilter((String[])null));
        Assertions.assertThrows(NullPointerException.class, () -> new WildcardFilter((List)null));
    }

    @Test
    void testDirectory() throws IOException {
        DirectoryFileFilter filter = new DirectoryFileFilter();
        this.assertFiltering((IOFileFilter)filter, new File("src/"), true);
        this.assertFiltering((IOFileFilter)filter, new File("src/").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("src/main/java/"), true);
        this.assertFiltering((IOFileFilter)filter, new File("src/main/java/").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("pom.xml"), false);
        this.assertFiltering((IOFileFilter)filter, new File("pom.xml").toPath(), false);
        this.assertFiltering((IOFileFilter)filter, new File("imaginary"), false);
        this.assertFiltering((IOFileFilter)filter, new File("imaginary").toPath(), false);
        this.assertFiltering((IOFileFilter)filter, new File("imaginary/"), false);
        this.assertFiltering((IOFileFilter)filter, new File("imaginary/").toPath(), false);
        this.assertFiltering((IOFileFilter)filter, new File("LICENSE.txt"), false);
        this.assertFiltering((IOFileFilter)filter, new File("LICENSE.txt").toPath(), false);
        this.assertFiltering((IOFileFilter)filter, (File)null, false);
        this.assertFiltering((IOFileFilter)filter, (Path)null, false);
        Assertions.assertSame((Object)DirectoryFileFilter.DIRECTORY, (Object)DirectoryFileFilter.INSTANCE);
    }

    @Test
    void testEmpty() throws Exception {
        File emptyDirFile = new File(this.temporaryFolder, "empty-dir");
        Path emptyDirPath = emptyDirFile.toPath();
        emptyDirFile.mkdirs();
        this.assertFiltering(EmptyFileFilter.EMPTY, emptyDirFile, true);
        this.assertFiltering(EmptyFileFilter.EMPTY, emptyDirPath, true);
        this.assertFiltering(EmptyFileFilter.EMPTY, (File)null, true);
        this.assertFiltering(EmptyFileFilter.EMPTY, (Path)null, true);
        this.assertFiltering(EmptyFileFilter.NOT_EMPTY, emptyDirFile, false);
        this.assertFiltering(EmptyFileFilter.NOT_EMPTY, emptyDirPath, false);
        this.assertFiltering(EmptyFileFilter.NOT_EMPTY, (File)null, false);
        this.assertFiltering(EmptyFileFilter.NOT_EMPTY, (Path)null, false);
        File emptyFile = new File(emptyDirFile, "empty-file.txt");
        Path emptyPath = emptyFile.toPath();
        if (!emptyFile.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + emptyFile + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output1 = new BufferedOutputStream(Files.newOutputStream(emptyFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output1, 0L);
        }
        this.assertFiltering(EmptyFileFilter.EMPTY, emptyFile, true);
        this.assertFiltering(EmptyFileFilter.EMPTY, emptyPath, true);
        this.assertFiltering(EmptyFileFilter.NOT_EMPTY, emptyFile, false);
        this.assertFiltering(EmptyFileFilter.NOT_EMPTY, emptyPath, false);
        this.assertFiltering(EmptyFileFilter.EMPTY, emptyDirFile, false);
        this.assertFiltering(EmptyFileFilter.EMPTY, emptyDirPath, false);
        this.assertFiltering(EmptyFileFilter.NOT_EMPTY, emptyDirFile, true);
        this.assertFiltering(EmptyFileFilter.NOT_EMPTY, emptyDirPath, true);
        File notEmptyFile = new File(emptyDirFile, "not-empty-file.txt");
        Path notEmptyPath = notEmptyFile.toPath();
        if (!notEmptyFile.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + notEmptyFile + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(notEmptyFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 32L);
        }
        this.assertFiltering(EmptyFileFilter.EMPTY, notEmptyFile, false);
        this.assertFiltering(EmptyFileFilter.EMPTY, notEmptyPath, false);
        this.assertFiltering(EmptyFileFilter.NOT_EMPTY, notEmptyFile, true);
        this.assertFiltering(EmptyFileFilter.NOT_EMPTY, notEmptyPath, true);
        FileUtils.forceDelete((File)emptyDirFile);
    }

    @Test
    void testEnsureTestCoverage() {
        Assertions.assertNotNull((Object)new FileFilterUtils());
    }

    @Test
    void testFalse() throws IOException {
        IOFileFilter filter = FileFilterUtils.falseFileFilter();
        this.assertFiltering(filter, new File("foo.test"), false);
        this.assertFiltering(filter, new File("foo.test").toPath(), false);
        this.assertFiltering(filter, new File("foo"), false);
        this.assertFiltering(filter, new File("foo").toPath(), false);
        this.assertFiltering(filter, (File)null, false);
        this.assertFiltering(filter, (Path)null, false);
        Assertions.assertSame((Object)FalseFileFilter.FALSE, (Object)FalseFileFilter.INSTANCE);
        Assertions.assertSame((Object)TrueFileFilter.TRUE, (Object)FalseFileFilter.INSTANCE.negate());
        Assertions.assertSame((Object)TrueFileFilter.INSTANCE, (Object)FalseFileFilter.INSTANCE.negate());
        Assertions.assertNotNull((Object)FalseFileFilter.INSTANCE.toString());
    }

    @Test
    void testFileEqualsFilter() throws IOException {
        this.assertFooBarFileFiltering(new FileEqualsFileFilter(new File("foo")).or((IOFileFilter)new FileEqualsFileFilter(new File("bar"))));
    }

    @Test
    void testFileFilterUtils_and() throws IOException {
        IOFileFilter trueFilter = TrueFileFilter.INSTANCE;
        IOFileFilter falseFilter = FalseFileFilter.INSTANCE;
        this.assertFiltering(FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{trueFilter, trueFilter, trueFilter}), new File("foo.test"), true);
        this.assertFiltering(FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{trueFilter, falseFilter, trueFilter}), new File("foo.test"), false);
        this.assertFiltering(FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{falseFilter, trueFilter}), new File("foo.test"), false);
        this.assertFiltering(FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{falseFilter, falseFilter}), new File("foo.test"), false);
    }

    @Test
    void testFileFilterUtils_or() throws IOException {
        IOFileFilter trueFilter = TrueFileFilter.INSTANCE;
        IOFileFilter falseFilter = FalseFileFilter.INSTANCE;
        File testFile = new File("foo.test");
        this.assertFiltering(FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{trueFilter, trueFilter}), testFile, true);
        this.assertFiltering(FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{trueFilter, trueFilter, falseFilter}), testFile, true);
        this.assertFiltering(FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{falseFilter, trueFilter}), testFile, true);
        this.assertFiltering(FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{falseFilter, falseFilter, falseFilter}), testFile, false);
    }

    @Test
    void testFiles() throws IOException {
        IOFileFilter filter = FileFileFilter.INSTANCE;
        this.assertFiltering(filter, (File)null, false);
        this.assertFiltering(filter, new File("src/"), false);
        this.assertFiltering(filter, new File("src/").toPath(), false);
        this.assertFiltering(filter, new File("src/java/"), false);
        this.assertFiltering(filter, new File("src/java/").toPath(), false);
        this.assertFiltering(filter, new File("pom.xml"), true);
        this.assertFiltering(filter, new File("pom.xml").toPath(), true);
        this.assertFiltering(filter, new File("imaginary"), false);
        this.assertFiltering(filter, new File("imaginary").toPath(), false);
        this.assertFiltering(filter, new File("imaginary/"), false);
        this.assertFiltering(filter, new File("imaginary/").toPath(), false);
        this.assertFiltering(filter, new File("LICENSE.txt"), true);
        this.assertFiltering(filter, new File("LICENSE.txt").toPath(), true);
    }

    @Test
    void testFilterArray_fromList() throws Exception {
        File fileA = TestUtils.newFile(this.temporaryFolder, "A");
        File fileB = TestUtils.newFile(this.temporaryFolder, "B");
        List<File> fileList = Arrays.asList(fileA, fileB);
        IOFileFilter filter = FileFilterUtils.nameFileFilter((String)"A");
        File[] filtered = FileFilterUtils.filter((IOFileFilter)filter, fileList);
        Assertions.assertEquals((int)1, (int)filtered.length);
        Assertions.assertEquals((Object)fileA, (Object)filtered[0]);
    }

    @Test
    void testFilterArray_IOFileFilter() throws Exception {
        File fileA = TestUtils.newFile(this.temporaryFolder, "A");
        File fileB = TestUtils.newFile(this.temporaryFolder, "B");
        IOFileFilter filter = FileFilterUtils.nameFileFilter((String)"A");
        File[] filtered = FileFilterUtils.filter((IOFileFilter)filter, (File[])new File[]{fileA, fileB});
        Assertions.assertEquals((int)1, (int)filtered.length);
        Assertions.assertEquals((Object)fileA, (Object)filtered[0]);
    }

    @Test
    void testFilterArray_PathVisitorFileFilter_FileExistsNo() throws Exception {
        File fileA = TestUtils.newFile(this.temporaryFolder, "A");
        File fileB = TestUtils.newFile(this.temporaryFolder, "B");
        PathVisitorFileFilter filter = new PathVisitorFileFilter((PathVisitor)new NameFileFilter("A"));
        File[] filtered = FileFilterUtils.filter((IOFileFilter)filter, (File[])new File[]{fileA, fileB});
        Assertions.assertEquals((int)1, (int)filtered.length);
        Assertions.assertEquals((Object)fileA, (Object)filtered[0]);
    }

    @Test
    void testFilterArray_PathVisitorFileFilter_FileExistsYes() throws Exception {
        File fileA = TestUtils.newFile(this.temporaryFolder, "A");
        File fileB = TestUtils.newFile(this.temporaryFolder, "B");
        FileUtils.write((File)fileA, (CharSequence)"test", (Charset)StandardCharsets.US_ASCII);
        PathVisitorFileFilter filter = new PathVisitorFileFilter((PathVisitor)new NameFileFilter("A"));
        File[] filtered = FileFilterUtils.filter((IOFileFilter)filter, (File[])new File[]{fileA, fileB});
        Assertions.assertEquals((int)1, (int)filtered.length);
        Assertions.assertEquals((Object)fileA, (Object)filtered[0]);
    }

    @Test
    void testFilterFilesArrayNullParameters() throws Exception {
        File fileA = TestUtils.newFile(this.temporaryFolder, "A");
        File fileB = TestUtils.newFile(this.temporaryFolder, "B");
        Assertions.assertThrows(NullPointerException.class, () -> FileFilterUtils.filter(null, (File[])new File[]{fileA, fileB}));
        IOFileFilter filter = FileFilterUtils.trueFileFilter();
        FileFilterUtils.filter((IOFileFilter)filter, (File[])new File[]{fileA, null});
        File[] filtered = FileFilterUtils.filter((IOFileFilter)filter, (File[])null);
        Assertions.assertEquals((int)0, (int)filtered.length);
    }

    @Test
    void testFilterList() throws Exception {
        File fileA = TestUtils.newFile(this.temporaryFolder, "A");
        File fileB = TestUtils.newFile(this.temporaryFolder, "B");
        List<File> fileList = Arrays.asList(fileA, fileB);
        IOFileFilter filter = FileFilterUtils.nameFileFilter((String)"A");
        List filteredList = FileFilterUtils.filterList((IOFileFilter)filter, fileList);
        Assertions.assertTrue((boolean)filteredList.contains(fileA));
        Assertions.assertFalse((boolean)filteredList.contains(fileB));
    }

    @Test
    void testFilterList_fromArray() throws Exception {
        File fileA = TestUtils.newFile(this.temporaryFolder, "A");
        File fileB = TestUtils.newFile(this.temporaryFolder, "B");
        IOFileFilter filter = FileFilterUtils.nameFileFilter((String)"A");
        List filteredList = FileFilterUtils.filterList((IOFileFilter)filter, (File[])new File[]{fileA, fileB});
        Assertions.assertTrue((boolean)filteredList.contains(fileA));
        Assertions.assertFalse((boolean)filteredList.contains(fileB));
    }

    @Test
    void testFilterListNullParameters() {
        Assertions.assertThrows(NullPointerException.class, () -> FileFilterUtils.filterList(null, Collections.emptyList()));
        IOFileFilter filter = FileFilterUtils.trueFileFilter();
        List filteredList = FileFilterUtils.filterList((IOFileFilter)filter, Collections.singletonList(null));
        Assertions.assertEquals((int)1, (int)filteredList.size());
        Assertions.assertNull(filteredList.get(0));
        filteredList = FileFilterUtils.filterList((IOFileFilter)filter, (Iterable)null);
        Assertions.assertEquals((int)0, (int)filteredList.size());
    }

    @Test
    void testFilterPathsArrayNullParameters() throws Exception {
        Path fileA = TestUtils.newFile(this.temporaryFolder, "A").toPath();
        Path fileB = TestUtils.newFile(this.temporaryFolder, "B").toPath();
        Assertions.assertThrows(NullPointerException.class, () -> PathUtils.filter(null, (Path[])new Path[]{fileA, fileB}));
        IOFileFilter filter = FileFilterUtils.trueFileFilter();
        PathUtils.filter((PathFilter)filter, (Path[])new Path[]{fileA, null});
        File[] filtered = FileFilterUtils.filter((IOFileFilter)filter, (File[])null);
        Assertions.assertEquals((int)0, (int)filtered.length);
    }

    @Test
    void testFilterSet() throws Exception {
        File fileA = TestUtils.newFile(this.temporaryFolder, "A");
        File fileB = TestUtils.newFile(this.temporaryFolder, "B");
        HashSet<File> fileList = new HashSet<File>(Arrays.asList(fileA, fileB));
        IOFileFilter filter = FileFilterUtils.nameFileFilter((String)"A");
        Set filteredSet = FileFilterUtils.filterSet((IOFileFilter)filter, fileList);
        Assertions.assertTrue((boolean)filteredSet.contains(fileA));
        Assertions.assertFalse((boolean)filteredSet.contains(fileB));
    }

    @Test
    void testFilterSet_fromArray() throws Exception {
        File fileA = TestUtils.newFile(this.temporaryFolder, "A");
        File fileB = TestUtils.newFile(this.temporaryFolder, "B");
        IOFileFilter filter = FileFilterUtils.nameFileFilter((String)"A");
        Set filteredSet = FileFilterUtils.filterSet((IOFileFilter)filter, (File[])new File[]{fileA, fileB});
        Assertions.assertTrue((boolean)filteredSet.contains(fileA));
        Assertions.assertFalse((boolean)filteredSet.contains(fileB));
    }

    @Test
    void testFilterSetNullParameters() {
        Assertions.assertThrows(NullPointerException.class, () -> FileFilterUtils.filterSet(null, Collections.emptySet()));
        IOFileFilter filter = FileFilterUtils.trueFileFilter();
        FileFilterUtils.filterSet((IOFileFilter)filter, new HashSet<Object>(Collections.singletonList(null)));
        Set filteredSet = FileFilterUtils.filterSet((IOFileFilter)filter, (Iterable)null);
        Assertions.assertEquals((int)0, (int)filteredSet.size());
    }

    @Test
    void testHidden() throws IOException {
        File hiddenDirFile = new File(".svn");
        Path hiddenDirPath = hiddenDirFile.toPath();
        if (hiddenDirFile.exists()) {
            this.assertFiltering(HiddenFileFilter.HIDDEN, hiddenDirFile, hiddenDirFile.isHidden());
            this.assertFiltering(HiddenFileFilter.HIDDEN, hiddenDirPath, hiddenDirFile.isHidden());
            this.assertFiltering(HiddenFileFilter.VISIBLE, hiddenDirFile, !hiddenDirFile.isHidden());
            this.assertFiltering(HiddenFileFilter.VISIBLE, hiddenDirPath, !hiddenDirFile.isHidden());
        }
        Path path = this.temporaryFolder.toPath();
        this.assertFiltering(HiddenFileFilter.HIDDEN, this.temporaryFolder, false);
        this.assertFiltering(HiddenFileFilter.HIDDEN, path, false);
        this.assertFiltering(HiddenFileFilter.HIDDEN, (Path)null, true);
        this.assertFiltering(HiddenFileFilter.VISIBLE, this.temporaryFolder, true);
        this.assertFiltering(HiddenFileFilter.VISIBLE, path, true);
        this.assertFiltering(HiddenFileFilter.VISIBLE, (Path)null, false);
    }

    @Test
    void testMagicNumberFileFilterBytes() throws Exception {
        byte[] classFileMagicNumber = new byte[]{-54, -2, -70, -66};
        String xmlFileContent = "<?xml version=\"1.0\" encoding=\"UTF-8\">\n<element>text</element>";
        File classAFile = new File(this.temporaryFolder, "A.class");
        Path classAPath = classAFile.toPath();
        File xmlBFile = new File(this.temporaryFolder, "B.xml");
        Path xmlBPath = xmlBFile.toPath();
        File emptyFile = new File(this.temporaryFolder, "C.xml");
        Path emptyPath = emptyFile.toPath();
        File dirFile = new File(this.temporaryFolder, "D");
        Path dirPath = dirFile.toPath();
        dirFile.mkdirs();
        try (FileOutputStream classFileAStream = FileUtils.openOutputStream((File)classAFile);){
            IOUtils.write((byte[])classFileMagicNumber, (OutputStream)classFileAStream);
            TestUtils.generateTestData(classFileAStream, 32L);
        }
        FileUtils.write((File)xmlBFile, (CharSequence)"<?xml version=\"1.0\" encoding=\"UTF-8\">\n<element>text</element>", (Charset)StandardCharsets.UTF_8);
        FileUtils.touch((File)emptyFile);
        MagicNumberFileFilter filter = new MagicNumberFileFilter(classFileMagicNumber);
        this.assertFiltering((IOFileFilter)filter, classAFile, true);
        this.assertFiltering((IOFileFilter)filter, classAPath, true);
        this.assertFiltering((IOFileFilter)filter, xmlBFile, false);
        this.assertFiltering((IOFileFilter)filter, xmlBPath, false);
        this.assertFiltering((IOFileFilter)filter, emptyFile, false);
        this.assertFiltering((IOFileFilter)filter, emptyPath, false);
        this.assertFiltering((IOFileFilter)filter, dirFile, false);
        this.assertFiltering((IOFileFilter)filter, dirPath, false);
        filter = FileFilterUtils.magicNumberFileFilter((byte[])classFileMagicNumber);
        this.assertFiltering((IOFileFilter)filter, classAFile, true);
        this.assertFiltering((IOFileFilter)filter, classAPath, true);
        this.assertFiltering((IOFileFilter)filter, xmlBFile, false);
        this.assertFiltering((IOFileFilter)filter, xmlBPath, false);
        this.assertFiltering((IOFileFilter)filter, emptyFile, false);
        this.assertFiltering((IOFileFilter)filter, emptyPath, false);
        this.assertFiltering((IOFileFilter)filter, dirFile, false);
        this.assertFiltering((IOFileFilter)filter, dirPath, false);
    }

    @Test
    void testMagicNumberFileFilterBytesOffset() throws Exception {
        byte[] tarMagicNumber = new byte[]{117, 115, 116, 97, 114};
        long tarMagicNumberOffset = 257L;
        File tarFileA = new File(this.temporaryFolder, "A.tar");
        File randomFileB = new File(this.temporaryFolder, "B.txt");
        File dir = new File(this.temporaryFolder, "D");
        dir.mkdirs();
        try (FileOutputStream tarFileAStream = FileUtils.openOutputStream((File)tarFileA);){
            TestUtils.generateTestData(tarFileAStream, 257L);
            IOUtils.write((byte[])tarMagicNumber, (OutputStream)tarFileAStream);
        }
        if (!randomFileB.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + randomFileB + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(randomFileB.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 514L);
        }
        MagicNumberFileFilter filter = new MagicNumberFileFilter(tarMagicNumber, 257L);
        this.assertFiltering((IOFileFilter)filter, tarFileA, true);
        this.assertFiltering((IOFileFilter)filter, randomFileB, false);
        this.assertFiltering((IOFileFilter)filter, dir, false);
        filter = FileFilterUtils.magicNumberFileFilter((byte[])tarMagicNumber, (long)257L);
        this.assertFiltering((IOFileFilter)filter, tarFileA, true);
        this.assertFiltering((IOFileFilter)filter, randomFileB, false);
        this.assertFiltering((IOFileFilter)filter, dir, false);
    }

    @Test
    void testMagicNumberFileFilterString() throws Exception {
        byte[] classFileMagicNumber = new byte[]{-54, -2, -70, -66};
        String xmlFileContent = "<?xml version=\"1.0\" encoding=\"UTF-8\">\n<element>text</element>";
        String xmlMagicNumber = "<?xml version=\"1.0\"";
        File classFileA = new File(this.temporaryFolder, "A.class");
        File xmlFileB = new File(this.temporaryFolder, "B.xml");
        File dir = new File(this.temporaryFolder, "D");
        dir.mkdirs();
        try (FileOutputStream classFileAStream = FileUtils.openOutputStream((File)classFileA);){
            IOUtils.write((byte[])classFileMagicNumber, (OutputStream)classFileAStream);
            TestUtils.generateTestData(classFileAStream, 32L);
        }
        FileUtils.write((File)xmlFileB, (CharSequence)"<?xml version=\"1.0\" encoding=\"UTF-8\">\n<element>text</element>", (Charset)StandardCharsets.UTF_8);
        MagicNumberFileFilter filter = new MagicNumberFileFilter("<?xml version=\"1.0\"");
        this.assertFiltering((IOFileFilter)filter, classFileA, false);
        this.assertFiltering((IOFileFilter)filter, xmlFileB, true);
        this.assertFiltering((IOFileFilter)filter, dir, false);
        filter = FileFilterUtils.magicNumberFileFilter((String)"<?xml version=\"1.0\"");
        this.assertFiltering((IOFileFilter)filter, classFileA, false);
        this.assertFiltering((IOFileFilter)filter, xmlFileB, true);
        this.assertFiltering((IOFileFilter)filter, dir, false);
    }

    @Test
    void testMagicNumberFileFilterStringOffset() throws Exception {
        String tarMagicNumber = "ustar";
        long tarMagicNumberOffset = 257L;
        File tarFileA = new File(this.temporaryFolder, "A.tar");
        File randomFileB = new File(this.temporaryFolder, "B.txt");
        File dir = new File(this.temporaryFolder, "D");
        dir.mkdirs();
        try (FileOutputStream tarFileAStream = FileUtils.openOutputStream((File)tarFileA);){
            TestUtils.generateTestData(tarFileAStream, 257L);
            IOUtils.write((String)"ustar", (OutputStream)tarFileAStream, (Charset)StandardCharsets.UTF_8);
        }
        if (!randomFileB.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + randomFileB + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(randomFileB.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 514L);
        }
        MagicNumberFileFilter filter = new MagicNumberFileFilter("ustar", 257L);
        this.assertFiltering((IOFileFilter)filter, tarFileA, true);
        this.assertFiltering((IOFileFilter)filter, randomFileB, false);
        this.assertFiltering((IOFileFilter)filter, dir, false);
        filter = FileFilterUtils.magicNumberFileFilter((String)"ustar", (long)257L);
        this.assertFiltering((IOFileFilter)filter, tarFileA, true);
        this.assertFiltering((IOFileFilter)filter, randomFileB, false);
        this.assertFiltering((IOFileFilter)filter, dir, false);
    }

    @Test
    void testMagicNumberFileFilterValidation() {
        Assertions.assertThrows(NullPointerException.class, () -> new MagicNumberFileFilter((String)null, 0L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new MagicNumberFileFilter("0", -1L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new MagicNumberFileFilter("", 0L));
        Assertions.assertThrows(NullPointerException.class, () -> new MagicNumberFileFilter((byte[])null, 0L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new MagicNumberFileFilter(new byte[]{0}, -1L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new MagicNumberFileFilter(new byte[0], 0L));
    }

    @Test
    void testMakeCVSAware() throws Exception {
        IOFileFilter filter1 = FileFilterUtils.makeCVSAware(null);
        IOFileFilter filter2 = FileFilterUtils.makeCVSAware((IOFileFilter)FileFilterUtils.nameFileFilter((String)"test-file1.txt"));
        File file = new File(this.temporaryFolder, "CVS");
        file.mkdirs();
        this.assertFiltering(filter1, file, false);
        this.assertFiltering(filter2, file, false);
        FileUtils.deleteDirectory((File)file);
        file = new File(this.temporaryFolder, "test-file1.txt");
        if (!file.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + file + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output2 = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output2, 0L);
        }
        this.assertFiltering(filter1, file, true);
        this.assertFiltering(filter2, file, true);
        file = new File(this.temporaryFolder, "test-file2.log");
        if (!file.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + file + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output1 = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output1, 0L);
        }
        this.assertFiltering(filter1, file, true);
        this.assertFiltering(filter2, file, false);
        file = new File(this.temporaryFolder, "CVS");
        if (!file.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + file + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 0L);
        }
        this.assertFiltering(filter1, file, true);
        this.assertFiltering(filter2, file, false);
    }

    @Test
    void testMakeDirectoryOnly() throws Exception {
        Assertions.assertSame((Object)DirectoryFileFilter.DIRECTORY, (Object)FileFilterUtils.makeDirectoryOnly(null));
        IOFileFilter filter = FileFilterUtils.makeDirectoryOnly((IOFileFilter)FileFilterUtils.nameFileFilter((String)"B"));
        File fileA = new File(this.temporaryFolder, "A");
        File fileB = new File(this.temporaryFolder, "B");
        fileA.mkdirs();
        fileB.mkdirs();
        this.assertFiltering(filter, fileA, false);
        this.assertFiltering(filter, fileB, true);
        FileUtils.deleteDirectory((File)fileA);
        FileUtils.deleteDirectory((File)fileB);
        if (!fileA.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + fileA + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output1 = new BufferedOutputStream(Files.newOutputStream(fileA.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output1, 32L);
        }
        if (!fileB.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + fileB + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(fileB.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 32L);
        }
        this.assertFiltering(filter, fileA, false);
        this.assertFiltering(filter, fileB, false);
        fileA.delete();
        fileB.delete();
    }

    @Test
    void testMakeFileOnly() throws Exception {
        Assertions.assertSame((Object)FileFileFilter.INSTANCE, (Object)FileFilterUtils.makeFileOnly(null));
        IOFileFilter filter = FileFilterUtils.makeFileOnly((IOFileFilter)FileFilterUtils.nameFileFilter((String)"B"));
        File fileA = new File(this.temporaryFolder, "A");
        File fileB = new File(this.temporaryFolder, "B");
        fileA.mkdirs();
        fileB.mkdirs();
        this.assertFiltering(filter, fileA, false);
        this.assertFiltering(filter, fileB, false);
        FileUtils.deleteDirectory((File)fileA);
        FileUtils.deleteDirectory((File)fileB);
        if (!fileA.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + fileA + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output1 = new BufferedOutputStream(Files.newOutputStream(fileA.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output1, 32L);
        }
        if (!fileB.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + fileB + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(fileB.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 32L);
        }
        this.assertFiltering(filter, fileA, false);
        this.assertFiltering(filter, fileB, true);
        fileA.delete();
        fileB.delete();
    }

    @Test
    void testMakeSVNAware() throws Exception {
        IOFileFilter filter1 = FileFilterUtils.makeSVNAware(null);
        IOFileFilter filter2 = FileFilterUtils.makeSVNAware((IOFileFilter)FileFilterUtils.nameFileFilter((String)"test-file1.txt"));
        File file = new File(this.temporaryFolder, ".svn");
        file.mkdirs();
        this.assertFiltering(filter1, file, false);
        this.assertFiltering(filter2, file, false);
        FileUtils.deleteDirectory((File)file);
        file = new File(this.temporaryFolder, "test-file1.txt");
        if (!file.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + file + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output2 = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output2, 0L);
        }
        this.assertFiltering(filter1, file, true);
        this.assertFiltering(filter2, file, true);
        file = new File(this.temporaryFolder, "test-file2.log");
        if (!file.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + file + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output1 = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output1, 0L);
        }
        this.assertFiltering(filter1, file, true);
        this.assertFiltering(filter2, file, false);
        file = new File(this.temporaryFolder, ".svn");
        if (!file.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + file + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 0L);
        }
        this.assertFiltering(filter1, file, true);
        this.assertFiltering(filter2, file, false);
    }

    @Test
    void testNameFilter() throws IOException {
        NameFileFilter filter = new NameFileFilter(new String[]{"foo", "bar"});
        this.assertFooBarFileFiltering((IOFileFilter)filter);
        this.assertFiltering((IOFileFilter)filter, (File)null, false);
        this.assertFiltering((IOFileFilter)filter, (Path)null, false);
    }

    @Test
    void testNameFilterNullArgument() {
        String test = null;
        String failMessage = "constructing a NameFileFilter with a null String argument should fail.";
        Assertions.assertThrows(NullPointerException.class, () -> new NameFileFilter(test), (String)"constructing a NameFileFilter with a null String argument should fail.");
        Assertions.assertThrows(NullPointerException.class, () -> FileFilterUtils.nameFileFilter((String)test, (IOCase)IOCase.INSENSITIVE), (String)"constructing a NameFileFilter with a null String argument should fail.");
    }

    @Test
    void testNameFilterNullArrayArgument() {
        Assertions.assertThrows(NullPointerException.class, () -> new NameFileFilter((String[])null));
    }

    @Test
    void testNameFilterNullListArgument() {
        List test = null;
        Assertions.assertThrows(NullPointerException.class, () -> new NameFileFilter(test));
    }

    @Test
    void testNegate() throws IOException {
        IOFileFilter filter = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.trueFileFilter());
        this.assertFiltering(filter, new File("foo.test"), false);
        this.assertFiltering(filter, new File("foo"), false);
        this.assertFiltering(filter.negate(), new File("foo"), true);
        this.assertFiltering(filter, (File)null, false);
        Assertions.assertThrows(NullPointerException.class, () -> new NotFileFilter(null));
    }

    @Test
    void testNullFilters() {
        Assertions.assertThrows(NullPointerException.class, () -> FileFilterUtils.toList((IOFileFilter[])new IOFileFilter[]{null}));
        Assertions.assertThrows(NullPointerException.class, () -> FileFilterUtils.toList((IOFileFilter[])new IOFileFilter[]{null}));
    }

    @Test
    void testOr() throws IOException {
        IOFileFilter trueFilter = TrueFileFilter.INSTANCE;
        IOFileFilter falseFilter = FalseFileFilter.INSTANCE;
        File testFile = new File("foo.test");
        Path testPath = testFile.toPath();
        this.assertFiltering((IOFileFilter)new OrFileFilter(trueFilter, trueFilter), testFile, true);
        this.assertFiltering((IOFileFilter)new OrFileFilter(trueFilter, falseFilter), testFile, true);
        this.assertFiltering((IOFileFilter)new OrFileFilter(falseFilter, trueFilter), testFile, true);
        this.assertFiltering((IOFileFilter)new OrFileFilter(falseFilter, falseFilter), testFile, false);
        this.assertFiltering((IOFileFilter)new OrFileFilter(), testFile, false);
        this.assertFiltering((IOFileFilter)new OrFileFilter(trueFilter, trueFilter), testPath, true);
        this.assertFiltering((IOFileFilter)new OrFileFilter(trueFilter, falseFilter), testPath, true);
        this.assertFiltering((IOFileFilter)new OrFileFilter(falseFilter, trueFilter), testPath, true);
        this.assertFiltering((IOFileFilter)new OrFileFilter(falseFilter, falseFilter), testPath, false);
        this.assertFiltering((IOFileFilter)new OrFileFilter(), testPath, false);
        this.assertFiltering(falseFilter.or(trueFilter), testPath, true);
        ArrayList<IOFileFilter> filters = new ArrayList<IOFileFilter>();
        filters.add(trueFilter);
        filters.add(falseFilter);
        OrFileFilter orFilter = new OrFileFilter(filters);
        this.assertFiltering((IOFileFilter)orFilter, testFile, true);
        this.assertFiltering((IOFileFilter)orFilter, testPath, true);
        Assertions.assertEquals((Object)orFilter.getFileFilters(), filters);
        orFilter.removeFileFilter(trueFilter);
        this.assertFiltering((IOFileFilter)orFilter, testFile, false);
        this.assertFiltering((IOFileFilter)orFilter, testPath, false);
        orFilter.setFileFilters(filters);
        this.assertFiltering((IOFileFilter)orFilter, testFile, true);
        this.assertFiltering((IOFileFilter)orFilter, testPath, true);
        Assertions.assertTrue((boolean)orFilter.accept(testFile.getParentFile(), testFile.getName()));
        Assertions.assertEquals((Object)((Object)FileVisitResult.CONTINUE), (Object)((Object)orFilter.accept(testPath, null)));
        Assertions.assertTrue((boolean)orFilter.matches(testPath));
        orFilter.removeFileFilter(trueFilter);
        Assertions.assertFalse((boolean)orFilter.accept(testFile.getParentFile(), testFile.getName()));
        Assertions.assertEquals((Object)((Object)FileVisitResult.TERMINATE), (Object)((Object)orFilter.accept(testPath, null)));
        Assertions.assertFalse((boolean)orFilter.matches(testPath));
        Assertions.assertThrows(NullPointerException.class, () -> new OrFileFilter(falseFilter, null));
    }

    @Test
    void testPathEqualsFilter() throws IOException {
        this.assertFooBarFileFiltering(new PathEqualsFileFilter(Paths.get("foo", new String[0])).or((IOFileFilter)new PathEqualsFileFilter(Paths.get("bar", new String[0]))));
    }

    @Test
    void testPrefix() throws IOException {
        PrefixFileFilter filter = new PrefixFileFilter(new String[]{"foo", "bar"});
        File testFile = new File("test");
        Path testPath = testFile.toPath();
        File fredFile = new File("fred");
        Path fredPath = fredFile.toPath();
        this.assertFiltering((IOFileFilter)filter, new File("foo.test"), true);
        this.assertFiltering((IOFileFilter)filter, new File("FOO.test"), false);
        this.assertFiltering((IOFileFilter)filter, new File("foo"), true);
        this.assertFiltering((IOFileFilter)filter, new File("bar"), true);
        this.assertFiltering((IOFileFilter)filter, new File("food/"), true);
        this.assertFiltering((IOFileFilter)filter, new File("foo.test").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("FOO.test").toPath(), false);
        this.assertFiltering((IOFileFilter)filter, new File("foo").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("bar").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("food/").toPath(), true);
        filter = FileFilterUtils.prefixFileFilter((String)"bar");
        this.assertFiltering((IOFileFilter)filter, new File("barred\\"), true);
        this.assertFiltering((IOFileFilter)filter, new File("test"), false);
        this.assertFiltering((IOFileFilter)filter, new File("fo_o.test"), false);
        this.assertFiltering((IOFileFilter)filter, new File("abar.exe"), false);
        this.assertFiltering((IOFileFilter)filter, new File("barred\\").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("test").toPath(), false);
        this.assertFiltering((IOFileFilter)filter, new File("fo_o.test").toPath(), false);
        this.assertFiltering((IOFileFilter)filter, new File("abar.exe").toPath(), false);
        filter = new PrefixFileFilter("tes");
        this.assertFiltering((IOFileFilter)filter, new File("test"), true);
        this.assertFiltering((IOFileFilter)filter, new File("fred"), false);
        this.assertFiltering((IOFileFilter)filter, new File("test").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("fred").toPath(), false);
        Assertions.assertTrue((boolean)filter.accept(testFile.getParentFile(), testFile.getName()));
        Assertions.assertFalse((boolean)filter.accept(fredFile.getParentFile(), fredFile.getName()));
        Assertions.assertEquals((Object)((Object)FileVisitResult.CONTINUE), (Object)((Object)filter.accept(testPath, null)));
        Assertions.assertEquals((Object)((Object)FileVisitResult.TERMINATE), (Object)((Object)filter.accept(fredPath, null)));
        Assertions.assertTrue((boolean)filter.matches(testPath));
        Assertions.assertFalse((boolean)filter.matches(fredPath));
        List<String> prefixes = Arrays.asList("foo", "fre");
        PrefixFileFilter listFilter = new PrefixFileFilter(prefixes);
        Assertions.assertFalse((boolean)listFilter.accept(testFile.getParentFile(), testFile.getName()));
        Assertions.assertTrue((boolean)listFilter.accept(fredFile.getParentFile(), fredFile.getName()));
        Assertions.assertEquals((Object)((Object)FileVisitResult.TERMINATE), (Object)((Object)listFilter.accept(testPath, null)));
        Assertions.assertEquals((Object)((Object)FileVisitResult.CONTINUE), (Object)((Object)listFilter.accept(fredPath, null)));
        Assertions.assertFalse((boolean)listFilter.matches(testPath));
        Assertions.assertTrue((boolean)listFilter.matches(fredPath));
        Assertions.assertThrows(NullPointerException.class, () -> new PrefixFileFilter((String)null));
        Assertions.assertThrows(NullPointerException.class, () -> new PrefixFileFilter((String[])null));
        Assertions.assertThrows(NullPointerException.class, () -> new PrefixFileFilter((List)null));
    }

    @Test
    void testPrefixCaseInsensitive() throws IOException {
        PrefixFileFilter filter = new PrefixFileFilter(new String[]{"foo", "bar"}, IOCase.INSENSITIVE);
        this.assertFiltering((IOFileFilter)filter, new File("foo.test1"), true);
        this.assertFiltering((IOFileFilter)filter, new File("bar.test1"), true);
        this.assertFiltering((IOFileFilter)filter, new File("FOO.test1"), true);
        this.assertFiltering((IOFileFilter)filter, new File("BAR.test1"), true);
        filter = new PrefixFileFilter("bar", IOCase.INSENSITIVE);
        this.assertFiltering((IOFileFilter)filter, new File("foo.test2"), false);
        this.assertFiltering((IOFileFilter)filter, new File("bar.test2"), true);
        this.assertFiltering((IOFileFilter)filter, new File("FOO.test2"), false);
        this.assertFiltering((IOFileFilter)filter, new File("BAR.test2"), true);
        List<String> prefixes = Arrays.asList("foo", "bar");
        filter = new PrefixFileFilter(prefixes, IOCase.INSENSITIVE);
        this.assertFiltering((IOFileFilter)filter, new File("foo.test3"), true);
        this.assertFiltering((IOFileFilter)filter, new File("bar.test3"), true);
        this.assertFiltering((IOFileFilter)filter, new File("FOO.test3"), true);
        this.assertFiltering((IOFileFilter)filter, new File("BAR.test3"), true);
        Assertions.assertThrows(NullPointerException.class, () -> new PrefixFileFilter((String)null, IOCase.INSENSITIVE));
        Assertions.assertThrows(NullPointerException.class, () -> new PrefixFileFilter((String[])null, IOCase.INSENSITIVE));
        Assertions.assertThrows(NullPointerException.class, () -> new PrefixFileFilter((List)null, IOCase.INSENSITIVE));
        filter = FileFilterUtils.prefixFileFilter((String)"bar", (IOCase)IOCase.INSENSITIVE);
        this.assertFiltering((IOFileFilter)filter, new File("foo.test2"), false);
        this.assertFiltering((IOFileFilter)filter, new File("bar.test2"), true);
        this.assertFiltering((IOFileFilter)filter, new File("FOO.test2"), false);
        this.assertFiltering((IOFileFilter)filter, new File("BAR.test2"), true);
        Assertions.assertThrows(NullPointerException.class, () -> FileFilterUtils.prefixFileFilter(null, (IOCase)IOCase.INSENSITIVE));
    }

    @Test
    void testSizeFilterOnFiles() throws Exception {
        File smallFile = new File(this.temporaryFolder, "small.txt");
        if (!smallFile.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + smallFile + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output1 = new BufferedOutputStream(Files.newOutputStream(smallFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output1, 32L);
        }
        File largeFile = new File(this.temporaryFolder, "large.txt");
        if (!largeFile.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + largeFile + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(largeFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 128L);
        }
        IOFileFilter filter1 = FileFilterUtils.sizeFileFilter((long)64L);
        IOFileFilter filter2 = FileFilterUtils.sizeFileFilter((long)64L, (boolean)true);
        IOFileFilter filter3 = FileFilterUtils.sizeFileFilter((long)64L, (boolean)false);
        this.assertFiltering(filter1, smallFile, false);
        this.assertFiltering(filter2, smallFile, false);
        this.assertFiltering(filter3, smallFile, true);
        this.assertFiltering(filter1, largeFile, true);
        this.assertFiltering(filter2, largeFile, true);
        this.assertFiltering(filter3, largeFile, false);
        IOFileFilter filter4 = FileFilterUtils.sizeRangeFileFilter((long)33L, (long)127L);
        IOFileFilter filter5 = FileFilterUtils.sizeRangeFileFilter((long)32L, (long)127L);
        IOFileFilter filter6 = FileFilterUtils.sizeRangeFileFilter((long)33L, (long)128L);
        IOFileFilter filter7 = FileFilterUtils.sizeRangeFileFilter((long)31L, (long)129L);
        IOFileFilter filter8 = FileFilterUtils.sizeRangeFileFilter((long)128L, (long)128L);
        this.assertFiltering(filter4, smallFile, false);
        this.assertFiltering(filter4, largeFile, false);
        this.assertFiltering(filter5, smallFile, true);
        this.assertFiltering(filter5, largeFile, false);
        this.assertFiltering(filter6, smallFile, false);
        this.assertFiltering(filter6, largeFile, true);
        this.assertFiltering(filter7, smallFile, true);
        this.assertFiltering(filter7, largeFile, true);
        this.assertFiltering(filter8, largeFile, true);
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileFilterUtils.sizeFileFilter((long)-1L));
    }

    @Test
    void testSizeFilterOnPaths() throws Exception {
        Path smallFile = Paths.get(this.temporaryFolder.toString(), "small.txt");
        if (Files.notExists(smallFile.getParent(), new LinkOption[0])) {
            Assertions.fail((String)("Cannot create file " + smallFile + " as the parent directory does not exist"));
        }
        try (OutputStream output = Files.newOutputStream(smallFile, new OpenOption[0]);){
            TestUtils.generateTestData(output, 32L);
        }
        Path largeFile = Paths.get(this.temporaryFolder.toString(), "large.txt");
        if (Files.notExists(largeFile.getParent(), new LinkOption[0])) {
            Assertions.fail((String)("Cannot create file " + largeFile + " as the parent directory does not exist"));
        }
        try (OutputStream output = Files.newOutputStream(largeFile, new OpenOption[0]);){
            TestUtils.generateTestData(output, 128L);
        }
        IOFileFilter filter1 = FileFilterUtils.sizeFileFilter((long)64L);
        IOFileFilter filter2 = FileFilterUtils.sizeFileFilter((long)64L, (boolean)true);
        IOFileFilter filter3 = FileFilterUtils.sizeFileFilter((long)64L, (boolean)false);
        this.assertFiltering(filter1, smallFile, false);
        this.assertFiltering(filter2, smallFile, false);
        this.assertFiltering(filter3, smallFile, true);
        this.assertFiltering(filter1, largeFile, true);
        this.assertFiltering(filter2, largeFile, true);
        this.assertFiltering(filter3, largeFile, false);
        IOFileFilter filter4 = FileFilterUtils.sizeRangeFileFilter((long)33L, (long)127L);
        IOFileFilter filter5 = FileFilterUtils.sizeRangeFileFilter((long)32L, (long)127L);
        IOFileFilter filter6 = FileFilterUtils.sizeRangeFileFilter((long)33L, (long)128L);
        IOFileFilter filter7 = FileFilterUtils.sizeRangeFileFilter((long)31L, (long)129L);
        IOFileFilter filter8 = FileFilterUtils.sizeRangeFileFilter((long)128L, (long)128L);
        this.assertFiltering(filter4, smallFile, false);
        this.assertFiltering(filter4, largeFile, false);
        this.assertFiltering(filter5, smallFile, true);
        this.assertFiltering(filter5, largeFile, false);
        this.assertFiltering(filter6, smallFile, false);
        this.assertFiltering(filter6, largeFile, true);
        this.assertFiltering(filter7, smallFile, true);
        this.assertFiltering(filter7, largeFile, true);
        this.assertFiltering(filter8, largeFile, true);
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileFilterUtils.sizeFileFilter((long)-1L));
    }

    @Test
    void testSuffix() throws IOException {
        SuffixFileFilter filter = new SuffixFileFilter(new String[]{"tes", "est"});
        File testFile = new File("test");
        Path testPath = testFile.toPath();
        File fredFile = new File("fred");
        Path fredPath = fredFile.toPath();
        this.assertFiltering((IOFileFilter)filter, new File("fred.tes"), true);
        this.assertFiltering((IOFileFilter)filter, new File("fred.est"), true);
        this.assertFiltering((IOFileFilter)filter, new File("fred.EST"), false);
        this.assertFiltering((IOFileFilter)filter, new File("fred.exe"), false);
        this.assertFiltering((IOFileFilter)filter, new File("fred.tes").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("fred.est").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("fred.EST").toPath(), false);
        this.assertFiltering((IOFileFilter)filter, new File("fred.exe").toPath(), false);
        filter = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.suffixFileFilter((String)"tes"), FileFilterUtils.suffixFileFilter((String)"est")});
        this.assertFiltering((IOFileFilter)filter, new File("fred"), false);
        this.assertFiltering((IOFileFilter)filter, new File(".tes"), true);
        this.assertFiltering((IOFileFilter)filter, new File("fred.test"), true);
        this.assertFiltering((IOFileFilter)filter, new File("fred").toPath(), false);
        this.assertFiltering((IOFileFilter)filter, new File(".tes").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("fred.test").toPath(), true);
        filter = new SuffixFileFilter("est");
        this.assertFiltering((IOFileFilter)filter, new File("test"), true);
        this.assertFiltering((IOFileFilter)filter, new File("fred"), false);
        this.assertFiltering((IOFileFilter)filter, new File("test").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("fred").toPath(), false);
        Assertions.assertTrue((boolean)filter.accept(testFile.getParentFile(), testFile.getName()));
        Assertions.assertFalse((boolean)filter.accept(fredFile.getParentFile(), fredFile.getName()));
        Assertions.assertEquals((Object)((Object)FileVisitResult.CONTINUE), (Object)((Object)filter.accept(testPath, null)));
        Assertions.assertEquals((Object)((Object)FileVisitResult.TERMINATE), (Object)((Object)filter.accept(fredPath, null)));
        Assertions.assertTrue((boolean)filter.matches(testPath));
        Assertions.assertFalse((boolean)filter.matches(fredPath));
        List<String> prefixes = Arrays.asList("ood", "red");
        SuffixFileFilter listFilter = new SuffixFileFilter(prefixes);
        Assertions.assertFalse((boolean)listFilter.accept(testFile.getParentFile(), testFile.getName()));
        Assertions.assertTrue((boolean)listFilter.accept(fredFile.getParentFile(), fredFile.getName()));
        Assertions.assertEquals((Object)((Object)FileVisitResult.TERMINATE), (Object)((Object)listFilter.accept(testPath, null)));
        Assertions.assertEquals((Object)((Object)FileVisitResult.CONTINUE), (Object)((Object)listFilter.accept(fredPath, null)));
        Assertions.assertThrows(NullPointerException.class, () -> new SuffixFileFilter((String)null));
        Assertions.assertThrows(NullPointerException.class, () -> new SuffixFileFilter((String[])null));
        Assertions.assertThrows(NullPointerException.class, () -> new SuffixFileFilter((List)null));
    }

    @Test
    void testSuffixCaseInsensitive() throws IOException {
        SuffixFileFilter filter = new SuffixFileFilter(new String[]{"tes", "est"}, IOCase.INSENSITIVE);
        this.assertFiltering((IOFileFilter)filter, new File("foo.tes"), true);
        this.assertFiltering((IOFileFilter)filter, new File("foo.est"), true);
        this.assertFiltering((IOFileFilter)filter, new File("foo.EST"), true);
        this.assertFiltering((IOFileFilter)filter, new File("foo.TES"), true);
        this.assertFiltering((IOFileFilter)filter, new File("foo.exe"), false);
        filter = new SuffixFileFilter("est", IOCase.INSENSITIVE);
        this.assertFiltering((IOFileFilter)filter, new File("test"), true);
        this.assertFiltering((IOFileFilter)filter, new File("TEST"), true);
        List<String> suffixes = Arrays.asList("tes", "est");
        filter = new SuffixFileFilter(suffixes, IOCase.INSENSITIVE);
        this.assertFiltering((IOFileFilter)filter, new File("bar.tes"), true);
        this.assertFiltering((IOFileFilter)filter, new File("bar.est"), true);
        this.assertFiltering((IOFileFilter)filter, new File("bar.EST"), true);
        this.assertFiltering((IOFileFilter)filter, new File("bar.TES"), true);
        this.assertFiltering((IOFileFilter)filter, new File("bar.exe"), false);
        Assertions.assertThrows(NullPointerException.class, () -> new SuffixFileFilter((String)null, IOCase.INSENSITIVE));
        Assertions.assertThrows(NullPointerException.class, () -> new SuffixFileFilter((String[])null, IOCase.INSENSITIVE));
        Assertions.assertThrows(NullPointerException.class, () -> new SuffixFileFilter((List)null, IOCase.INSENSITIVE));
        filter = FileFilterUtils.suffixFileFilter((String)"est", (IOCase)IOCase.INSENSITIVE);
        this.assertFiltering((IOFileFilter)filter, new File("test"), true);
        this.assertFiltering((IOFileFilter)filter, new File("TEST"), true);
        Assertions.assertThrows(NullPointerException.class, () -> FileFilterUtils.suffixFileFilter(null, (IOCase)IOCase.INSENSITIVE));
    }

    @Test
    void testTrue() throws IOException {
        IOFileFilter filter = FileFilterUtils.trueFileFilter();
        this.assertFiltering(filter, new File("foo.test"), true);
        this.assertFiltering(filter, new File("foo"), true);
        this.assertFiltering(filter, (File)null, true);
        this.assertFiltering(filter, new File("foo.test").toPath(), true);
        this.assertFiltering(filter, new File("foo").toPath(), true);
        this.assertFiltering(filter, (Path)null, true);
        Assertions.assertSame((Object)TrueFileFilter.TRUE, (Object)TrueFileFilter.INSTANCE);
        Assertions.assertSame((Object)FalseFileFilter.FALSE, (Object)TrueFileFilter.INSTANCE.negate());
        Assertions.assertSame((Object)FalseFileFilter.INSTANCE, (Object)TrueFileFilter.INSTANCE.negate());
        Assertions.assertNotNull((Object)TrueFileFilter.INSTANCE.toString());
    }
}

