/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.utils;

import java.security.NoSuchAlgorithmException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.crypto.utils.Padding;

public class Transformation {
    private static final int T_DELIM_PARTS = 3;
    private static final String T_DELIM_REGEX = "/";
    private final String algorithm;
    private final String mode;
    private final Padding padding;

    public static Transformation parse(String transformation) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (transformation == null) {
            throw new NoSuchAlgorithmException("No transformation given.");
        }
        String[] parts = transformation.split(T_DELIM_REGEX, 4);
        if (parts.length != 3) {
            throw new NoSuchAlgorithmException("Invalid transformation format: " + transformation);
        }
        return new Transformation(parts[0], parts[1], parts[2]);
    }

    private Transformation(String algorithm, String mode, Padding padding) {
        this.algorithm = algorithm;
        this.mode = mode;
        this.padding = padding;
    }

    private Transformation(String algorithm, String mode, String padding) throws NoSuchPaddingException {
        this(algorithm, mode, Padding.get(padding));
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getMode() {
        return this.mode;
    }

    public Padding getPadding() {
        return this.padding;
    }
}

