/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.stream;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.crypto.cipher.CryptoCipher;
import org.apache.commons.crypto.stream.CryptoInputStream;
import org.apache.commons.crypto.stream.CtrCryptoInputStream;
import org.apache.commons.crypto.stream.input.Input;
import org.apache.commons.crypto.utils.IoUtils;
import org.apache.commons.crypto.utils.Utils;

public class PositionedCryptoInputStream
extends CtrCryptoInputStream {
    private final Queue<ByteBuffer> byteBufferPool = new ConcurrentLinkedQueue<ByteBuffer>();
    private final Queue<CipherState> cipherStatePool = new ConcurrentLinkedQueue<CipherState>();
    private final Properties properties;

    public PositionedCryptoInputStream(Properties properties, Input in, byte[] key, byte[] iv, long streamOffset) throws IOException {
        this(properties, in, Utils.getCipherInstance("AES/CTR/NoPadding", properties), CryptoInputStream.getBufferSize(properties), key, iv, streamOffset);
    }

    protected PositionedCryptoInputStream(Properties properties, Input input, CryptoCipher cipher, int bufferSize, byte[] key, byte[] iv, long streamOffset) throws IOException {
        super(input, cipher, bufferSize, key, iv, streamOffset);
        this.properties = properties;
    }

    private void cleanByteBufferPool() {
        ByteBuffer buf;
        while ((buf = this.byteBufferPool.poll()) != null) {
            CryptoInputStream.freeDirectBuffer(buf);
        }
    }

    private void cleanCipherStatePool() {
        CipherState cs;
        while ((cs = this.cipherStatePool.poll()) != null) {
            try {
                cs.getCryptoCipher().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.isOpen()) {
            return;
        }
        this.cleanByteBufferPool();
        this.cleanCipherStatePool();
        super.close();
    }

    private void decrypt(CipherState state, ByteBuffer inByteBuffer, ByteBuffer outByteBuffer, byte padding) throws IOException {
        Utils.checkState(inByteBuffer.position() >= padding);
        if (inByteBuffer.position() == padding) {
            return;
        }
        inByteBuffer.flip();
        outByteBuffer.clear();
        this.decryptBuffer(state, inByteBuffer, outByteBuffer);
        inByteBuffer.clear();
        outByteBuffer.flip();
        if (padding > 0) {
            outByteBuffer.position(padding);
        }
    }

    protected void decrypt(long position, byte[] buffer, int offset, int length) throws IOException {
        ByteBuffer inByteBuffer = this.getBuffer();
        ByteBuffer outByteBuffer = this.getBuffer();
        CipherState state = null;
        try {
            state = this.getCipherState();
            byte[] iv = (byte[])this.getInitIV().clone();
            this.resetCipher(state, position, iv);
            byte padding = this.getPadding(position);
            inByteBuffer.position(padding);
            int n = 0;
            while (n < length) {
                int toDecrypt = Math.min(length - n, inByteBuffer.remaining());
                inByteBuffer.put(buffer, offset + n, toDecrypt);
                this.decrypt(state, inByteBuffer, outByteBuffer, padding);
                outByteBuffer.get(buffer, offset + n, toDecrypt);
                padding = this.postDecryption(state, inByteBuffer, position + (long)(n += toDecrypt), iv);
            }
        }
        finally {
            this.returnToPool(inByteBuffer);
            this.returnToPool(outByteBuffer);
            this.returnToPool(state);
        }
    }

    private void decryptBuffer(CipherState state, ByteBuffer inByteBuffer, ByteBuffer outByteBuffer) throws IOException {
        int inputSize = inByteBuffer.remaining();
        try {
            int n = state.getCryptoCipher().update(inByteBuffer, outByteBuffer);
            if (n < inputSize) {
                state.getCryptoCipher().doFinal(inByteBuffer, outByteBuffer);
                state.reset(true);
            }
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    private ByteBuffer getBuffer() {
        ByteBuffer buffer = this.byteBufferPool.poll();
        return buffer != null ? buffer : ByteBuffer.allocateDirect(this.getBufferSize());
    }

    private CipherState getCipherState() throws IOException {
        CipherState state = this.cipherStatePool.poll();
        return state != null ? state : new CipherState(Utils.getCipherInstance("AES/CTR/NoPadding", this.properties));
    }

    private byte postDecryption(CipherState state, ByteBuffer inByteBuffer, long position, byte[] iv) {
        byte padding = 0;
        if (state.isReset()) {
            this.resetCipher(state, position, iv);
            padding = this.getPadding(position);
            inByteBuffer.position(padding);
        }
        return padding;
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        this.checkStream();
        int n = this.input.read(position, buffer, offset, length);
        if (n > 0) {
            this.decrypt(position, buffer, offset, n);
        }
        return n;
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        this.readFully(position, buffer, 0, buffer.length);
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        this.checkStream();
        IoUtils.readFully(this.input, position, buffer, offset, length);
        if (length > 0) {
            this.decrypt(position, buffer, offset, length);
        }
    }

    private void resetCipher(CipherState state, long position, byte[] iv) {
        long counter = this.getCounter(position);
        CtrCryptoInputStream.calculateIV(this.getInitIV(), counter, iv);
        try {
            state.getCryptoCipher().init(2, this.key, new IvParameterSpec(iv));
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        state.reset(false);
    }

    private void returnToPool(ByteBuffer buf) {
        if (buf != null) {
            buf.clear();
            this.byteBufferPool.add(buf);
        }
    }

    private void returnToPool(CipherState state) {
        if (state != null) {
            this.cipherStatePool.add(state);
        }
    }

    private static class CipherState {
        private final CryptoCipher cryptoCipher;
        private boolean reset;

        public CipherState(CryptoCipher cryptoCipher) {
            this.cryptoCipher = cryptoCipher;
            this.reset = false;
        }

        public CryptoCipher getCryptoCipher() {
            return this.cryptoCipher;
        }

        public boolean isReset() {
            return this.reset;
        }

        public void reset(boolean reset) {
            this.reset = reset;
        }
    }
}

