/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.io;

import java.io.File;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.ConfigurationLogger;
import org.apache.commons.configuration2.io.DefaultFileSystem;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestDefaultFileSystem {
    private DefaultFileSystem fileSystem;

    @BeforeEach
    public void setUp() throws Exception {
        this.fileSystem = new DefaultFileSystem();
    }

    @Test
    public void testDefaultLogger() {
        Assertions.assertNotNull((Object)this.fileSystem.getLogger());
    }

    @Test
    public void testGetOutputStreamInvalidPath() {
        File file = new File("");
        Assertions.assertThrows(ConfigurationException.class, () -> this.fileSystem.getOutputStream(file));
    }

    @Test
    public void testSetLogger() {
        ConfigurationLogger log = new ConfigurationLogger(this.getClass());
        this.fileSystem.setLogger(log);
        Assertions.assertSame((Object)log, (Object)this.fileSystem.getLogger());
    }
}

