/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder.combined;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationLookup;
import org.apache.commons.configuration2.DynamicCombinedConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.BasicBuilderParameters;
import org.apache.commons.configuration2.builder.BuilderConfigurationWrapperFactory;
import org.apache.commons.configuration2.builder.BuilderEventListenerImpl;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.ConfigurationBuilder;
import org.apache.commons.configuration2.builder.ConfigurationBuilderEvent;
import org.apache.commons.configuration2.builder.ConfigurationBuilderResultCreatedEvent;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.XMLBuilderParametersImpl;
import org.apache.commons.configuration2.builder.combined.AbstractMultiFileConfigurationBuilderTest;
import org.apache.commons.configuration2.builder.combined.MultiFileBuilderParametersImpl;
import org.apache.commons.configuration2.builder.combined.MultiFileConfigurationBuilder;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.Event;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventListenerTestImpl;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.interpol.ConfigurationInterpolator;
import org.apache.commons.configuration2.interpol.DefaultLookups;
import org.apache.commons.configuration2.interpol.Lookup;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.apache.commons.configuration2.tree.xpath.XPathExpressionEngine;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.xml.sax.SAXParseException;

public class TestMultiFileConfigurationBuilder
extends AbstractMultiFileConfigurationBuilderTest {
    private static MultiFileConfigurationBuilder<XMLConfiguration> createBuilderWithAccessToManagedBuilders(final Collection<FileBasedConfigurationBuilder<XMLConfiguration>> managedBuilders) {
        MultiFileConfigurationBuilder<XMLConfiguration> builder = new MultiFileConfigurationBuilder<XMLConfiguration>(XMLConfiguration.class){

            protected FileBasedConfigurationBuilder<XMLConfiguration> createInitializedManagedBuilder(String fileName, Map<String, Object> params) throws ConfigurationException {
                FileBasedConfigurationBuilder result = super.createInitializedManagedBuilder(fileName, params);
                managedBuilders.add(result);
                return result;
            }
        };
        builder.configure(new BuilderParameters[]{TestMultiFileConfigurationBuilder.createTestBuilderParameters(null)});
        return builder;
    }

    private static MultiFileConfigurationBuilder<XMLConfiguration> createTestBuilder(BuilderParameters managedParams) {
        return new MultiFileConfigurationBuilder(XMLConfiguration.class).configure(new BuilderParameters[]{TestMultiFileConfigurationBuilder.createTestBuilderParameters(managedParams)});
    }

    @Test
    public void testAddConfigurationListener() throws ConfigurationException {
        EventListenerTestImpl l1 = new EventListenerTestImpl(null);
        EventListener l2 = (EventListener)Mockito.mock(EventListener.class);
        MultiFileConfigurationBuilder<XMLConfiguration> builder = TestMultiFileConfigurationBuilder.createTestBuilder(null);
        builder.addEventListener(ConfigurationEvent.ANY, (EventListener)l1);
        TestMultiFileConfigurationBuilder.switchToConfig(1);
        XMLConfiguration config = (XMLConfiguration)builder.getConfiguration();
        Assertions.assertTrue((boolean)config.getEventListeners(ConfigurationEvent.ANY).contains(l1));
        builder.addEventListener(Event.ANY, l2);
        Assertions.assertTrue((boolean)config.getEventListeners(Event.ANY).contains(l2));
        Assertions.assertTrue((boolean)builder.removeEventListener(Event.ANY, l2));
        Assertions.assertFalse((boolean)builder.removeEventListener(Event.ANY, l2));
        Assertions.assertFalse((boolean)config.getEventListeners(Event.ANY).contains(l2));
        TestMultiFileConfigurationBuilder.switchToConfig(2);
        XMLConfiguration config2 = (XMLConfiguration)builder.getConfiguration();
        Assertions.assertFalse((boolean)config2.getEventListeners(Event.ANY).contains(l2));
    }

    @Test
    public void testBuilderListenerOtherTypes() throws ConfigurationException {
        BuilderEventListenerImpl listener = new BuilderEventListenerImpl();
        MultiFileConfigurationBuilder<XMLConfiguration> builder = TestMultiFileConfigurationBuilder.createTestBuilder(null);
        builder.addEventListener(ConfigurationBuilderEvent.ANY, (EventListener)listener);
        TestMultiFileConfigurationBuilder.switchToConfig(1);
        builder.getConfiguration();
        Object event = listener.nextEvent(ConfigurationBuilderEvent.CONFIGURATION_REQUEST);
        Assertions.assertEquals(builder, (Object)event.getSource());
        ConfigurationBuilderResultCreatedEvent createdEvent = (ConfigurationBuilderResultCreatedEvent)listener.nextEvent(ConfigurationBuilderResultCreatedEvent.RESULT_CREATED);
        Assertions.assertEquals(builder, (Object)createdEvent.getSource());
        listener.assertNoMoreEvents();
    }

    @Test
    public void testBuilderListenerReset() throws ConfigurationException {
        BuilderEventListenerImpl listener = new BuilderEventListenerImpl();
        ArrayList<FileBasedConfigurationBuilder<XMLConfiguration>> managedBuilders = new ArrayList<FileBasedConfigurationBuilder<XMLConfiguration>>();
        MultiFileConfigurationBuilder<XMLConfiguration> builder = TestMultiFileConfigurationBuilder.createBuilderWithAccessToManagedBuilders(managedBuilders);
        TestMultiFileConfigurationBuilder.switchToConfig(1);
        builder.addEventListener(ConfigurationBuilderEvent.RESET, (EventListener)listener);
        XMLConfiguration configuration = (XMLConfiguration)builder.getConfiguration();
        ((FileBasedConfigurationBuilder)managedBuilders.iterator().next()).resetResult();
        Object event = listener.nextEvent(ConfigurationBuilderEvent.RESET);
        Assertions.assertSame(builder, (Object)event.getSource());
        Assertions.assertNotSame((Object)configuration, (Object)builder.getConfiguration());
    }

    @Test
    public void testCaching() throws ConfigurationException {
        ArrayList<FileBasedConfigurationBuilder<XMLConfiguration>> managedBuilders = new ArrayList<FileBasedConfigurationBuilder<XMLConfiguration>>();
        MultiFileConfigurationBuilder<XMLConfiguration> builder = TestMultiFileConfigurationBuilder.createBuilderWithAccessToManagedBuilders(managedBuilders);
        TestMultiFileConfigurationBuilder.switchToConfig(1);
        builder.getConfiguration();
        Assertions.assertEquals((int)1, (int)managedBuilders.size());
        builder.getConfiguration();
        Assertions.assertEquals((int)1, (int)managedBuilders.size());
        TestMultiFileConfigurationBuilder.switchToConfig(2);
        builder.getConfiguration();
        Assertions.assertEquals((int)2, (int)managedBuilders.size());
    }

    @Test
    public void testCachingWithReset() throws ConfigurationException {
        ArrayList<FileBasedConfigurationBuilder<XMLConfiguration>> managedBuilders = new ArrayList<FileBasedConfigurationBuilder<XMLConfiguration>>();
        MultiFileConfigurationBuilder<XMLConfiguration> builder = TestMultiFileConfigurationBuilder.createBuilderWithAccessToManagedBuilders(managedBuilders);
        TestMultiFileConfigurationBuilder.switchToConfig(1);
        builder.getConfiguration();
        builder.resetParameters();
        builder.configure(new BuilderParameters[]{TestMultiFileConfigurationBuilder.createTestBuilderParameters(null)});
        builder.getConfiguration();
        Assertions.assertEquals((int)2, (int)managedBuilders.size());
    }

    @Test
    public void testFileNotFound() {
        TestMultiFileConfigurationBuilder.switchToConfig("unknown configuration ID");
        MultiFileConfigurationBuilder<XMLConfiguration> builder = TestMultiFileConfigurationBuilder.createTestBuilder(null);
        Assertions.assertThrows(ConfigurationException.class, () -> builder.getConfiguration());
    }

    @Test
    public void testFileNotFoundAllowFailOnInit() throws ConfigurationException {
        BasicBuilderParameters params = TestMultiFileConfigurationBuilder.createTestBuilderParameters(null);
        MultiFileConfigurationBuilder builder = new MultiFileConfigurationBuilder(XMLConfiguration.class, params.getParameters(), true);
        TestMultiFileConfigurationBuilder.switchToConfig("unknown configuration ID");
        XMLConfiguration config = (XMLConfiguration)builder.getConfiguration();
        Assertions.assertTrue((boolean)config.isEmpty());
    }

    @Test
    public void testGetConfiguration() throws ConfigurationException {
        MultiFileConfigurationBuilder<XMLConfiguration> builder = TestMultiFileConfigurationBuilder.createTestBuilder(null);
        String key = "rowsPerPage";
        TestMultiFileConfigurationBuilder.switchToConfig(1);
        Assertions.assertEquals((int)15, (int)((XMLConfiguration)builder.getConfiguration()).getInt("rowsPerPage"));
        TestMultiFileConfigurationBuilder.switchToConfig(2);
        Assertions.assertEquals((int)25, (int)((XMLConfiguration)builder.getConfiguration()).getInt("rowsPerPage"));
        TestMultiFileConfigurationBuilder.switchToConfig(3);
        Assertions.assertEquals((int)35, (int)((XMLConfiguration)builder.getConfiguration()).getInt("rowsPerPage"));
    }

    @Test
    public void testGetManagedBuilderClonedParameters() throws ConfigurationException {
        MultiFileConfigurationBuilder<XMLConfiguration> builder = TestMultiFileConfigurationBuilder.createTestBuilder((BuilderParameters)new XMLBuilderParametersImpl());
        TestMultiFileConfigurationBuilder.switchToConfig(1);
        FileBasedConfigurationBuilder managedBuilder1 = builder.getManagedBuilder();
        TestMultiFileConfigurationBuilder.switchToConfig(2);
        FileBasedConfigurationBuilder managedBuilder2 = builder.getManagedBuilder();
        Assertions.assertNotSame((Object)managedBuilder1.getFileHandler(), (Object)managedBuilder2.getFileHandler());
    }

    @Test
    public void testInterpolatorFromParameters() throws ConfigurationException {
        BasicBuilderParameters params = new MultiFileBuilderParametersImpl().setFilePattern("target/test-classes/testMultiConfiguration_${sys:Id}.xml").setPrefixLookups(Collections.singletonMap(DefaultLookups.SYSTEM_PROPERTIES.getPrefix(), DefaultLookups.SYSTEM_PROPERTIES.getLookup()));
        MultiFileConfigurationBuilder builder = new MultiFileConfigurationBuilder(XMLConfiguration.class);
        builder.configure(new BuilderParameters[]{params});
        TestMultiFileConfigurationBuilder.switchToConfig(1);
        Assertions.assertEquals((int)15, (int)((XMLConfiguration)builder.getConfiguration()).getInt("rowsPerPage"));
    }

    @Test
    public void testInterpolatorReset() {
        MultiFileBuilderParametersImpl params = new MultiFileBuilderParametersImpl().setFilePattern("target/test-classes/testMultiConfiguration_${sys:Id}.xml");
        MultiFileConfigurationBuilder builder = new MultiFileConfigurationBuilder(XMLConfiguration.class);
        builder.configure(new BuilderParameters[]{params});
        ConfigurationInterpolator interpolator = builder.getInterpolator();
        Assertions.assertNotNull((Object)interpolator);
        builder.resetParameters();
        Assertions.assertNotSame((Object)interpolator, (Object)builder.getInterpolator());
    }

    @Test
    public void testManagedConfigurationSettings() throws ConfigurationException {
        MultiFileConfigurationBuilder builder = new MultiFileConfigurationBuilder(XMLConfiguration.class);
        XPathExpressionEngine engine = new XPathExpressionEngine();
        BasicBuilderParameters xmlParams = new XMLBuilderParametersImpl().setExpressionEngine((ExpressionEngine)engine).setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(';'));
        MultiFileBuilderParametersImpl params = new MultiFileBuilderParametersImpl().setFilePattern("target/test-classes/testMultiConfiguration_${sys:Id}.xml").setManagedBuilderParameters((BuilderParameters)xmlParams);
        ConfigurationInterpolator ci = TestMultiFileConfigurationBuilder.createInterpolator();
        params.setInterpolator(ci).setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler('#'));
        builder.configure(new BuilderParameters[]{params});
        TestMultiFileConfigurationBuilder.switchToConfig(1);
        XMLConfiguration config = (XMLConfiguration)builder.getConfiguration();
        Assertions.assertSame((Object)engine, (Object)config.getExpressionEngine());
        DefaultListDelimiterHandler listHandler = (DefaultListDelimiterHandler)config.getListDelimiterHandler();
        Assertions.assertEquals((char)';', (char)listHandler.getDelimiter());
        Assertions.assertNotSame((Object)ci, (Object)config.getInterpolator());
    }

    @Test
    public void testNoPattern() {
        BasicBuilderParameters params = new MultiFileBuilderParametersImpl().setInterpolator(TestMultiFileConfigurationBuilder.createInterpolator());
        MultiFileConfigurationBuilder builder = new MultiFileConfigurationBuilder(XMLConfiguration.class, params.getParameters(), true);
        TestMultiFileConfigurationBuilder.switchToConfig(1);
        Assertions.assertThrows(ConfigurationException.class, () -> ((MultiFileConfigurationBuilder)builder).getConfiguration());
    }

    @Test
    public void testRecursiveInterpolation() {
        DynamicCombinedConfiguration config = new DynamicCombinedConfiguration();
        config.setKeyPattern("${sys:Id}");
        BasicBuilderParameters params = TestMultiFileConfigurationBuilder.createTestBuilderParameters(null);
        ConfigurationInterpolator ci = new ConfigurationInterpolator();
        ci.addDefaultLookup((Lookup)new ConfigurationLookup((ImmutableConfiguration)config));
        params.setInterpolator(ci);
        MultiFileConfigurationBuilder builder = new MultiFileConfigurationBuilder(XMLConfiguration.class, null, true);
        builder.configure(new BuilderParameters[]{params});
        BuilderConfigurationWrapperFactory wrapFactory = new BuilderConfigurationWrapperFactory();
        config.addConfiguration((Configuration)wrapFactory.createBuilderConfigurationWrapper(HierarchicalConfiguration.class, (ConfigurationBuilder)builder), "Multi");
        Assertions.assertTrue((boolean)config.isEmpty());
    }

    @Test
    public void testRemoveBuilderListenerOnReset() throws ConfigurationException {
        BuilderEventListenerImpl listener = new BuilderEventListenerImpl();
        ArrayList<FileBasedConfigurationBuilder<XMLConfiguration>> managedBuilders = new ArrayList<FileBasedConfigurationBuilder<XMLConfiguration>>();
        MultiFileConfigurationBuilder<XMLConfiguration> builder = TestMultiFileConfigurationBuilder.createBuilderWithAccessToManagedBuilders(managedBuilders);
        TestMultiFileConfigurationBuilder.switchToConfig(1);
        builder.addEventListener(ConfigurationBuilderEvent.RESET, (EventListener)listener);
        builder.getConfiguration();
        builder.resetParameters();
        ((FileBasedConfigurationBuilder)managedBuilders.iterator().next()).resetResult();
        listener.assertNoMoreEvents();
    }

    @Test
    public void testSchemaValidationError() {
        Throwable cause;
        MultiFileConfigurationBuilder<XMLConfiguration> builder = TestMultiFileConfigurationBuilder.createTestBuilder((BuilderParameters)new XMLBuilderParametersImpl().setValidating(true).setSchemaValidation(true));
        TestMultiFileConfigurationBuilder.switchToConfig("2001");
        ConfigurationException ex = (ConfigurationException)Assertions.assertThrows(ConfigurationException.class, () -> builder.getConfiguration());
        for (cause = ex.getCause(); cause != null && !(cause instanceof SAXParseException); cause = cause.getCause()) {
        }
        Assertions.assertNotNull((Object)cause);
    }
}

