/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.configuration2.InterpolationTestHelper;
import org.apache.commons.configuration2.SubnodeConfiguration;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.DisabledListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.interpol.ConfigurationInterpolator;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.InMemoryNodeModel;
import org.apache.commons.configuration2.tree.InMemoryNodeModelSupport;
import org.apache.commons.configuration2.tree.NodeKeyResolver;
import org.apache.commons.configuration2.tree.NodeSelector;
import org.apache.commons.configuration2.tree.NodeStructureHelper;
import org.apache.commons.configuration2.tree.TrackedNodeModel;
import org.apache.commons.configuration2.tree.xpath.XPathExpressionEngine;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestSubnodeConfiguration {
    private static final String SUB_KEY = "tables.table(0)";
    private static final NodeSelector SELECTOR = new NodeSelector("tables.table(0)");
    private BaseHierarchicalConfiguration parent;
    private SubnodeConfiguration config;

    private static void appendTree(BaseHierarchicalConfiguration configuration, ImmutableNode root) {
        configuration.addNodes(null, Collections.singleton(root));
    }

    private static BaseHierarchicalConfiguration setUpParentConfig() {
        BaseHierarchicalConfiguration conf = new BaseHierarchicalConfiguration();
        TestSubnodeConfiguration.appendTree(conf, NodeStructureHelper.ROOT_TABLES_TREE);
        return conf;
    }

    private void checkInterpolationFromConfigurationAt(boolean withUpdates) {
        this.parent.addProperty("base.dir", (Object)"/home/foo");
        this.parent.addProperty("test.absolute.dir.dir1", (Object)"${base.dir}/path1");
        this.parent.addProperty("test.absolute.dir.dir2", (Object)"${base.dir}/path2");
        this.parent.addProperty("test.absolute.dir.dir3", (Object)"${base.dir}/path3");
        HierarchicalConfiguration sub = this.parent.configurationAt("test.absolute.dir", withUpdates);
        for (int i = 1; i < 4; ++i) {
            Assertions.assertEquals((Object)("/home/foo/path" + i), (Object)this.parent.getString("test.absolute.dir.dir" + i));
            Assertions.assertEquals((Object)("/home/foo/path" + i), (Object)sub.getString("dir" + i));
        }
    }

    private void checkSubConfigContent() {
        Assertions.assertEquals((Object)NodeStructureHelper.table(0), (Object)this.config.getString("name"));
        List fields = this.config.getList("fields.field.name");
        ArrayList<String> expected = new ArrayList<String>();
        for (int i = 0; i < NodeStructureHelper.fieldsLength(0); ++i) {
            expected.add(NodeStructureHelper.field(0, i));
        }
        Assertions.assertEquals(expected, (Object)fields);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.parent = TestSubnodeConfiguration.setUpParentConfig();
    }

    private void setUpSubnodeConfig() {
        this.setUpSubnodeConfig(SUB_KEY);
    }

    private void setUpSubnodeConfig(String key) {
        this.config = (SubnodeConfiguration)this.parent.configurationAt(key, true);
    }

    private TrackedNodeModel setUpTrackedModel(NodeSelector selector) {
        InMemoryNodeModel parentModel = (InMemoryNodeModel)this.parent.getModel();
        parentModel.trackNode(selector, (NodeKeyResolver)this.parent);
        return new TrackedNodeModel((InMemoryNodeModelSupport)this.parent, selector, true);
    }

    @Test
    public void testAddProperty() {
        this.setUpSubnodeConfig();
        this.config.addProperty("[@table-type]", (Object)"test");
        Assertions.assertEquals((Object)"test", (Object)this.parent.getString("tables.table(0)[@table-type]"));
        this.parent.addProperty("tables.table(0).fields.field(-1).name", (Object)"newField");
        List fields = this.config.getList("fields.field.name");
        Assertions.assertEquals((int)(NodeStructureHelper.fieldsLength(0) + 1), (int)fields.size());
        Assertions.assertEquals((Object)"newField", fields.get(fields.size() - 1));
    }

    @Test
    public void testClone() {
        this.setUpSubnodeConfig();
        SubnodeConfiguration copy = (SubnodeConfiguration)this.config.clone();
        Assertions.assertNotSame((Object)this.config.getModel(), (Object)copy.getModel());
        TrackedNodeModel subModel = (TrackedNodeModel)copy.getModel();
        Assertions.assertEquals((Object)SELECTOR, (Object)subModel.getSelector());
        InMemoryNodeModel parentModel = (InMemoryNodeModel)this.parent.getModel();
        Assertions.assertEquals((Object)parentModel, (Object)subModel.getParentModel());
        parentModel.untrackNode(SELECTOR);
        parentModel.untrackNode(SELECTOR);
        Assertions.assertTrue((boolean)subModel.isReleaseTrackedNodeOnFinalize());
    }

    @Test
    public void testClose() {
        TrackedNodeModel model = (TrackedNodeModel)Mockito.mock(TrackedNodeModel.class);
        Mockito.when((Object)model.getSelector()).thenReturn((Object)SELECTOR);
        SubnodeConfiguration config = new SubnodeConfiguration(this.parent, model);
        config.close();
        ((TrackedNodeModel)Mockito.verify((Object)model)).getSelector();
        ((TrackedNodeModel)Mockito.verify((Object)model)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{model});
    }

    @Test
    public void testConfiguarationAtNoUpdates() {
        this.setUpSubnodeConfig();
        HierarchicalConfiguration sub2 = this.config.configurationAt("fields.field(1)");
        Assertions.assertEquals((Object)NodeStructureHelper.field(0, 1), (Object)sub2.getString("name"));
        this.parent.setProperty("tables.table(0).fields.field(1).name", (Object)"otherName");
        Assertions.assertEquals((Object)NodeStructureHelper.field(0, 1), (Object)sub2.getString("name"));
    }

    @Test
    public void testConfigurationAtWithUpdateSupport() {
        this.setUpSubnodeConfig();
        SubnodeConfiguration sub2 = (SubnodeConfiguration)this.config.configurationAt("fields.field(1)", true);
        Assertions.assertEquals((Object)NodeStructureHelper.field(0, 1), (Object)sub2.getString("name"));
        Assertions.assertEquals((Object)this.config, (Object)sub2.getParent());
    }

    @Test
    public void testGetKeys() {
        this.setUpSubnodeConfig();
        HashSet<String> keys = new HashSet<String>(ConfigurationAssert.keysToList((ImmutableConfiguration)this.config));
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("name", "fields.field.name")), keys);
    }

    @Test
    public void testGetNodeModel() {
        this.setUpSubnodeConfig();
        InMemoryNodeModel nodeModel = this.config.getNodeModel();
        Assertions.assertEquals((Object)"table", (Object)((ImmutableNode)nodeModel.getNodeHandler().getRootNode()).getNodeName());
    }

    @Test
    public void testGetProperties() {
        this.setUpSubnodeConfig();
        this.checkSubConfigContent();
    }

    @Test
    public void testInitSubNodeConfig() {
        this.setUpSubnodeConfig();
        Assertions.assertSame((Object)NodeStructureHelper.nodeForKey((ImmutableNode)this.parent.getModel().getNodeHandler().getRootNode(), "tables/table(0)"), (Object)this.config.getModel().getNodeHandler().getRootNode());
        Assertions.assertSame((Object)this.parent, (Object)this.config.getParent());
    }

    @Test
    public void testInitSubNodeConfigWithNullNode() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new SubnodeConfiguration(this.parent, null));
    }

    @Test
    public void testInitSubNodeConfigWithNullParent() {
        TrackedNodeModel model = this.setUpTrackedModel(SELECTOR);
        Assertions.assertThrows(IllegalArgumentException.class, () -> new SubnodeConfiguration(null, model));
    }

    @Test
    public void testInterpolation() {
        this.parent.addProperty("tablespaces.tablespace.name", (Object)"default");
        this.parent.addProperty("tablespaces.tablespace(-1).name", (Object)"test");
        this.parent.addProperty("tables.table(0).tablespace", (Object)"${tablespaces.tablespace(0).name}");
        Assertions.assertEquals((Object)"default", (Object)this.parent.getString("tables.table(0).tablespace"));
        this.setUpSubnodeConfig();
        Assertions.assertEquals((Object)"default", (Object)this.config.getString("tablespace"));
    }

    @Test
    public void testInterpolationFromConfigurationAtNoUpdateSupport() {
        this.checkInterpolationFromConfigurationAt(false);
    }

    @Test
    public void testInterpolationFromConfigurationAtWithUpdateSupport() {
        this.checkInterpolationFromConfigurationAt(true);
    }

    @Test
    public void testInterpolator() {
        this.parent.addProperty("tablespaces.tablespace.name", (Object)"default");
        this.parent.addProperty("tablespaces.tablespace(-1).name", (Object)"test");
        this.setUpSubnodeConfig();
        InterpolationTestHelper.testGetInterpolator((AbstractConfiguration)this.config);
    }

    @Test
    public void testLocalInterpolationFromConfigurationAt() {
        this.parent.addProperty("base.dir", (Object)"/home/foo");
        this.parent.addProperty("test.absolute.dir.dir1", (Object)"${base.dir}/path1");
        this.parent.addProperty("test.absolute.dir.dir2", (Object)"${dir1}");
        HierarchicalConfiguration sub = this.parent.configurationAt("test.absolute.dir");
        Assertions.assertEquals((Object)"/home/foo/path1", (Object)sub.getString("dir1"));
        Assertions.assertEquals((Object)"/home/foo/path1", (Object)sub.getString("dir2"));
    }

    @Test
    public void testLocalLookupsInInterpolatorAreInherited() {
        this.parent.addProperty("tablespaces.tablespace.name", (Object)"default");
        this.parent.addProperty("tablespaces.tablespace(-1).name", (Object)"test");
        this.parent.addProperty("tables.table(0).var", (Object)"${brackets:x}");
        ConfigurationInterpolator interpolator = this.parent.getInterpolator();
        interpolator.registerLookup("brackets", key -> "(" + key + ")");
        this.setUpSubnodeConfig();
        Assertions.assertEquals((Object)"(x)", (Object)this.config.getString("var", ""));
    }

    @Test
    public void testParentChangeDetach() {
        this.setUpSubnodeConfig();
        this.parent.clear();
        this.checkSubConfigContent();
    }

    @Test
    public void testParentChangeDetatchException() {
        this.setUpSubnodeConfig();
        this.parent.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        this.parent.addProperty("newProp", (Object)"value");
        this.checkSubConfigContent();
    }

    @Test
    public void testSetExpressionEngine() {
        this.parent.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        this.setUpSubnodeConfig("tables/table[1]");
        Assertions.assertEquals((Object)NodeStructureHelper.field(0, 1), (Object)this.config.getString("fields/field[2]/name"));
        Set<String> keys = ConfigurationAssert.keysToSet((ImmutableConfiguration)this.config);
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("name", "fields/field/name")), keys);
        this.config.setExpressionEngine(null);
        Assertions.assertInstanceOf(XPathExpressionEngine.class, (Object)this.parent.getExpressionEngine());
    }

    @Test
    public void testSetListDelimiterHandler() {
        DefaultListDelimiterHandler handler1 = new DefaultListDelimiterHandler('/');
        DefaultListDelimiterHandler handler2 = new DefaultListDelimiterHandler(';');
        this.parent.setListDelimiterHandler((ListDelimiterHandler)handler1);
        this.setUpSubnodeConfig();
        this.parent.setListDelimiterHandler((ListDelimiterHandler)handler2);
        Assertions.assertEquals((Object)handler1, (Object)this.config.getListDelimiterHandler());
        this.config.addProperty("newProp", (Object)"test1,test2/test3");
        Assertions.assertEquals((Object)"test1,test2", (Object)this.parent.getString("tables.table(0).newProp"));
        this.config.setListDelimiterHandler(DisabledListDelimiterHandler.INSTANCE);
        Assertions.assertEquals((Object)handler2, (Object)this.parent.getListDelimiterHandler());
    }

    @Test
    public void testSetProperty() {
        this.setUpSubnodeConfig();
        this.config.setProperty(null, (Object)"testTable");
        this.config.setProperty("name", (Object)(NodeStructureHelper.table(0) + "_tested"));
        Assertions.assertEquals((Object)"testTable", (Object)this.parent.getString(SUB_KEY));
        Assertions.assertEquals((Object)(NodeStructureHelper.table(0) + "_tested"), (Object)this.parent.getString("tables.table(0).name"));
        this.parent.setProperty("tables.table(0).fields.field(1).name", (Object)"testField");
        Assertions.assertEquals((Object)"testField", (Object)this.config.getString("fields.field(1).name"));
    }

    @Test
    public void testSetThrowExceptionOnMissing() {
        this.parent.setThrowExceptionOnMissing(true);
        this.setUpSubnodeConfig();
        Assertions.assertTrue((boolean)this.config.isThrowExceptionOnMissing());
        Assertions.assertThrows(NoSuchElementException.class, () -> this.config.getString("non existing key"));
    }

    @Test
    public void testSetThrowExceptionOnMissingAffectsParent() {
        this.parent.setThrowExceptionOnMissing(true);
        this.setUpSubnodeConfig();
        this.config.setThrowExceptionOnMissing(false);
        Assertions.assertTrue((boolean)this.parent.isThrowExceptionOnMissing());
    }
}

