/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.PatternSubtreeConfigurationWrapper;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.apache.commons.configuration2.tree.xpath.XPathExpressionEngine;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestPatternSubtreeConfiguration {
    private static final File CONFIG_FILE = ConfigurationAssert.getTestFile("testPatternSubtreeConfig.xml");
    private static final String PATTERN = "BusinessClient[@name='${sys:Id}']";
    private XMLConfiguration conf;

    @BeforeEach
    public void setUp() throws Exception {
        this.conf = new XMLConfiguration();
        new FileHandler((FileBased)this.conf).load(CONFIG_FILE);
    }

    @Test
    public void testMultiConfiguration() {
        PatternSubtreeConfigurationWrapper config = new PatternSubtreeConfigurationWrapper((HierarchicalConfiguration)this.conf, PATTERN);
        config.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        System.setProperty("Id", "1001");
        Assertions.assertEquals((int)15, (int)config.getInt("rowsPerPage"));
        System.setProperty("Id", "1002");
        Assertions.assertEquals((int)25, (int)config.getInt("rowsPerPage"));
        System.setProperty("Id", "1003");
        Assertions.assertEquals((int)35, (int)config.getInt("rowsPerPage"));
    }

    @Test
    public void testReadNotFileBased() {
        BaseHierarchicalConfiguration hc = new BaseHierarchicalConfiguration();
        PatternSubtreeConfigurationWrapper config = new PatternSubtreeConfigurationWrapper((HierarchicalConfiguration)hc, PATTERN);
        FileHandler fileHandler = new FileHandler((FileBased)config);
        Assertions.assertThrows(ConfigurationException.class, () -> fileHandler.load(CONFIG_FILE));
    }

    @Test
    public void testSaveNotFileBased() {
        BaseHierarchicalConfiguration hc = new BaseHierarchicalConfiguration();
        PatternSubtreeConfigurationWrapper config = new PatternSubtreeConfigurationWrapper((HierarchicalConfiguration)hc, PATTERN);
        FileHandler fileHandler = new FileHandler((FileBased)config);
        StringWriter writer = new StringWriter();
        Assertions.assertThrows(ConfigurationException.class, () -> fileHandler.save((Writer)writer));
    }
}

