/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.avro.mapred.AvroAsTextRecordReader;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class AvroAsTextInputFormat
extends FileInputFormat<Text, Text> {
    protected FileStatus[] listStatus(JobConf job) throws IOException {
        if (job.getBoolean("avro.mapred.ignore.inputs.without.extension", true)) {
            ArrayList<FileStatus> result = new ArrayList<FileStatus>();
            for (FileStatus file : super.listStatus(job)) {
                if (!file.getPath().getName().endsWith(".avro")) continue;
                result.add(file);
            }
            return result.toArray(new FileStatus[0]);
        }
        return super.listStatus(job);
    }

    public RecordReader<Text, Text> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        reporter.setStatus(split.toString());
        return new AvroAsTextRecordReader(job, (FileSplit)split);
    }
}

